/**************************************************************************
 * FILE PURPOSE	:  	Raw Ethernet Channel Management Object 
 **************************************************************************
 * FILE NAME	:   rawethif.h
 * 
 * DESCRIPTION	:
 *  The file contains defintions and structures which describe the Raw
 *  Ethernet Channel Management Object.
 * 	
 *	(C) Copyright 2008, Texas Instruments, Inc.
 *************************************************************************/

#ifndef _C_RAWETHIF_INC
#define _C_RAWETHIF_INC

#ifdef _INCLUDE_NIMU_CODE

/*  Well Known Ethernet Types. These cannot be overriden by
 *  the application.
 */
#define     ETHERTYPE_IP            0x800
#define     ETHERTYPE_IPv6          0x806
#define     ETHERTYPE_VLAN          0x8100
#define     ETHERTYPE_PPPOECTL      0x8863
#define     ETHERTYPE_PPPOEDATA     0x8864

/** 
 * @brief 
 *  The structure describes the RAW Ethernet Statistics block.
 *
 * @details
 *  This structure is used to hold various stats and
 *  counters by the Raw ethernet channel management module. 
 */
typedef struct _rawethstat {
    /**
     * @brief   Total Raw Eth packets received by the Raw Eth
     *          Channel Mgmt Module.
     */
    UINT32      RcvTotal;       

    /**
     * @brief   Number of Raw Eth packets dropped by this module because
     *          of errors.
     */
    UINT32      RcvDrops;        

    /**
     * @brief   Total packets sent successfully by Raw Eth Module.
     */
    UINT32      SndTotal;       

    /**
     * @brief   Number of Sends failed due to memory allocation errors
     */
    UINT32      SndNoPacket;

} RAWETHSTATS;

/* Raw ethernet stats instance */
extern RAWETHSTATS raweths;

/********************************************************************** 
 * Exported API (KERNEL MODE):
 *  These functions are exported by the Raw Ethernet Module and 
 *  are available only for NDK stack internal usage.
 ***********************************************************************/
_extern int RawEthTxPacket (HANDLE hRawEthSock, char* pBuffer, int len);
_extern int RawEthTxPacketNC (HANDLE hRawEthSock, char* pBuffer, int len, HANDLE hPkt);
_extern int RawEthRxPacket (PBM_Handle hPkt);

#endif /* _INCLUDE_NIMU_CODE */

#endif /* _C_RAWETHIF_INC */
