#-*- coding: utf-8 -*-

from __future__ import unicode_literals

from django.db import models
from users.models import School

class Category(models.Model):
	school = models.ForeignKey(School, on_delete=models.CASCADE)
	gender = models.CharField(max_length=20)
	season = models.CharField(max_length=20)

def uploadProductFile(instance, filename):
	return filename

class Coordi(models.Model):
    name = models.CharField(max_length=20)
    collar = models.CharField(max_length=10)
    fabric = models.CharField(max_length=10)
    color = models.CharField(max_length=10)
    code = models.CharField(max_length=10)
    xml = models.FileField(upload_to=uploadProductFile, null=True)
    GENDER_CHOICES = (
        ('B', u'남성'),
        ('G', u'여성')
    )
    gender = models.CharField(max_length=1, choices=GENDER_CHOICES)
    SEASON_CHOICES = (
        ('W', u'동복'),
        ('S', u'하복'),
        ('A', u'생활복')
    )
    season = models.CharField(max_length=1, choices=SEASON_CHOICES)

class Product(models.Model):
	name = models.CharField(max_length=20)
	coordi = models.ForeignKey(Coordi, on_delete=models.CASCADE)
	index = models.IntegerField()

	def __unicode__(self):
		return self.name


class Detail(models.Model):
	product = models.ForeignKey(Product, on_delete=models.CASCADE)
	name = models.CharField(max_length=20)
	index = models.IntegerField()

	def __unicode__(self):
		return self.name

class Style(models.Model):
	detail = models.ForeignKey(Detail, on_delete=models.CASCADE)
	name = models.CharField(max_length=20, null=True)
	thumb = models.ImageField(upload_to=uploadProductFile)
	index = models.IntegerField()

	def __unicode__(self):
		return self.name

class FabricGroup(models.Model):
	name = models.CharField(max_length=128)
	coordi = models.ForeignKey(Coordi, on_delete=models.CASCADE)
	code = models.CharField(max_length=10)

	def __unicode__(self):
		return self.name

def uploadFabricImage(instance, filename):
	return filename

class Fabric(models.Model):
	name = models.CharField(max_length=128)
	thumb = models.ImageField(upload_to=uploadFabricImage)
	fabricGroup = models.ForeignKey(FabricGroup, on_delete=models.CASCADE)
	code = models.CharField(max_length=10)

	def __unicode__(self):
		return self.name

class Grid(models.Model):
	fabric = models.ForeignKey(Fabric, on_delete=models.CASCADE)
	fabricGroup = models.ForeignKey(FabricGroup, on_delete=models.CASCADE)
	style = models.ForeignKey(Style, on_delete=models.CASCADE)
	groupCode = models.CharField(max_length=20)
	clothCode = models.CharField(max_length=128)
	gridIndex = models.IntegerField(null=True)
	pngPath = models.ImageField(upload_to=uploadProductFile)


class Design(models.Model):
	name = models.CharField(max_length=20, null=True)
	coordi = models.ForeignKey(Coordi, on_delete=models.CASCADE)
	thumb = models.ImageField(upload_to=uploadProductFile)
	date = models.DateTimeField(auto_now_add=True, blank=True)
	origin = models.BooleanField(default=False)
	favorite_design = models.ManyToManyField(
		School,
		blank=True,
		related_name='favorite_design',
		through='FavoriteDesign',
	)
	selected_design = models.ManyToManyField(
		School,
		blank=True,
		related_name='selected_design',
		through='SelectedDesign',
	)
	offer_design = models.ManyToManyField(
		School,
		blank=True,
		related_name='offer_design',
		through='OfferDesign',
	)
	favoriteCount = models.IntegerField(default=0)
	selectedCount = models.IntegerField(default=0)
	uploader = models.CharField(max_length=20, null=True)
	memo = models.TextField(null=True)
	schoolUsed = models.BooleanField(default=False)
	orderCode = models.CharField(max_length=20, default='')

	def __unicode__(self):
		return self.name

class SelectedGrid(models.Model):
	grid = models.ForeignKey(Grid, on_delete=models.CASCADE)
	design = models.ForeignKey(Design, on_delete=models.CASCADE)

class FavoriteDesign(models.Model):
	school = models.ForeignKey(School, on_delete=models.CASCADE)
	design = models.ForeignKey(Design, on_delete=models.CASCADE)

class SelectedDesign(models.Model):
	school = models.ForeignKey(School, on_delete=models.CASCADE)
	design = models.ForeignKey(Design, on_delete=models.CASCADE)

class OfferDesign(models.Model):
	school = models.ForeignKey(School, on_delete=models.CASCADE)
	design = models.ForeignKey(Design, on_delete=models.CASCADE)