from django.conf.urls import include, url
from django.views.decorators.csrf import csrf_exempt

from django.views.static import serve
from django.conf import settings


from viewer import views as viewer
from users import views as users
from product import views as product
from fabric import views as fabric
from board import views as board
from category import views as category
# Uncomment the next two lines to enable the admin:
# from django.contrib import admin
# admin.autodiscover()

urlpatterns = [
    # Examples:
    # url(r'^$', 'elite.views.home', name='home'),
    # url(r'^elite/', include('elite.foo.urls')),

    # Uncomment the admin/doc line below to enable admin documentation:
    # url(r'^admin/doc/', include('django.contrib.admindocs.urls')),

    # Uncomment the next line to enable the admin:
    # url(r'^admin/', include(admin.site.urls)),
        url(r'^media/(?P<path>.*)$', serve, {'document_root': settings.MEDIA_ROOT}),
]

urlpatterns += [
    url(r'^$', viewer.viewer),
    url(r'^manager/design_school$', viewer.manageDesignSchool),
    url(r'^manager/design_search$', viewer.manageDesignSearch),
    url(r'^manager/fabric$', viewer.manageFabric),
    url(r'^manager/school$', viewer.manageSchool),
    url(r'^manager/user$', viewer.manageUser),
    url(r'^design_offer_list$', viewer.design_offer_list),
    url(r'^design_offer_view$', viewer.design_offer_view),
    url(r'^design_current_list$', viewer.design_current_list),
    url(r'^design_current_view$', viewer.design_current_view),
    url(r'^mypage_school_favorite$', viewer.mypage_school_favorite),
    url(r'^mypage_school_selected$', viewer.mypage_school_selected),
]

urlpatterns += [
    url(r'^login$', users.loginPage),
    url(r'^loginSite$', users.loginSite),
    url(r'^loginAjax$', users.loginAjax),
    url(r'^manager/signup$', users.signupPage),
    url(r'^manager/signupSite$', users.signupSite),
    url(r'^logout$', users.Logout),
    url(r'^manager/agency$', users.getAgencyList),
    url(r'^manager/createAgencyPage$', users.createAgencyPage),
    url(r'^manager/createAgency$', users.createAgency),
    url(r'^manager/createSchoolPage$', users.createSchoolPage),
    url(r'^manager/createSchool$', users.createSchool),
    url(r'^manager/modifyUserPage$', users.modifyUserPage),
    url(r'^manager/modifyUser$', users.modifyUser),
    url(r'^manager/detailAgencyPage$', users.detailAgencyPage),
    url(r'^manager/modifyAgencyPage$', users.modifyAgencyPage),
    url(r'^manager/modifyAgency$', users.modifyAgency),
    url(r'^manager/agencyAddSchoolPage$', users.agencyAddSchoolPage),
    url(r'^manager/agencyAddSchoolList$', users.agencyAddSchoolList),
    url(r'^manager/agencyAddSchool$', users.agencyAddSchool),
    url(r'^manager/agencyLinkedSchoolPage$', users.agencyLinkedSchoolPage),
    url(r'^manager/agencyLinkedSchoolList$', users.agencyLinkedSchoolList ),
    url(r'^manager/agencyDelSchool$', users.agencyDelSchool),
    url(r'^manager/getSidoList$', users.getSidoList),
    url(r'^manager/getGuList$', users.getGuList),
	url(r'^manager/delete$', users.deleteModel),
    url(r'^simulation$', users.simulation),
    url(r'^simulation/(?P<design_id>\d+)/$', users.simulation),
    url(r'^manager/modifySchoolPage$', users.modifySchoolPage),
    url(r'^manager/modifySchool$', users.modifySchool),
    url(r'^manager/schoolListPage$', users.getManagerSchoolList),
    url(r'^manager/manageSchoolDetail$', users.manageSchoolDetail),
    url(r'^manager/manageSchoolUpdate$', users.manageSchoolUpdate),
    url(r'^manager/userListPage$', users.getManagerUserList),
]

urlpatterns += [
 url(r'^getproductlist$', product.getProductList),
 url(r'^getselectedgridlist$', product.getSelectedGridList),
 url(r'^createproduct$', csrf_exempt(product.createProduct)),
 url(r'^getfabriclist$', product.getFabricList),
 url(r'^changegrid$', product.changeGrid),
 url(r'^savedesign$', product.saveDesign),
 url(r'^changegender$', product.changeGender),
 url(r'^createdesignthumbnail$', product.createDesignThumbnail),
 url(r'^simulation/getschoollist$', product.getSchoolList),
]

urlpatterns += [
    url(r'^insertFabricInfomation$', fabric.insertFabricInfomation),
    url(r'^getfabricinformation$', fabric.getFabricInformation),
    url(r'^updateFabricInformation$', fabric.updateFabricInformation),
    url(r'^deleteFabricInformation$', fabric.deleteFabricInformation),
    url(r'^fabricInformationList$', fabric.fabricInformationList),
    url(r'^fabricInformationList/page/(?P<page>\d+)$', fabric.fabricInformationList),
]

urlpatterns += [
    url(r'^mypage_consult_list$', board.mypage_consult_list),
    url(r'^consult/getSchoolList$', board.mypageConsultGetSchoolList),
    url(r'^consult/saveConsult$', board.saveConsult),
    url(r'^consult/modifyConsult$', board.modifyConsult),
    url(r'^consult/deleteConsult$', board.deleteConsult),
    url(r'^consult/getDetailConsult$', board.getDetailConsult),
    url(r'^mypage_school$', board.mypage_school),
    url(r'^mypage_school/getSchoolList$', board.mypageSchoolGetSchoolList),
    url(r'^mypage_school/deleteDesign$', board.deleteDesign),
    url(r'^mypage_school_eliteoffer$', board.mypage_school_eliteoffer),
    url(r'^mypage_school_eliteoffer/addFavoriteDesign$', board.addFavoriteDesign),
    url(r'^mypage_school_eliteoffer/addSelectedDesign$', board.addSelectedDesign),
    url(r'^design_current_list/getSelectedDesignList$', board.getSelectedDesignList),
    url(r'^design_offer_list/getOfferDesignList$', board.getOfferDesignList),
    url(r'^design_offer_list/getCategoryList$', board.getCategoryList),
    url(r'^design_view$', board.design_view),
    url(r'^design_view/makeSchoolDesignLink$', board.makeSchoolDesignLink),
    url(r'^manager$', board.manageDesign),
    url(r'^manager/design$', board.manageDesign),
    url(r'^manager/detailDesignPage$', board.detailDesignPage),
    url(r'^manager/manageSchoolDesignList$', board.schoolDesignList),
    url(r'^manager/manageSchoolDesignDetail$', board.schoolDesignDetail),
    url(r'^manager/designDelete$', board.designDelete),
    url(r'^manager/addOfferDesignPage$', board.addOfferDesignPage),
    url(r'^manager/addOfferDesign$', board.addOfferDesign),
    url(r'^manager/saveDesignMemo$', board.saveDesignMemo),
    url(r'^manager/designSchoolUsedChange$', board.designSchoolUsedChange),
]


urlpatterns += [
   url(r'^manager/design/createCategory$', category.saveCategory),
   url(r'^manager/design/updateCategory$', category.updateCategory),
   url(r'^manager/design/deleteCategory$', category.deleteCategory),
   url(r'^manager/design/getCategoryList$', category.getCategoryList),
   url(r'^manager/design/getCategoryInfo$', category.getCategoryInfo),
]
