# -*- coding:utf-8 -*-
from django.template import RequestContext
from django.shortcuts import render_to_response, get_object_or_404
from django.http import HttpResponseRedirect, HttpResponse, Http404
from django.views.decorators.csrf import csrf_exempt
from django.contrib.auth import authenticate, login, logout
from django.contrib.auth.models import User, Permission
from django.core import serializers
from users.models import School
import json
from django.core.urlresolvers import reverse

NOT_LOGIN_MSG = '로그인 해 주세요'

def viewer(request):
	if request.user.is_authenticated():
		user = request.session['user']
		userinformation = request.session['userinformation']
		return render_to_response('published/main.html', {'user':user, 'userinfo':userinformation})
	return render_to_response('published/login.html')

# def manageDesign(request):
# 	if request.user.is_authenticated():
# 		user = request.session['user']
# 		userinformation = request.session['userinformation']
# 		if(userinformation.userAuthority > 2):
# 			return render_to_response('published/main.html', {'user': user, 'userinfo': userinformation, 'permissionError': '권한이없습니다 관리자에게 문의해보세요'})
# 		return render_to_response('pages/managedesign.html', {'user': user, 'userinfo': userinformation})
# 	else:
# 		variables = {'error': NOT_LOGIN_MSG}
# 		return render_to_response('pages/errorPage.html', RequestContext(request, variables))

def manageDesignSchool(request):
    if request.user.is_authenticated():
        user = request.session['user']
        userinformation = request.session['userinformation']
        if (userinformation.userAuthority > 2):
            return render_to_response('published/main.html', {'user': user, 'userinfo': userinformation,
                                                              'permissionError': '권한이없습니다 관리자에게 문의해보세요'})
        return render_to_response('pages/managedesign_school.html', {'user': user, 'userinfo': userinformation})
    else:
        variables = {'error': NOT_LOGIN_MSG}
        return render_to_response('pages/errorPage.html', RequestContext(request, variables))

def manageDesignSearch(request):
    if request.user.is_authenticated():
        user = request.session['user']
        userinformation = request.session['userinformation']
        if (userinformation.userAuthority > 2):
            return render_to_response('published/main.html', {'user': user, 'userinfo': userinformation,
                                                              'permissionError': '권한이없습니다 관리자에게 문의해보세요'})
        return render_to_response('pages/managedesign_search.html', {'user': user, 'userinfo': userinformation})
    else:
        variables = {'error': NOT_LOGIN_MSG}
        return render_to_response('pages/errorPage.html', RequestContext(request, variables))

def manageFabric(request):
	if request.user.is_authenticated():
		user = request.session['user']
		userinformation = request.session['userinformation']
		if(userinformation.userAuthority > 2):
			return render_to_response('published/main.html', {'user': user, 'userinfo': userinformation, 'permissionError': '권한이없습니다 관리자에게 문의해보세요'})
		return render_to_response('pages/managefabric.html', {'user': user, 'userinfo': userinformation})
	else:
		variables = {'error': NOT_LOGIN_MSG}
		return render_to_response('pages/errorPage.html', RequestContext(request, variables))

def manageSchool(request):
	if request.user.is_authenticated():
		user = request.session['user']
		userinformation = request.session['userinformation']
		if(userinformation.userAuthority > 1):
			return render_to_response('published/main.html', {'user': user, 'userinfo': userinformation, 'permissionError': '권한이없습니다 관리자에게 문의해보세요'})
		return render_to_response('pages/manageschool.html', {'user': user, 'userinfo': userinformation})
	else:
		variables = {'error': NOT_LOGIN_MSG}
		return render_to_response('pages/errorPage.html', RequestContext(request, variables))

def manageUser(request):
	if request.user.is_authenticated():
		user = request.session['user']
		userinformation = request.session['userinformation']
		if(userinformation.userAuthority > 1):
			return render_to_response('published/main.html', {'user': user, 'userinfo': userinformation, 'permissionError': '권한이없습니다 관리자에게 문의해보세요'})
		return render_to_response('pages/manageuser.html', {'user': user, 'userinfo': userinformation})
	else:
		variables = {'error': NOT_LOGIN_MSG}
		return render_to_response('pages/errorPage.html', RequestContext(request, variables))

def design_offer_list(request):
	if request.user.is_authenticated():
		user = request.session['user']
		userinformation = request.session['userinformation']
		if(userinformation.userAuthority > 3):
			return render_to_response('published/main.html', {'user': user, 'userinfo': userinformation, 'permissionError': '권한이없습니다 관리자에게 문의해보세요'})

		try:
			mainLinkCategory = int(request.POST['mainLinkCategory'])
		except:
			mainLinkCategory = 0

		return render_to_response('published/design_offer_list.html', {'user': user, 'userinfo': userinformation, 'mainLinkCategory': mainLinkCategory})
	else:
		variables = {'error': NOT_LOGIN_MSG}
		return render_to_response('pages/errorPage.html', RequestContext(request, variables))


def design_offer_view(request):
	if request.user.is_authenticated():
		user = request.session['user']
		userinformation = request.session['userinformation']
		if(userinformation.userAuthority > 3):
			return render_to_response('published/main.html', {'user': user, 'userinfo': userinformation, 'permissionError': '권한이없습니다 관리자에게 문의해보세요'})
		return render_to_response('published/design_offer_view.html', {'user': user, 'userinfo': userinformation})
	else:
		variables = {'error': NOT_LOGIN_MSG}
		return render_to_response('pages/errorPage.html', RequestContext(request, variables))


def design_current_list(request):
	if request.user.is_authenticated():
		user = request.session['user']
		userinformation = request.session['userinformation']
		if (userinformation.userAuthority > 3):
			return render_to_response('published/main.html', {'user': user, 'userinfo': userinformation, 'permissionError': '권한이없습니다 관리자에게 문의해보세요'})

		return render_to_response('published/design_current_list.html', {'user': user, 'userinfo': userinformation})
	else:
		variables = {'error': NOT_LOGIN_MSG}
		return render_to_response('pages/errorPage.html', RequestContext(request, variables))


def design_current_view(request):
	if request.user.is_authenticated():
		user = request.session['user']
		userinformation = request.session['userinformation']
		if (userinformation.userAuthority > 3):
			return render_to_response('published/main.html', {'user': user, 'userinfo': userinformation, 'permissionError': '권한이없습니다 관리자에게 문의해보세요'})
		return render_to_response('published/design_current_view.html', {'user': user, 'userinfo': userinformation})
	else:
		variables = {'error': NOT_LOGIN_MSG}
		return render_to_response('pages/errorPage.html', RequestContext(request, variables))


def mypage_school(request):
	if request.user.is_authenticated():
		user = request.session['user']
		userinformation = request.session['userinformation']
		if (userinformation.userAuthority > 3):
			return render_to_response('published/main.html', {'user': user, 'userinfo': userinformation, 'permissionError': '권한이없습니다 관리자에게 문의해보세요'})
		return render_to_response('published/mypage_school.html', {'user': user, 'userinfo': userinformation})
	else:
		variables = {'error': NOT_LOGIN_MSG}
		return render_to_response('pages/errorPage.html', RequestContext(request, variables))


# def mypage_consult_list(request):
# 	if request.user.is_authenticated():
# 		user = request.session['user']
# 		userinformation = request.session['userinformation']
# 		return render_to_response('published/mypage_consult_list.html', {'user': user, 'userinfo': userinformation})
# 	else:
# 		variables = {'error': NOT_LOGIN_MSG}
# 		return render_to_response('pages/errorPage.html', RequestContext(request, variables))


# def mypage_school_eliteoffer(request):
# 	if request.user.is_authenticated():
# 		user = request.session['user']
# 		userinformation = request.session['userinformation']
# 		if (userinformation.userAuthority > 3):
# 			return render_to_response('published/main.html', {'user': user, 'userinfo': userinformation, 'permissionError': '권한이없습니다 관리자에게 문의해보세요'})
# 		return render_to_response('published/mypage_school_eliteoffer.html', {'user': user, 'userinfo': userinformation})
# 	else:
# 		variables = {'error': NOT_LOGIN_MSG}
# 		return render_to_response('pages/errorPage.html', RequestContext(request, variables))


def mypage_school_favorite(request):
	if request.user.is_authenticated():
		user = request.session['user']
		userinformation = request.session['userinformation']
		if (userinformation.userAuthority > 3):
			return render_to_response('published/main.html', {'user': user, 'userinfo': userinformation, 'permissionError': '권한이없습니다 관리자에게 문의해보세요'})
		return render_to_response('published/mypage_school_favorite.html', {'user': user, 'userinfo': userinformation})
	else:
		variables = {'error': NOT_LOGIN_MSG}
		return render_to_response('pages/errorPage.html', RequestContext(request, variables))


def mypage_school_selected(request):
	if request.user.is_authenticated():
		user = request.session['user']
		userinformation = request.session['userinformation']
		if (userinformation.userAuthority > 3):
			return render_to_response('published/main.html', {'user': user, 'userinfo': userinformation, 'permissionError': '권한이없습니다 관리자에게 문의해보세요'})
		return render_to_response('published/mypage_school_selected.html', {'user': user, 'userinfo': userinformation})
	else:
		variables = {'error': NOT_LOGIN_MSG}
		return render_to_response('pages/errorPage.html', RequestContext(request, variables))
