# -*- coding:utf-8 -*-
import datetime
from django.shortcuts import render, render_to_response
from django.http import HttpResponseRedirect, HttpResponse, Http404
from django.template import RequestContext
from django.core import serializers
import json
import math
import shutil
import os
import settings

from category.models import *
from board.models import *
from fabric.models import FabricInformation
from users.models import *
from product.models import *
from viewer import paging

NOT_LOGIN_MSG = '로그인 해 주세요'

# mypage - 상담리스트 탐색
# category 값이 없다면 전체검색
def mypage_consult_list(request):
	if request.user.is_authenticated():
		user = request.session['user']
		userinformation = request.session['userinformation']
		if (userinformation.userAuthority > 3):
			return render_to_response('published/main.html', {'user': user, 'userinfo': userinformation,
															  'permissionError': '권한이없습니다 관리자에게 문의해보세요'})

		# try except로 전달받지 못한 값엔 기본값을 넣어준다
		try:
			page = request.POST['page']
		except:
			page = 1
		page = int(page)
		perPage = 5
		startPos = (page - 1) * perPage
		endPos = startPos + perPage

		try:
			category = request.POST['category']
		except:
			category = 0

		try:
			searchValue = request.POST['searchValue']
		except:
			searchValue = ''

		category = int(category)

		# admin 계정일 경우 모든 상담리스트를 받는다
		# 카테고리의 값으로 검색기준 설정
		# ( | )  <- 합집합 검색
		if category == 0:
			print '전체검색'

			if (userinformation.userAuthority == 1):
				totalCount = (
				ConsultBoard.objects.filter(schoolId__schoolName__contains=searchValue) | ConsultBoard.objects.filter(
					content__contains=searchValue)).order_by('-id').__len__()
			else:
				totalCount = (ConsultBoard.objects.filter(schoolId__schoolName__contains=searchValue, schoolId__agencyId__users__id=user.id) | ConsultBoard.objects.filter(content__contains=searchValue, schoolId__agencyId__users__id=user.id)).order_by('-id').__len__()

			totalPage = totalCount / perPage
			if (totalCount % perPage) > 0:
				totalPage = totalPage + 1
			if totalPage < page:
				page = totalPage

			if (userinformation.userAuthority == 1):
				consultObjList = (
				ConsultBoard.objects.filter(schoolId__schoolName__contains=searchValue) | ConsultBoard.objects.filter(
					content__contains=searchValue)).order_by('-id')
			else:
				consultObjList = (ConsultBoard.objects.filter(schoolId__schoolName__contains=searchValue, schoolId__agencyId__users__id=user.id) | ConsultBoard.objects.filter(content__contains=searchValue, schoolId__agencyId__users__id=user.id)).order_by('-id')[startPos:endPos]


		elif category == 1:
			print '학교검색'

			if (userinformation.userAuthority == 1):
				totalCount = (
					ConsultBoard.objects.filter(
						schoolId__schoolName__contains=searchValue) | ConsultBoard.objects.filter(
						content__contains=searchValue)).order_by('-id').__len__()
			else:
				totalCount = ConsultBoard.objects.filter(schoolId__schoolName__contains=searchValue, schoolId__agencyId__users__id=user.id).order_by('-id').__len__()

			totalPage = totalCount / perPage
			if (totalCount % perPage) > 0:
				totalPage = totalPage + 1
			if totalPage < page:
				page = totalPage

			if (userinformation.userAuthority == 1):
				consultObjList = (
					ConsultBoard.objects.filter(
						schoolId__schoolName__contains=searchValue) | ConsultBoard.objects.filter(
						content__contains=searchValue)).order_by('-id')
			else:
				consultObjList = ConsultBoard.objects.filter(schoolId__schoolName__contains=searchValue, schoolId__agencyId__users__id=user.id).order_by('-id')[startPos:endPos]


		elif category == 2:
			print '내용검색'
			if (userinformation.userAuthority == 1):
				totalCount = (
					ConsultBoard.objects.filter(
						schoolId__schoolName__contains=searchValue) | ConsultBoard.objects.filter(
						content__contains=searchValue)).order_by('-id').__len__()
			else:
				totalCount = ConsultBoard.objects.filter(content__contains=searchValue, schoolId__agencyId__users__id=user.id).order_by('-id').__len__()

			totalPage = totalCount / perPage
			if (totalCount % perPage) > 0:
				totalPage = totalPage + 1
			if totalPage < page:
				page = totalPage

			if (userinformation.userAuthority == 1):
				consultObjList = (
					ConsultBoard.objects.filter(
						schoolId__schoolName__contains=searchValue) | ConsultBoard.objects.filter(
						content__contains=searchValue)).order_by('-id')
			else:
				consultObjList = ConsultBoard.objects.filter(content__contains=searchValue, schoolId__agencyId__users__id=user.id).order_by('-id')[startPos:endPos]


		else:
			print ' 0, 1, 2 가 아닌 다른 카테고리 값을 전달받은 경우 '

		consultList = []
		for consult in consultObjList:
			school = School.objects.get(id=consult.schoolId_id)
			try:
				agencyName = Agency.objects.get(id=school.agencyId_id).agencyName
			except:
				agencyName = '담당대리점 없음'
			consultList.append({
				"no": consult.id,
				"agencyName":agencyName,
				"schoolName": school.schoolName,
				"schoolId": school.id,
				"season": '미정',
				"date": consult.date.today().strftime("%Y%m%d"),
				"selectedDesign": '미정',
				"content": consult.content,
			})

		return render_to_response('published/mypage_consult_list.html',
								  {
									  'user': user, 'userinfo': userinformation,
									  'consultList': consultList,
									  "current": page,
									  "max": totalPage,
									  "searchValue": searchValue,
									  "category": category
								  })
	else:
		variables = {'error': NOT_LOGIN_MSG}
		return render_to_response('pages/errorPage.html', RequestContext(request, variables))


# mypage - 상담내용 작성 - 학교리스트 탐색
# 중고등 selectbox선택 후 동작,  현재 유저와 연계된 학교의 정보를 탐색
def mypageConsultGetSchoolList(request):
	if request.user.is_authenticated():
		user = request.session['user']
		userinformation = request.session['userinformation']
		if (userinformation.userAuthority > 3):
			return render_to_response('published/main.html', {'user': user, 'userinfo': userinformation,
															  'permissionError': '권한이없습니다 관리자에게 문의해보세요'})
		try:
			grade = int(request.POST['grade'])
		except KeyError:
			grade = 0

		try:
			designId = int(request.POST['designId'])
		except KeyError:
			designId = 0
			schoolListObject = School.objects.filter(grade=grade, agencyId__users__id=user.id, consultboard__isnull=True)
			schoolList = serializers.serialize('json', schoolListObject)
			variables = {'schoolList': schoolList}
			return HttpResponse(json.dumps(variables, ensure_ascii=False), content_type='application/json')

		# 상담리스트 작성에서의 학교탐색은 designId의 값이 0이다.
		if designId == 0:
			schoolListObject = School.objects.filter(grade=grade, agencyId__users__id=user.id, consultboard__isnull=True)

		else:
			gender = Design.objects.get(id=designId).coordi.gender
			if gender == 'B':
				schoolListObject = School.objects.filter(grade=grade, agencyId__users__id=user.id, gender__in=['남여공학', '남자'])
			else:
				schoolListObject = School.objects.filter(grade=grade, agencyId__users__id=user.id, gender__in=['남여공학', '여자'])

		# 학교리스트가 없으면 except 발생시키고 에러메세지 담아서 리턴
		if not schoolListObject.__len__() > 0:
			raise

		schoolList = serializers.serialize('json', schoolListObject)

		variables = {'schoolList': schoolList}
		return HttpResponse(json.dumps(variables, ensure_ascii=False), content_type='application/json')


# mypage - 상담내용 작성 - 상담저장
def saveConsult(request):
	try:
		schoolId = request.POST['schoolId']
		content = request.POST['content']
		nowDate = datetime.date.today()
		ConsultBoard.objects.create(schoolId_id=schoolId, content=content, date=nowDate)
		return HttpResponseRedirect('/mypage_consult_list')
	except KeyError:
		return HttpResponse('오류가 발생했습니다. 관리자에게 문의해주세요')


# mypage - 상담 상세보기 탐색
def getDetailConsult(request):
	try:
		consultId = request.POST['consultId']

		consultObj = ConsultBoard.objects.get(id=consultId)
		school = School.objects.get(id=consultObj.schoolId_id)

		variables = {'content': consultObj.content, 'schoolName': school.schoolName, 'consultId': consultId}
		return HttpResponse(json.dumps(variables, ensure_ascii=False), content_type='application/json')

	except KeyError:
		return HttpResponse('오류가 발생했습니다. 관리자에게 문의해주세요')


# mypage - 상담 수정
def modifyConsult(request):
	try:
		consultId = request.POST['consultId']
		content = request.POST['content']
		nowDate = datetime.date.today()
		consultObj = ConsultBoard.objects.get(id=consultId)

		consultObj.content = content
		consultObj.date = nowDate
		consultObj.save()

		variables = {'msg': '수정되었습니다.', 'consultId': consultId}
		return HttpResponse(json.dumps(variables, ensure_ascii=False), content_type='application/json')
	except KeyError:
		return HttpResponse('오류가 발생했습니다. 관리자에게 문의해주세요')

# mypage - 상담 삭제
def deleteConsult(request):
	try:
		consultId = request.POST['consultId']
		consultObj = ConsultBoard.objects.get(id=consultId).delete()
		return HttpResponseRedirect('/mypage_consult_list')
	except KeyError:
		return HttpResponse('오류가 발생했습니다. 관리자에게 문의해주세요')


# mypage - 학교별제안 page호출
def mypage_school(request):
	if request.user.is_authenticated():
		user = request.session['user']
		userinformation = request.session['userinformation']
		if (userinformation.userAuthority > 3):
			return render_to_response('published/main.html', {'user': user, 'userinfo': userinformation,
															  'permissionError': '권한이없습니다 관리자에게 문의해보세요'})
		return render_to_response('published/mypage_school.html', {'user': user, 'userinfo': userinformation})
	else:
		variables = {'error': NOT_LOGIN_MSG}
		return render_to_response('pages/errorPage.html', RequestContext(request, variables))


# mypage - 학교별제안 학교리스트 탐색
def mypageSchoolGetSchoolList(request):
	if request.user.is_authenticated():
		user = request.session['user']
		userinformation = request.session['userinformation']

		# # admin 계정일 경우 모든 agency와 연계된 schoolList를 담는다.
		# if (userinformation.userAuthority == 1):
		# 	schoolListObject = School.objects.filter(agencyId_id__gt=0).order_by('-id')
		# # 관리자가 아니라면 로그인한 사용자와 연계된 agency 들과 연결된 schoolList를 담는다.
		# else:
		# 	schoolListObject = School.objects.filter(agencyId__users__id=user.id).order_by('-id')

		schoolListObject = School.objects.filter(agencyId__users__id=user.id).order_by('-id')

		totalCount = schoolListObject.__len__()

		pagingNumbers = paging.paging(int(request.POST['page']), int(request.POST['perPage']), totalCount)

		page = pagingNumbers['current']
		totalPage = pagingNumbers['totalPage']
		startPos = pagingNumbers['startPos']
		endPos = pagingNumbers['endPos']

		# schoolListPagingObject = schoolListObject.all()[startPos:endPos]

		# schoolListPaging = serializers.serialize('json', schoolListPagingObject)
		# variables = {'schoolList':schoolListPaging, 'current':page, 'max':totalPage}

		arrayCategory = int(request.POST['arrayCategory'])
		schoolList = []

		# 대리점 별로 나열 (대리점 내에서 학교이름순서로 나열)
		if arrayCategory == 0:
			agecyListObj = Agency.objects.filter(users=user.id)
			for agency in agecyListObj:
				schoolListObj = School.objects.filter(agencyId=agency).order_by('schoolName')
				for school in schoolListObj:
					schoolList.append(
						{'agencyName': agency.agencyName,
						 'schoolPosition': school.sido +' '+school.gu,
						 'schoolName': school.schoolName,
						 'schoolId': school.id,
						 'schoolGradeClass': 'sch_middle' if (school.grade == 1) else 'sch_high',
						 'boyClass': 'boy_off' if (school.gender == '여자') else 'boy',
						 'girlClass': 'girl_off' if (school.gender == '남자') else 'girl',
						 }
					)

		# 학교 이름순서대로 나열
		if arrayCategory == 1:
			schoolListObj = School.objects.filter(agencyId__users__id=user.id).order_by('schoolName')
			for school in schoolListObj:
				schoolList.append(
					{'agencyName': school.agencyId.agencyName,
					 'schoolPosition': school.sido + ' ' + school.gu,
					 'schoolName': school.schoolName,
					 'schoolId': school.id,
					 'schoolGradeClass': 'sch_middle' if (school.grade == 1) else 'sch_high',
					 'boyClass': 'boy_off' if (school.gender == '여자') else 'boy',
					 'girlClass': 'girl_off' if (school.gender == '남자') else 'girl',
					 }
				)

		# 최신순 나열
		if arrayCategory == 2:
			schoolListObj = School.objects.filter(agencyId__users__id=user.id, designUpdated__isnull=False).order_by('-designUpdated')
			nullDateFieldSchoolListObj = School.objects.filter(agencyId__users__id=user.id, designUpdated__isnull=True)
			for school in schoolListObj:
				schoolList.append(
					{'agencyName': school.agencyId.agencyName,
					 'schoolPosition': school.sido + ' ' + school.gu,
					 'schoolName': school.schoolName,
					 'schoolId': school.id,
					 'schoolGradeClass': 'sch_middle' if (school.grade == 1) else 'sch_high',
					 'boyClass': 'boy_off' if (school.gender == '여자') else 'boy',
					 'girlClass': 'girl_off' if (school.gender == '남자') else 'girl',
					 }
				)
			for school in nullDateFieldSchoolListObj:
				schoolList.append(
					{'agencyName': school.agencyId.agencyName,
					 'schoolPosition': school.sido + ' ' + school.gu,
					 'schoolName': school.schoolName,
					 'schoolId': school.id,
					 'schoolGradeClass': 'sch_middle' if (school.grade == 1) else 'sch_high',
					 'boyClass': 'boy_off' if (school.gender == '여자') else 'boy',
					 'girlClass': 'girl_off' if (school.gender == '남자') else 'girl',
					 }
				)

		# 중·고순 나열
		if arrayCategory == 3:
			schoolListObj = School.objects.filter(agencyId__users__id=user.id,).order_by('grade')
			for school in schoolListObj:
				schoolList.append(
					{'agencyName': school.agencyId.agencyName,
					 'schoolPosition': school.sido + ' ' + school.gu,
					 'schoolName': school.schoolName,
					 'schoolId': school.id,
					 'schoolGradeClass': 'sch_middle' if (school.grade == 1) else 'sch_high',
					 'boyClass': 'boy_off' if (school.gender == '여자') else 'boy',
					 'girlClass': 'girl_off' if (school.gender == '남자') else 'girl',
					 }
				)

		# 남·여순 나열
		if arrayCategory == 4:
			bSchoolListObj = School.objects.filter(agencyId__users__id=user.id, gender = '남자').order_by('schoolName')
			gSchoolListObj = School.objects.filter(agencyId__users__id=user.id, gender = '여자').order_by('schoolName')
			bgSchoolListObj = School.objects.filter(agencyId__users__id=user.id, gender = '남여공학').order_by('schoolName')
			for school in bSchoolListObj:
				schoolList.append(
					{'agencyName': school.agencyId.agencyName,
					 'schoolPosition': school.sido + ' ' + school.gu,
					 'schoolName': school.schoolName,
					 'schoolId': school.id,
					 'schoolGradeClass': 'sch_middle' if (school.grade == 1) else 'sch_high',
					 'boyClass': 'boy_off' if (school.gender == '여자') else 'boy',
					 'girlClass': 'girl_off' if (school.gender == '남자') else 'girl',
					 }
				)
			for school in gSchoolListObj:
				schoolList.append(
					{'agencyName': school.agencyId.agencyName,
					 'schoolPosition': school.sido + ' ' + school.gu,
					 'schoolName': school.schoolName,
					 'schoolId': school.id,
					 'schoolGradeClass': 'sch_middle' if (school.grade == 1) else 'sch_high',
					 'boyClass': 'boy_off' if (school.gender == '여자') else 'boy',
					 'girlClass': 'girl_off' if (school.gender == '남자') else 'girl',
					 }
				)
			for school in bgSchoolListObj:
				schoolList.append(
					{'agencyName': school.agencyId.agencyName,
					 'schoolPosition': school.sido + ' ' + school.gu,
					 'schoolName': school.schoolName,
					 'schoolId': school.id,
					 'schoolGradeClass': 'sch_middle' if (school.grade == 1) else 'sch_high',
					 'boyClass': 'boy_off' if (school.gender == '여자') else 'boy',
					 'girlClass': 'girl_off' if (school.gender == '남자') else 'girl',
					 }
				)



		variables = {'schoolList': schoolList[startPos:endPos], 'current': page, 'max': totalPage}

		return HttpResponse(json.dumps(variables, ensure_ascii=False), content_type='application/json')

	else:
		variables = {'error': NOT_LOGIN_MSG}
		return render_to_response('pages/errorPage.html', RequestContext(request, variables))

# 해당 학교 디자인 리스트 보기 (제안, 관심, 채택 범용)
def mypage_school_eliteoffer(request):
	if request.user.is_authenticated():
		user = request.session['user']
		userinformation = request.session['userinformation']
		if (userinformation.userAuthority > 3):
			return render_to_response('published/main.html', {'user': user, 'userinfo': userinformation,
															  'permissionError': '권한이없습니다 관리자에게 문의해보세요'})
		category = int(request.POST['category'])
		schoolId = request.POST['schoolId']
		schoolObj = School.objects.get(id=schoolId)
		schoolInfomation = schoolObj.sido + ' ' + schoolObj.gu + ' ' + schoolObj.schoolName

		unisex = None
		gender = ''

		if (schoolObj.gender == '남여공학'):
			print '남여공학'
			unisex = True

		try:
			consult = request.POST['consult']
		except:
			consult = None

		try:
			gender = request.POST['gender']
		except:
			if(schoolObj.gender == '남자'):
				print '남자학교'
				gender = 'B'
			elif(schoolObj.gender == '여자'):
				print '여자학교'
				gender = 'G'
			else:
				gender = 'B'


		if category == 0:
			print '엘리트제안페이지'
			winterDesignList = schoolObj.offer_design.filter(coordi__season='W', coordi__gender=gender).order_by('-id')
			summerDesignList = schoolObj.offer_design.filter(coordi__season='S', coordi__gender=gender).order_by('-id')
			casualDesignList = schoolObj.offer_design.filter(coordi__season='A', coordi__gender=gender).order_by('-id')
			variables = {
				'user': user,
				'userinfo': userinformation,
				'category': category,
				'schoolId': schoolId,
				'schoolInfomation': schoolInfomation,
				'winterDesignList': winterDesignList,
				'summerDesignList': summerDesignList,
				'casualDesignList': casualDesignList,
				'unisex': unisex,
				'gender': gender
			}
			return render_to_response('published/mypage_school_eliteoffer.html', RequestContext(request, variables))
		if category == 1:
			print '학교관심디자인'
			winterDesignList = schoolObj.favorite_design.filter(coordi__season='W', coordi__gender=gender).order_by('-id')
			summerDesignList = schoolObj.favorite_design.filter(coordi__season='S', coordi__gender=gender).order_by('-id')
			casualDesignList = schoolObj.favorite_design.filter(coordi__season='A', coordi__gender=gender).order_by('-id')
			variables = {
				'user': user,
				'userinfo': userinformation,
				'category': category,
				'schoolId': schoolId,
				'schoolInfomation': schoolInfomation,
				'winterDesignList': winterDesignList,
				'summerDesignList': summerDesignList,
				'casualDesignList': casualDesignList,
				'unisex': unisex,
				'gender': gender
			}
			return render_to_response('published/mypage_school_favorite.html', RequestContext(request, variables))
		if category == 2:
			print '채택디자인'

			try:
				selectedWinterDesign = schoolObj.selected_design.get(coordi__season='W', coordi__gender=gender)
			except:
				selectedWinterDesign = None

			try:
				selectedSummerDesign = schoolObj.selected_design.get(coordi__season='S', coordi__gender=gender)
			except:
				selectedSummerDesign = None

			try:
				selectedCasualDesign = schoolObj.selected_design.get(coordi__season='A', coordi__gender=gender)
			except:
				selectedCasualDesign = None

			variables = {
				'user': user,
				'userinfo': userinformation,
				'category': category,
				'schoolId': schoolId,
				'schoolInfomation': schoolInfomation,
				'selectedWinterDesign': selectedWinterDesign,
				'selectedSummerDesign': selectedSummerDesign,
				'selectedCasualDesign': selectedCasualDesign,
				'unisex': unisex,
				'consult': consult
			}
			return render_to_response('published/mypage_school_selected.html', RequestContext(request, variables))

	else:
		variables = {'error': NOT_LOGIN_MSG}
		return render_to_response('pages/errorPage.html', RequestContext(request, variables))


# 관심리스트 추가 기능
def addFavoriteDesign(request):

	if request.user.is_authenticated():
		user = request.session['user']
		userinformation = request.session['userinformation']
		if (userinformation.userAuthority > 3):
			return render_to_response('published/main.html', {'user': user, 'userinfo': userinformation,
															  'permissionError': '권한이없습니다 관리자에게 문의해보세요'})
		schoolId = request.POST['schoolId']
		designIds = request.POST['designIdList']
		designIdList = designIds.split(",")

		overlapDesignNames = ''
		allOverlap = True
		for designId in designIdList:
			try:
				favoriteObj = FavoriteDesign.objects.get(school_id=schoolId, design_id=designId)
				overlapDesignNames += Design.objects.get(id=favoriteObj.design_id).name + ' '
			except:
				FavoriteDesign.objects.create(school_id=schoolId, design_id=designId)
				designObj = Design.objects.get(id=designId)
				designObj.favoriteCount = designObj.favoriteCount + 1
				designObj.save()
				print '일단 이게 나오면 전부 중복은 아니다'
				allOverlap = False

		if overlapDesignNames.__len__() > 0:
			if allOverlap:
				variables = {
					'msg': '이미 관심리스트에 존재하는 디자인입니다'
				}
			else:
				variables = {
					'msg': '중복 디자인을 제외하고 관심리스트에 추가되었습니다' + '\n중복되는 디자인 : ' + overlapDesignNames
				}
		else:
			variables = {
				'msg': '관심리스트에 추가되었습니다'
			}

		# return HttpResponse(json.dumps(variables, ensure_ascii=False), content_type='application/json')
		return HttpResponse(json.dumps(variables, indent=4, ensure_ascii=False, encoding='utf-8'))

# 학교 채택디자인 지정 기능
def addSelectedDesign(request):

	if request.user.is_authenticated():
		user = request.session['user']
		userinformation = request.session['userinformation']
		if (userinformation.userAuthority > 3):
			return render_to_response('published/main.html', {'user': user, 'userinfo': userinformation,
															  'permissionError': '권한이없습니다 관리자에게 문의해보세요'})

		schoolId = request.POST['schoolId']
		gender = request.POST['gender']
		schoolObj = School.objects.get(id=schoolId)

		try:
			winterDesignId = request.POST['winterDesignId']
			try:
				originDesignObj = schoolObj.selected_design.get(coordi__season='W', coordi__gender=gender)

				winterDesignObj = Design.objects.get(id=winterDesignId)
				winterDesignObj.selectedCount = winterDesignObj.selectedCount + 1

				selectedDesignObj = SelectedDesign.objects.get(school_id=schoolId, design_id=originDesignObj.id)
				selectedDesignObj.design_id = winterDesignId
				selectedDesignObj.save()
			except:
				winterDesignObj = Design.objects.get(id=winterDesignId)
				winterDesignObj.selectedCount = winterDesignObj.selectedCount + 1
				winterDesignObj.save()
				SelectedDesign.objects.create(school_id=schoolId, design_id=winterDesignId)
		except:
			print '동복 선택안함'

		try:
			summerDesignId = request.POST['summerDesignId']
			try:
				originDesignObj = schoolObj.selected_design.get(coordi__season='S', coordi__gender=gender)

				summerDesignObj = Design.objects.get(id=summerDesignId)
				summerDesignObj.selectedCount = summerDesignObj.selectedCount + 1

				selectedDesignObj = SelectedDesign.objects.get(school_id=schoolId, design_id=originDesignObj.id)
				selectedDesignObj.design_id = summerDesignId
				selectedDesignObj.save()
			except:
				summerDesignObj = Design.objects.get(id=summerDesignId)
				summerDesignObj.selectedCount = summerDesignObj.selectedCount + 1
				summerDesignObj.save()
				SelectedDesign.objects.create(school_id=schoolId, design_id=summerDesignId)
		except:
			print '하복 선택안함'

		try:
			casualDesignId = request.POST['casualDesignId']
			try:
				originDesignObj = schoolObj.selected_design.get(coordi__season='A', coordi__gender=gender)

				casualDesignObj = Design.objects.get(id=casualDesignId)
				casualDesignObj.selectedCount = casualDesignObj.selectedCount + 1


				selectedDesignObj = SelectedDesign.objects.get(school_id=schoolId, design_id=originDesignObj.id)
				selectedDesignObj.design_id = casualDesignId
				selectedDesignObj.save()
			except:
				casualDesignObj = Design.objects.get(id=casualDesignId)
				casualDesignObj.selectedCount = casualDesignObj.selectedCount + 1
				casualDesignObj.save()
				SelectedDesign.objects.create(school_id=schoolId, design_id=casualDesignId)
		except:
			print '생활복 선택안함'

		variables = {
			'msg': '채택되었습니다'
		}

		return HttpResponse(json.dumps(variables, indent=4, ensure_ascii=False, encoding='utf-8'))


# 해당학교 디자인 삭제기능 (제안, 관심, 채택 범용)
def deleteDesign(request):
	if request.user.is_authenticated():
		user = request.session['user']
		userinformation = request.session['userinformation']
		if (userinformation.userAuthority > 3):
			return render_to_response('published/main.html', {'user': user, 'userinfo': userinformation,
															  'permissionError': '권한이없습니다 관리자에게 문의해보세요'})
		category = int(request.POST['category'])
		schoolId = request.POST['schoolId']
		designIds = request.POST['designIdList']
		designIdList = designIds.split(",")

		if category == 0:
			for designId in designIdList:
				try:
					selectedObj = OfferDesign.objects.get(school_id=schoolId, design_id=designId)
					selectedObj.delete()
				except:
					'제안디자인 삭제부분 문제발생'

		if category == 1:
			for designId in designIdList:
				try:
					selectedObj = FavoriteDesign.objects.get(school_id=schoolId, design_id=designId)
					selectedObj.delete()
					designObj = Design.objects.get(id=designId)
					designObj.favoriteCount = designObj.favoriteCount - 1
					designObj.save()
				except:
					'관심디자인 삭제부분 문제발생'

		if category == 2:
			for designId in designIdList:
				try:
					selectedObj = SelectedDesign.objects.get(school_id=schoolId, design_id=designId)
					selectedObj.delete()
					designObj = Design.objects.get(id=designId)
					designObj.selectedCount = designObj.selectedCount - 1
					designObj.save()
				except:
					'채택디자인 삭제부분 문제발생'

		variables = {'msg': '삭제되었습니다'}
		return HttpResponse(json.dumps(variables, indent=4, ensure_ascii=False, encoding='utf-8'))

# 전국 디자인 현황 리스트 출력
def getSelectedDesignList(request):

	searchParameters = json.loads(request.POST['searchParameters'])

	try:
		year = int(searchParameters['year'])
		startDate = datetime.date(year - 1, 1, 1)
		endDate = datetime.date(year + 1, 1, 1)
	except:
		startDate = datetime.date(1000, 1, 1)
		endDate = datetime.date(9000, 1, 1)

	totalCount = Design.objects.filter(
		selected_design__sido__contains=searchParameters['sido'],
		selected_design__gu__contains=searchParameters['gu'],
		selected_design__schoolName__contains=searchParameters['schoolName'],
		coordi__season__contains=searchParameters['season'],
		coordi__collar__contains=searchParameters['style'],
		coordi__color__contains=searchParameters['color'],
		coordi__fabric__contains=searchParameters['fabric'],
		coordi__gender__contains=searchParameters['gender'],
		date__gt=startDate, date__lt=endDate
	).distinct().__len__()

	pagingNumbers = paging.paging(int(request.POST['page']), int(request.POST['perPage']), totalCount)

	page = pagingNumbers['current']
	totalPage = pagingNumbers['totalPage']
	startPos = pagingNumbers['startPos']
	endPos = pagingNumbers['endPos']

	selectedDesignListPagingObject = Design.objects.filter(
		selected_design__sido__contains=searchParameters['sido'],
		selected_design__gu__contains=searchParameters['gu'],
		selected_design__schoolName__contains=searchParameters['schoolName'],
		coordi__season__contains=searchParameters['season'],
		coordi__collar__contains=searchParameters['style'],
		coordi__color__contains=searchParameters['color'],
		coordi__fabric__contains=searchParameters['fabric'],
		coordi__gender__contains=searchParameters['gender'],
		date__gt = startDate, date__lt=endDate
	).distinct().order_by('-selectedCount')[startPos:endPos]

	selectedDesignList = []
	for selectedDesign in selectedDesignListPagingObject:
		if selectedDesign.selected_design.all().__len__() > 0:
			selectedDesignList.append(
				{'id': selectedDesign.id,
				 'thumb': selectedDesign.thumb.url,
				 'name': selectedDesign.selected_design.all()[0].schoolName,
				 }
			)
		else:
			selectedDesignList.append(
				{'id': selectedDesign.id,
				 'thumb': selectedDesign.thumb.url,
				 'name': selectedDesign.orderCode,
				 }
			)

	# selectedDesignPagingListPaging = serializers.serialize('json', selectedDesignListPagingObject)
	variables = {'selectedDesignPagingList': selectedDesignList, 'current': page, 'max': totalPage, 'searchParameters': searchParameters}
	return HttpResponse(json.dumps(variables, ensure_ascii=False), content_type='application/json')



# 모든 디자인 리스트 출력 (디자인 제안 부분)
def getOfferDesignList(request):
	searchParameters = json.loads(request.POST['searchParameters'])

	try:
		year = int(searchParameters['year'])
		startDate = datetime.date(year - 1, 1, 1)
		endDate = datetime.date(year + 1, 1, 1)

	except:
		startDate = datetime.date(1000, 1, 1)
		endDate = datetime.date(9000, 1, 1)

	totalCount = Design.objects.filter(
		coordi__season__contains=searchParameters['season'],
		coordi__collar__contains=searchParameters['style'],
		coordi__color__contains=searchParameters['color'],
		coordi__fabric__contains=searchParameters['fabric'],
		coordi__gender__contains=searchParameters['gender'],
		date__gt=startDate, date__lt=endDate,
		schoolUsed=False
	).distinct() .order_by('-favoriteCount').__len__()


	pagingNumbers = paging.paging(int(request.POST['page']), int(request.POST['perPage']), totalCount)

	page = pagingNumbers['current']
	totalPage = pagingNumbers['totalPage']
	startPos = pagingNumbers['startPos']
	endPos = pagingNumbers['endPos']

	offerDesignListPagingObject = Design.objects.filter(
		coordi__season__contains=searchParameters['season'],
		coordi__collar__contains=searchParameters['style'],
		coordi__color__contains=searchParameters['color'],
		coordi__fabric__contains=searchParameters['fabric'],
		coordi__gender__contains=searchParameters['gender'],
		date__gt = startDate, date__lt=endDate,
		schoolUsed=False
	).distinct() .order_by('-favoriteCount', '-id')[startPos:endPos]

	offerDesignList = []
	for offerDesign in offerDesignListPagingObject:
		# if offerDesign.selected_design.all().__len__() > 0:
		# 	offerDesignList.append(
		# 		{'id': offerDesign.id,
		# 		 'thumb': offerDesign.thumb.url if offerDesign.thumb.name.__len__() > 0 else '',
		# 		 'name': offerDesign.selected_design.all()[0].schoolName,
		# 		 }
		# 	)
		# else:
		# 	offerDesignList.append(
		# 		{'id': offerDesign.id,
		# 		 'thumb': offerDesign.thumb.url if offerDesign.thumb.name.__len__() > 0 else '',
		# 		 'name': offerDesign.orderCode,
		# 		 }
		# 	)
		offerDesignList.append(
			{'id': offerDesign.id,
			 'thumb': offerDesign.thumb.url if offerDesign.thumb.name.__len__() > 0 else '',
			 'name': offerDesign.orderCode,
			 }
		)

	variables = {'offerDesignPagingList': offerDesignList, 'current': page, 'max': totalPage, 'searchParameters': searchParameters}
	return HttpResponse(json.dumps(variables, ensure_ascii=False), content_type='application/json')

# 디자인 상세페이지 출력
def design_view(request):
	if request.user.is_authenticated():
		user = request.session['user']
		userinformation = request.session['userinformation']
		if (userinformation.userAuthority > 3):
			return render_to_response('published/main.html', {'user': user, 'userinfo': userinformation,
															  'permissionError': '권한이없습니다 관리자에게 문의해보세요'})

		designId = request.POST['designId']
		category = int(request.POST['category'])
		returnValue = ''

		# 0 : 디자인제안에서 들어온 상세
		# 1 : 디자인현황에서 들어온 상세
		# 2 : mypage 제안디자인에서 들어온 상세
		# 3 : mypage 관심디자인에서 들어온 상세
		# 4 : mypage 채택디자인에서 들어온 상세
		if category == 0:
			returnValue = '/design_offer_list'
		if category == 1:
			# returnValue = '/design_current_list'
			returnValue = '/popular_design'
		try:
			schoolId = int(request.POST['schoolId'])
		except:
			schoolId = None

		designObj = Design.objects.get(id=designId)
		gender = designObj.coordi.gender
		season = designObj.coordi.season

		similarDesignList = Design.objects.filter(coordi__gender=gender, coordi__season=season).exclude(coordi__design=designObj)

		productList = Product.objects.filter(coordi__design=designObj)

		products = []

		for product in productList:
			# products.append({'id': product.id, 'name': product.name, 'fabricCode': Fabric.objects.filter(grid__selectedgrid__design_id=designObj.id, grid__style__detail__product=product)[0].name, 'detail': []})
			products.append({'id': product.id, 'name': product.name, 'fabricCode': Fabric.objects.filter(grid__selectedgrid__design_id=designObj.id, grid__style__detail__product=product).distinct('name')})

		variables = {
			'user': user,
			'userinfo': userinformation,
			'category': category,
			'returnValue': returnValue,
			'designObj': designObj,
			'productList': products,
			'similarDesignList': similarDesignList,
			'schoolId': schoolId,
		}

		return render_to_response('published/design_view.html', variables)
	else:
		variables = {'error': NOT_LOGIN_MSG}
		return render_to_response('pages/errorPage.html', RequestContext(request, variables))

# 디자인 상세페이지 관심, 제안 등록 (범용)
def makeSchoolDesignLink(request):
	if request.user.is_authenticated():
		user = request.session['user']
		userinformation = request.session['userinformation']
		if (userinformation.userAuthority > 3):
			return render_to_response('published/main.html', {'user': user, 'userinfo': userinformation,
															  'permissionError': '권한이없습니다 관리자에게 문의해보세요'})

		schoolId = request.POST['schoolId']
		designId = request.POST['designId']
		category = int(request.POST['category'])

		schoolObj = School.objects.get(id=schoolId)
		if(category == 0):
			try:
				favoriteObj = FavoriteDesign.objects.get(school_id=schoolId, design_id=designId)
				msg = '이미 관심리스트에 있는 디자인 입니다'
			except:
				FavoriteDesign.objects.create(school_id=schoolId, design_id=designId)
				designObj = Design.objects.get(id=designId)
				designObj.favoriteCount = designObj.favoriteCount + 1
				designObj.save()
				schoolObj.designUpdated = datetime.datetime.now()
				schoolObj.save()
				msg = '관심리스트에 등록하였습니다'

		elif(category == 1):
			newDesignObj = Design.objects.get(id=designId)
			newDesignObj.selectedCount = newDesignObj.selectedCount + 1
			newDesignObj.save()
			gender = newDesignObj.coordi.gender
			season = newDesignObj.coordi.season
			try:
				originDesignObj = schoolObj.selected_design.get(coordi__season=season, coordi__gender=gender)

				selectedDesignObj = SelectedDesign.objects.get(school_id=schoolId, design_id=originDesignObj.id)
				selectedDesignObj.design_id = newDesignObj.id
				selectedDesignObj.save()
			except:
				SelectedDesign.objects.create(school_id=schoolId, design_id=newDesignObj.id)
			msg = '채택디자인으로 등록하였습니다'

		elif (category == 2):
			try:
				offerObj = OfferDesign.objects.get(school_id=schoolId, design_id=designId)
				msg = '이미 제안리스트에 있는 디자인 입니다'
			except:
				OfferDesign.objects.create(school_id=schoolId, design_id=designId)
				schoolObj.designUpdated = datetime.datetime.now()
				schoolObj.save()
				msg = '제안리스트에 등록하였습니다'

		variables = {'msg': msg}
		return HttpResponse(json.dumps(variables, ensure_ascii=False), content_type='application/json')


	else:
		variables = {'error': NOT_LOGIN_MSG}
		return render_to_response('pages/errorPage.html', RequestContext(request, variables))

# 관리자페이지 - 디자인별 관리
def manageDesign(request):
	if request.user.is_authenticated():
		user = request.session['user']
		userinformation = request.session['userinformation']
		if (userinformation.userAuthority > 2):
			return render_to_response('published/main.html', {'user': user, 'userinfo': userinformation,
															  'permissionError': '권한이없습니다 관리자에게 문의해보세요'})

		try:
			designName = request.POST['designName']
		except:
			designName = ''

		try:
			page = request.POST['page']
		except:
			page = 1

		page = int(page)
		perPage = 13
		startPos = (page - 1) * perPage
		endPos = startPos + perPage

		# totalCount = Design.objects.filter(name__contains=designName).__len__()
		# totalCount = Design.objects.filter(coordi__name__contains=designName).__len__()
		totalCount = Design.objects.filter(orderCode__contains=designName).__len__()

		totalPage = totalCount / perPage
		if (totalCount % perPage) > 0:
			totalPage = totalPage + 1
		if totalPage < page:
			page = totalPage

		# designList = Design.objects.all().order_by('-id')
		# designList = Design.objects.filter(name__contains=designName).order_by('-id')[startPos:endPos]
		# designList = Design.objects.filter(coordi__name__contains=designName).order_by('-id')[startPos:endPos]
		designList = Design.objects.filter(orderCode__contains=designName).order_by('-id')[startPos:endPos]
		variables = {
			'user': user,
			'userinfo': userinformation,
			'designList': designList,
			'designName': designName,
			'current': page,
			'max': totalPage
		}

		return render_to_response('pages/managedesign.html', RequestContext(request, variables))
	else:
		variables = {'error': NOT_LOGIN_MSG}
		return render_to_response('pages/errorPage.html', RequestContext(request, variables))

# 관리자 페이지 - 디자인별 관리 디자인 삭제기능
def designDelete(request):
	if request.user.is_authenticated():
		user = request.session['user']
		userinformation = request.session['userinformation']
		if (userinformation.userAuthority > 2):
			return render_to_response('published/main.html', {'user': user, 'userinfo': userinformation,
															  'permissionError': '권한이없습니다 관리자에게 문의해보세요'})

		checkedDesignList = request.POST['checkedDesignList']
		designIdList = checkedDesignList.split(",")

		for designId in designIdList:
			designObj = Design.objects.get(id=designId)
			coordiObj = designObj.coordi

			if coordiObj.design_set.all().__len__() == 1:
				print '디자인 하나만 물고있다'
				deleteCoordiDir = settings.MEDIA_ROOT + 'data/coordi/' + str(coordiObj.id)
				coordiObj.delete()
				try:
					shutil.rmtree(deleteCoordiDir)
				except OSError as e:
					if e.errno == 2:
						# 파일이나 디렉토리가 없음!
						print 'No such file or directory to remove'
						pass
					else:
						variables = {'msg': '실제 디렉토리 경로에 문제가 있습니다.', 'errorObj': deleteCoordiDir}
						return HttpResponse(json.dumps(variables, indent=4, ensure_ascii=False, encoding='utf-8'))
			else:
				print '디자인 여러개 물고있다'
				designObj.delete()

		variables = {'msg': '디자인 목록에서 삭제되었습니다.'}
		return HttpResponse(json.dumps(variables, indent=4, ensure_ascii=False, encoding='utf-8'))
	else:
		variables = {'error': NOT_LOGIN_MSG}
		return render_to_response('pages/errorPage.html', RequestContext(request, variables))


# 관리자 페이지 - 디자인별 관리 디자인 상세보기 기능
def detailDesignPage(request):
	if request.user.is_authenticated():
		user = request.session['user']
		userinformation = request.session['userinformation']
		if (userinformation.userAuthority > 2):
			return render_to_response('published/main.html', {'user': user, 'userinfo': userinformation,
															  'permissionError': '권한이없습니다 관리자에게 문의해보세요'})

		try:
			schoolId = int(request.POST['schoolId'])
		except:
			schoolId = None
		try:
			category = request.POST['category']
		except:
			category = None

		designId = request.POST['designId']
		designObj = Design.objects.get(id=designId)
		productList = Product.objects.filter(coordi__design=designObj).order_by('id')

		products = []

		for product in productList:
			# products.append({'id': product.id, 'name': product.name, 'fabricCode': Fabric.objects.filter(grid__selectedgrid__design_id=designObj.id, grid__style__detail__product=product)[0].name, 'detail': []})
			products.append({'id': product.id, 'name': product.name, 'fabricCode': Fabric.objects.filter(grid__selectedgrid__design_id=designObj.id, grid__style__detail__product=product).distinct('name')})

		variables = {
			'user': user,
			'userinfo': userinformation,
			'designObj': designObj,
			'productList': products,
			'schoolId': schoolId,
			'category': category,
		}




		return render_to_response('pages/managedesign_detail.html', RequestContext(request, variables))
	else:
		variables = {'error': NOT_LOGIN_MSG}
		return render_to_response('pages/errorPage.html', RequestContext(request, variables))

# 관리자페이지 - 학교별 디자인 관리, 해당학교에 속한 디자인들 출력
def schoolDesignList(request):
	if request.user.is_authenticated():
		user = request.session['user']
		userinformation = request.session['userinformation']
		if (userinformation.userAuthority > 2):
			return render_to_response('published/main.html', {'user': user, 'userinfo': userinformation,
															  'permissionError': '권한이없습니다 관리자에게 문의해보세요'})

		try:
			schoolId = request.POST['schoolId']
		except:
			variables = {'error': '해당하는 학교가 입력되지 않았습니다.'}
			return render_to_response('pages/errorPage.html', RequestContext(request, variables))

		try:
			page = request.POST['page']
		except:
			page = 1

		try:
			category = int(request.POST['category'])
		except:
			category = 0

		page = int(page)
		perPage = 11
		startPos = (page - 1) * perPage
		endPos = startPos + perPage

		schoolObj = School.objects.get(id=schoolId)

		designTypeMsg = ''
		if category == 0:
			schoolDesignList = schoolObj.offer_design.all().order_by('-id')
			designTypeMsg = '제안디자인'

		elif category == 1:
			schoolDesignList = schoolObj.favorite_design.all().order_by('-id')
			designTypeMsg = '관심디자인'

		elif category == 2:
			schoolDesignList = schoolObj.selected_design.all().order_by('-id')
			designTypeMsg = '채택디자인'

		# schoolDesignList = (schoolObj.offer_design.all() | schoolObj.favorite_design.all() | schoolObj.selected_design.all()).order_by('-id')

		# totalCount = Design.objects.all().__len__()
		totalCount =schoolDesignList.__len__()

		totalPage = totalCount / perPage
		if (totalCount % perPage) > 0:
			totalPage = totalPage + 1
		if totalPage < page:
			page = totalPage

		# designList = schoolDesignList[::-1][startPos:endPos]
		designList = schoolDesignList[startPos:endPos]


		variables = {
			'user': user,
			'userinfo': userinformation,
			'schoolObj': schoolObj,
			'designList': designList,
			'schoolId': schoolId,
			'category': category,
			'designTypeMsg': designTypeMsg,
			'current': page,
			'max': totalPage
		}

		returnTemplate = 'pages/managedesign_school_design_list.html'
		return render_to_response(returnTemplate, RequestContext(request, variables))
	else:
		variables = {'error': NOT_LOGIN_MSG}
		return render_to_response('pages/errorPage.html', RequestContext(request, variables))


# 해당학교에 엘리트 제안 디자인 추가 페이지
def addOfferDesignPage(request):
	if request.user.is_authenticated():
		user = request.session['user']
		userinformation = request.session['userinformation']
		if (userinformation.userAuthority > 2):
			return render_to_response('published/main.html', {'user': user, 'userinfo': userinformation,
															  'permissionError': '권한이없습니다 관리자에게 문의해보세요'})

		try:
			designName = request.POST['designName']
		except:
			designName = ''

		try:
			page = request.POST['page']
		except:
			page = 1

		schoolId = request.POST['schoolId']
		schoolObj = School.objects.get(id=schoolId)
		gender = schoolObj.gender
		if gender == '남여공학':
			gender = ''
		elif gender == '남자':
			gender = 'B'
		else:
			gender = 'G'

		page = int(page)
		perPage = 4
		startPos = (page - 1) * perPage
		endPos = startPos + perPage

		totalCount = Design.objects.filter(name__contains=designName, coordi__gender__contains=gender, schoolUsed=False).exclude(offer_design=schoolObj).__len__()

		totalPage = totalCount / perPage
		if (totalCount % perPage) > 0:
			totalPage = totalPage + 1
		if totalPage < page:
			page = totalPage

		designList = Design.objects.filter(name__contains=designName, coordi__gender__contains=gender, schoolUsed=False).exclude(offer_design=schoolObj).order_by('-id')[startPos:endPos]

		variables = {
			'user': user,
			'userinfo': userinformation,
			'designList': designList,
			'designName': designName,
			'schoolId': schoolId,
			'schoolObj': schoolObj,
			'current': page,
			'max': totalPage
		}

		return render_to_response('pages/managedesign_school_design_addOffer.html', RequestContext(request, variables))
	else:
		variables = {'error': NOT_LOGIN_MSG}
		return render_to_response('pages/errorPage.html', RequestContext(request, variables))


# 해당학교 제안디자인 추가기능
def addOfferDesign(request):
	if request.user.is_authenticated():
		user = request.session['user']
		userinformation = request.session['userinformation']
		if (userinformation.userAuthority > 2):
			return render_to_response('published/main.html', {'user': user, 'userinfo': userinformation,
															  'permissionError': '권한이없습니다 관리자에게 문의해보세요'})

		schoolId = request.POST['schoolId']
		schoolObj = School.objects.get(id=schoolId)
		designIds = request.POST['designIdList']
		designIdList = designIds.split(",")

		overlapDesignNames = ''
		allOverlap = True
		for designId in designIdList:
			try:
				offerObj = OfferDesign.objects.get(school_id=schoolId, design_id=designId)
				overlapDesignNames += Design.objects.get(id=offerObj.design_id).name + ' '
			except:
				OfferDesign.objects.create(school_id=schoolId, design_id=designId)
				print '일단 이게 나오면 전부 중복은 아니다'
				allOverlap = False

		if overlapDesignNames.__len__() > 0:
			if allOverlap:
				variables = {
					'msg': '이미 제안리스트에 존재하는 디자인입니다'
				}
			else:
				variables = {
					'msg': '중복 디자인을 제외하고 제안리스트에 추가되었습니다' + '\n중복되는 디자인 : ' + overlapDesignNames
				}
				schoolObj.designUpdated = datetime.datetime.now()
				schoolObj.save()
		else:
			variables = {
				'msg': '제안리스트에 추가되었습니다'
			}
			schoolObj.designUpdated = datetime.datetime.now()
			schoolObj.save()

		return HttpResponse(json.dumps(variables, indent=4, ensure_ascii=False, encoding='utf-8'))


# 학교별 관리에서 들어간 디자인 상세페이지 수정 필요
def schoolDesignDetail(request):
	if request.user.is_authenticated():
		user = request.session['user']
		userinformation = request.session['userinformation']
		if (userinformation.userAuthority > 2):
			return render_to_response('published/main.html', {'user': user, 'userinfo': userinformation,
															  'permissionError': '권한이없습니다 관리자에게 문의해보세요'})

		designId = request.POST['designId']
		designObj = Design.objects.get(id=designId)
		productList = Product.objects.filter(coordi__design=designObj)

		# for schoolId in schoolIdList:
		# 	schoolObj = School.objects.get(id=schoolId)
		# 	agencyIdObj.school_set.remove(schoolObj)

		variables = {
			'user': user,
			'userinfo': userinformation,
			'designObj': designObj,
			'productList': productList,
		}

		return render_to_response('pages/managedesign_detail.html', RequestContext(request, variables))
	else:
		variables = {'error': NOT_LOGIN_MSG}
		return render_to_response('pages/errorPage.html', RequestContext(request, variables))

# 카테고리 탐색 기능
def getCategoryList(request):

	styleList = serializers.serialize('json', StyleCategory.objects.all())
	colorList = serializers.serialize('json', ColorCategory.objects.all())
	fabricList = serializers.serialize('json', FabricCategory.objects.all())

	variables = {
		'styleList': styleList,
		'colorList': colorList,
		'fabricList': fabricList,
	}
	return HttpResponse(json.dumps(variables, indent=4, ensure_ascii=False, encoding='utf-8'))


def saveDesignMemo(request):
	designId = request.POST['designId'];
	memoText = request.POST['memoText'];

	designObj = Design.objects.get(id=designId)
	designObj.memo = memoText
	designObj.save()

	variables = {
		'msg': '등록하였습니다.',
		'memoText': designObj.memo,
	}

	return HttpResponse(json.dumps(variables, indent=4, ensure_ascii=False, encoding='utf-8'))


def designSchoolUsedChange(request):
	designId = request.POST['designId'];
	schoolUsed = request.POST['schoolUsed'];

	designObj = Design.objects.get(id=designId)
	if schoolUsed == 'false':
		designObj.schoolUsed = True
		schoolUsed = 'true'
	else:
		designObj.schoolUsed = False
		schoolUsed = 'false'
	designObj.save()

	variables = {
		'msg': '등록하였습니다.',
		'schoolUsed': schoolUsed,
	}

	return HttpResponse(json.dumps(variables, indent=4, ensure_ascii=False, encoding='utf-8'))


def addSelectDesignPage(request):
	if request.user.is_authenticated():
		user = request.session['user']
		userinformation = request.session['userinformation']
		if (userinformation.userAuthority > 2):
			return render_to_response('published/main.html', {'user': user, 'userinfo': userinformation,
															  'permissionError': '권한이없습니다 관리자에게 문의해보세요'})
		gender = ''
		season = ''
		schoolId = request.POST['schoolId'];
		school = School.objects.get(id=schoolId)
		if school.gender == '남여공학':
			unisex = True
			try:
				gender = request.POST['selectGender']
			except:
				gender = 'B'

		elif school.gender == '남':
			gender = 'B'
			unisex = False
		else:
			gender = 'G'
			unisex = False

		try:
			season = request.POST['selectSeason']
		except:
			season = 'W'

		try:
			page = request.POST['page']
		except:
			page = 1

		page = int(page)
		perPage = 4
		startPos = (page - 1) * perPage
		endPos = startPos + perPage

		totalCount = Design.objects.filter(coordi__gender__contains=gender, coordi__season__contains=season).__len__()

		totalPage = totalCount / perPage
		if (totalCount % perPage) > 0:
			totalPage = totalPage + 1
		if totalPage < page:
			page = totalPage

		designList = Design.objects.filter(coordi__gender__contains=gender, coordi__season__contains=season).order_by('-id')[startPos:endPos]

		variables = {
			'schoolId': schoolId,
			'schoolObj': school,
			'selectGender': gender,
			'selectSeason': season,
			'unisex': unisex,
			'designList': designList,
			'current': page,
			'max': totalPage
		}
		return render_to_response('pages/managedesign_school_design_addSelect.html', RequestContext(request, variables))
	else:
		variables = {'error': NOT_LOGIN_MSG}
		return render_to_response('pages/errorPage.html', RequestContext(request, variables))


def addSelectDesign(request):
	if request.user.is_authenticated():
		user = request.session['user']
		userinformation = request.session['userinformation']
		if (userinformation.userAuthority > 2):
			return render_to_response('published/main.html', {'user': user, 'userinfo': userinformation,
															  'permissionError': '권한이없습니다 관리자에게 문의해보세요'})

		schoolId = request.POST['schoolId']
		designIds = request.POST['designIdList']
		designIdList = designIds.split(",")

		gender = request.POST['selectGender']
		season = request.POST['selectSeason']
		schoolObj = School.objects.get(id=schoolId)

		for newDesignId in designIdList:
			try:
				originDesignObj = schoolObj.selected_design.get(coordi__season=season, coordi__gender=gender)

				newDesignObj = Design.objects.get(id=newDesignId)
				newDesignObj.selectedCount = newDesignObj.selectedCount + 1

				selectedDesignObj = SelectedDesign.objects.get(school_id=schoolId, design_id=originDesignObj.id)
				selectedDesignObj.design_id = newDesignId
				selectedDesignObj.save()
			except:
				newDesignObj = Design.objects.get(id=newDesignId)
				newDesignObj.selectedCount = newDesignObj.selectedCount + 1
				newDesignObj.save()
				SelectedDesign.objects.create(school_id=schoolId, design_id=newDesignId)

		schoolObj.designUpdated = datetime.datetime.now()
		schoolObj.save()
		variables = {
			'msg': '새로운 채택디자인으로 등록되었습니다'
		}

		return HttpResponse(json.dumps(variables, indent=4, ensure_ascii=False, encoding='utf-8'))


def getPopularDesignList(request):
	searchParameters = json.loads(request.POST['searchParameters'])

	try:
		year = int(searchParameters['year'])
		startDate = datetime.date(year - 1, 1, 1)
		endDate = datetime.date(year + 1, 1, 1)

	except:
		startDate = datetime.date(1000, 1, 1)
		endDate = datetime.date(9000, 1, 1)

	totalCount = Design.objects.filter(
		# favorite_design__grade__contains=searchParameters['grade'],
		selected_design__grade__contains=searchParameters['grade'],
		coordi__gender__contains=searchParameters['gender'],
		coordi__season__contains=searchParameters['season'],
		date__gt=startDate, date__lt=endDate
	).distinct() .order_by('-selectedCount').__len__()


	pagingNumbers = paging.paging(int(request.POST['page']), int(request.POST['perPage']), totalCount)

	page = pagingNumbers['current']
	totalPage = pagingNumbers['totalPage']
	startPos = pagingNumbers['startPos']
	endPos = pagingNumbers['endPos']

	popularDesignListPagingObject = Design.objects.filter(
		# favorite_design__grade__contains=searchParameters['grade'],
		selected_design__grade__contains=searchParameters['grade'],
		coordi__gender__contains=searchParameters['gender'],
		coordi__season__contains=searchParameters['season'],
		date__gt=startDate, date__lt=endDate
	).distinct() .order_by('-selectedCount', '-id')[startPos:endPos]

	popularDesignList = []
	for popularDesign in popularDesignListPagingObject:
		popularDesignList.append(
			{'id': popularDesign.id,
			 'thumb': popularDesign.thumb.url,
				'name': popularDesign.orderCode,
			 }
		)

	variables = {'popularDesignPagingList': popularDesignList, 'current': page, 'max': totalPage, 'searchParameters': searchParameters}
	return HttpResponse(json.dumps(variables, ensure_ascii=False), content_type='application/json')


def getTopPopularDesignList(request):
	# category = json.loads(request.POST['category'])
	category = request.POST['category']

	try:
		# result_design_data = Design.objects.filter(favorite_design__grade__contains=category[0], coordi__gender__contains=category[1], coordi__season__contains=category[2]).distinct().order_by('-selectedCount')[0]
		result_design_data = Design.objects.filter(selected_design__grade__contains=category[0], coordi__gender__contains=category[1], coordi__season__contains=category[2]).distinct().order_by('-selectedCount')[0]
	except:
		result_design_data = None

	if result_design_data:
		variables = {'url': result_design_data.thumb.url, 'id': result_design_data.id}
	else:
		variables = {'url': '', 'id': ''}
	return HttpResponse(json.dumps(variables, ensure_ascii=False), content_type='application/json')