# -*- coding: utf8 -*-

from django.template import RequestContext
from django.shortcuts import render_to_response, get_object_or_404
from django.views.decorators.csrf import csrf_protect, csrf_exempt
from django.http import HttpResponseRedirect, HttpResponse, Http404
from django.core import serializers
from category.models import *
import settings
import os
import json

NOT_LOGIN_MSG = '로그인 해 주세요'

@csrf_exempt
def saveCategory(request):
    if request.user.is_authenticated():
        name = request.POST['name']
        code = request.POST['code']
        text = request.POST['text']
        categoryName = request.POST['model']

        if categoryName == 'style':
            if request.FILES.has_key('thumb'):
                image = request.FILES['thumb']
                imageFileName = request.FILES['thumb'].name
                if os.path.isfile(settings.MEDIA_ROOT+'data/styleCategoryImage/'+imageFileName):
                    os.remove(settings.MEDIA_ROOT+'data/styleCategoryImage/'+imageFileName)
                styleCategory = StyleCategory.objects.create(name = name, code = code, image = image, text = text)
            else:
                styleCategory = StyleCategory.objects.create(name=name, code=code, text=text)
            styleCategory.save()
        elif categoryName == 'color':
            if request.FILES.has_key('thumb'):
                image = request.FILES['thumb']
                imageFileName = request.FILES['thumb'].name
                if os.path.isfile(settings.MEDIA_ROOT+'data/ColorCategoryImage/'+imageFileName):
                    os.remove(settings.MEDIA_ROOT+'data/ColorCategoryImage/'+imageFileName)
                colorCategory = ColorCategory.objects.create(name=name, code=code, image=image, text=text)
            else:
                colorCategory = ColorCategory.objects.create(name=name, code=code, text=text)
            colorCategory.save()
        elif categoryName == 'fabric':
            if request.FILES.has_key('thumb'):
                image = request.FILES['thumb']
                imageFileName = request.FILES['thumb'].name
                if os.path.isfile(settings.MEDIA_ROOT + 'data/FabricCategoryImage/' + imageFileName):
                    os.remove(settings.MEDIA_ROOT + 'data/FabricCategoryImage/' + imageFileName)
                fabricCategory = FabricCategory.objects.create(name=name, code=code, image=image, text=text)
            else:
                fabricCategory = FabricCategory.objects.create(name=name, code=code, text=text)
            fabricCategory.save()
        variables = {'success': True}
        return HttpResponse(json.dumps(variables, ensure_ascii=False), content_type='application/json')
    else:
        variables = {'error': NOT_LOGIN_MSG}
        return render_to_response('pages/errorPage.html', RequestContext(request, variables))

@csrf_exempt
def updateCategory(request):
    if request.user.is_authenticated():
        categoryId = request.POST['id']
        name = request.POST['name']
        code = request.POST['code']
        text = request.POST['text']
        categoryName = request.POST['model']

        if categoryName == 'style':
            styleCategory = StyleCategory.objects.get(id=categoryId)
            if request.FILES.has_key('thumb'):
                image = request.FILES['thumb']
                imageFileName = request.FILES['thumb'].name
                if os.path.isfile(settings.MEDIA_ROOT + 'data/styleCategoryImage/' + imageFileName):
                    os.remove(settings.MEDIA_ROOT + 'data/styleCategoryImage/' + imageFileName)
                styleCategory.name = name
                styleCategory.code = code
                styleCategory.text = text
                styleCategory.image = image
            else:
                styleCategory.name = name
                styleCategory.code = code
                styleCategory.text = text
            styleCategory.save()
        elif categoryName == 'color':
            colorCategory = ColorCategory.objects.get(id=categoryId)
            if request.FILES.has_key('thumb'):
                image = request.FILES['thumb']
                imageFileName = request.FILES['thumb'].name
                if os.path.isfile(settings.MEDIA_ROOT + 'data/ColorCategoryImage/' + imageFileName):
                    os.remove(settings.MEDIA_ROOT + 'data/ColorCategoryImage/' + imageFileName)
                colorCategory.name = name
                colorCategory.code = code
                colorCategory.text = text
                colorCategory.image = image
            else:
                colorCategory.name = name
                colorCategory.code = code
                colorCategory.text = text
            colorCategory.save()
        elif categoryName == 'fabric':
            fabricCategory = FabricCategory.objects.get(id=categoryId)
            if request.FILES.has_key('thumb'):
                image = request.FILES['thumb']
                imageFileName = request.FILES['thumb'].name
                if os.path.isfile(settings.MEDIA_ROOT + 'data/FabricCategoryImage/' + imageFileName):
                    os.remove(settings.MEDIA_ROOT + 'data/FabricCategoryImage/' + imageFileName)
                fabricCategory.name = name
                fabricCategory.code = code
                fabricCategory.text = text
                fabricCategory.image = image
            else:
                fabricCategory.name = name
                fabricCategory.code = code
                fabricCategory.text = text
            fabricCategory.save()
        variables = {'success': True}
        return HttpResponse(json.dumps(variables, ensure_ascii=False), content_type='application/json')
    else:
        variables = {'error': NOT_LOGIN_MSG}
        return render_to_response('pages/errorPage.html', RequestContext(request, variables))

@csrf_exempt
def getCategoryList(request):
    if request.user.is_authenticated():
        categoryName = request.POST['model']

        if categoryName == 'style':
            styleCategoryListObjects = StyleCategory.objects.all()
            categoryList = serializers.serialize('json', styleCategoryListObjects)
        elif categoryName == 'color':
            colorCategoryListObjects = ColorCategory.objects.all()
            categoryList = serializers.serialize('json', colorCategoryListObjects)
        elif categoryName == 'fabric':
            fabricCategoryListObjects = FabricCategory.objects.all()
            categoryList = serializers.serialize('json', fabricCategoryListObjects)

        variables = {'categoryList':categoryList}
        return HttpResponse(json.dumps(variables, ensure_ascii=False), content_type='application/json')

    else:
        variables = {'error': NOT_LOGIN_MSG}
        return render_to_response('pages/errorPage.html', RequestContext(request, variables))

@csrf_exempt
def getCategoryInfo(request):
    if request.user.is_authenticated():
        categoryName = request.POST['model']
        categoryId = request.POST['categoryId']

        if categoryName == 'style':
            categoryInfoObject = StyleCategory.objects.get(id = categoryId)
        elif categoryName == 'color':
            categoryInfoObject = ColorCategory.objects.get(id=categoryId)
        elif categoryName == 'fabric':
            categoryInfoObject = FabricCategory.objects.get(id=categoryId)

        variables =  {'name':categoryInfoObject.name, 'text':categoryInfoObject.text, 'image':str(categoryInfoObject.image), 'code':categoryInfoObject.code}
        return HttpResponse(json.dumps(variables, ensure_ascii=False), content_type='application/json')

    else:
        variables = {'error': NOT_LOGIN_MSG}
        return render_to_response('pages/errorPage.html', RequestContext(request, variables))

@csrf_exempt
def deleteCategory(request):
    if request.user.is_authenticated():
        categoryId = request.POST['id']
        categoryName = request.POST['model']

        if categoryName == 'style':
            categoryObject = StyleCategory.objects.get(id=categoryId)
        elif categoryName == 'color':
            categoryObject = ColorCategory.objects.get(id=categoryId)
        elif categoryName == 'fabric':
            categoryObject = FabricCategory.objects.get(id=categoryId)

        categoryObject.delete()
        variables = {'success': True}
        return HttpResponse(json.dumps(variables, ensure_ascii=False), content_type='application/json')
    else:
        variables = {'error': NOT_LOGIN_MSG}
        return render_to_response('pages/errorPage.html', RequestContext(request, variables))
