# -*- coding:utf-8 -*-
import datetime
from datetime import timedelta
from django.shortcuts import render, render_to_response
from django.http import HttpResponseRedirect, HttpResponse, Http404
from django.views.decorators.csrf import csrf_exempt, csrf_protect
from django.contrib.auth import authenticate, login, logout
from django.template import RequestContext
from django.core import serializers
import json
import math
import shutil
import os
import settings

from category.models import *
from board.models import *
from fabric.models import FabricInformation
from users.models import *
from product.models import *
from viewer import paging

#OTHER_KEY list use input post data filter from model field
OTHER_KEY = ['id', 'school', 'users', 'user', 'user_id']
LOGIN_ERROR_MSG = 'incorrect id or password'
METHOD_MISMATCH = 'request method mismatch'
NOT_LOGIN_MSG = '로그인 해 주세요'
NOT_ADMIN = '권한이 없습니다.'

def viewer(request):
	if request.user.is_authenticated():
		user = request.session['user']
		userinformation = request.session['userinformation']
		return render_to_response('display/main.html', {'user':user, 'userinfo':userinformation})
	return render_to_response('published/login.html')


def design_offer_list(request):
	if request.user.is_authenticated():
		user = request.session['user']
		userinformation = request.session['userinformation']
		if(userinformation.userAuthority > 3):
			return render_to_response('published/main.html', {'user': user, 'userinfo': userinformation, 'permissionError': '권한이없습니다 관리자에게 문의해보세요'})

		return render_to_response('display/design_offer_list.html', {'user': user, 'userinfo': userinformation})
	else:
		variables = {'error': NOT_LOGIN_MSG}
		return render_to_response('display/login.html', RequestContext(request, variables))



# 모든 디자인 리스트 출력 (디자인 제안 부분)
def getOfferDesignList(request):
	season = request.POST['season']
	gender = request.POST['gender']

	startDate = datetime.date(1000, 1, 1)
	endDate = datetime.date(9000, 1, 1)

	offerDesignListPagingObject = Design.objects.filter(
		coordi__season__contains=season,
		coordi__gender__contains=gender,
		date__gt=startDate, date__lt=endDate,
		schoolUsed=False
	).distinct() .order_by('-favoriteCount', '-id')


	offerDesignList = []
	for offerDesign in offerDesignListPagingObject:
		if offerDesign.selected_design.all().__len__() > 0:
			offerDesignList.append(
				{'id': offerDesign.id,
				 'thumb': offerDesign.thumb.url,
				 'name': offerDesign.selected_design.all()[0].schoolName,
				 }
			)
		else:
			offerDesignList.append(
				{'id': offerDesign.id,
				 'thumb': offerDesign.thumb.url,
					'name': offerDesign.orderCode,
				 }
			)

	variables = {'offerDesignPagingList': offerDesignList}
	return HttpResponse(json.dumps(variables, ensure_ascii=False), content_type='application/json')


@csrf_exempt
def simulation(request, design_id):
	if request.user.is_authenticated():
		design = Design.objects.get(id=design_id)
		coordi = design.coordi

		user = request.session['user']
		userInformation = request.session['userinformation']

		if userInformation.userAuthority == 3:
			agency = Agency.objects.filter(users=request.user)
			schoolList = School.objects.filter(agencyId__in = agency)

			variables = {'coordi': coordi, 'design': design, 'schoolList': schoolList, 'user': userInformation}

		else :
			variables = {'coordi': coordi, 'design': design, 'user': userInformation}

		return render_to_response('display/simulation.html', RequestContext(request, variables))
	else:
		variables = {'error': NOT_LOGIN_MSG}
		return render_to_response('display/login.html', RequestContext(request, variables))


@csrf_exempt
def loginSite(request):
	if request.method == 'POST':
		username = request.POST['username']
		password = request.POST['password']

		# if username or password is null
		# this case have verified on front page.
		if not request.POST['username'] or not request.POST['password']:
			return HttpResponseRedirect('/login')

		try:
			user = authenticate(username=username, password=password)
			if user is not None:
				if user.is_active:
					login(request, user)
					request.session['user'] = request.user
					request.session['userinformation'] = request.user.userinformation
					request.session.set_expiry(timedelta(days=365))
					variables = {'user':request.user, 'userinfo':request.user.userinformation}
					return render_to_response('display/design_offer_list.html', RequestContext(request, variables))
				else:
					variables = {'error':LOGIN_ERROR_MSG}
					return render_to_response('display/login.html', RequestContext(request, variables))
			else:
				variables = {'error':LOGIN_ERROR_MSG}
				return render_to_response('display/login.html', RequestContext(request, variables))
		except:
			variables = {'error':LOGIN_ERROR_MSG}
			return render_to_response('display/login.html', RequestContext(request, variables))