# -*- coding:utf-8 -*-
from __future__ import unicode_literals
from django.db import models

# Fabric 정보 model
class FabricInformation(models.Model):
	name = models.CharField(max_length=128)
	code = models.CharField(max_length=20)
	text = models.CharField(max_length=400)
	mix_rate = models.CharField(max_length=120)
	material = models.CharField(max_length=120)
	texture = models.CharField(max_length=120)
	original_filename = models.CharField(max_length=400, blank=True)
	stored_filename = models.CharField(max_length=400, blank=True)
	image_file = models.ImageField(upload_to='data/fabricInfoImg/%Y/%m', null=True, blank=True)


	def __unicode__(self):
		return self.name
