# _*_ coding: utf-8 _*_
from django.shortcuts import render, render_to_response
from django.template import RequestContext
from django.views.decorators.csrf import csrf_protect, csrf_exempt
from django.http import HttpResponseRedirect, HttpResponse, Http404
from django.core import serializers
from django.core.files.base import ContentFile
from django.core.files import File
from cStringIO import StringIO
from django.db.models import Q
from django.template import Context, loader

from fabric.models import *
from product.models import *
from xml.etree.ElementTree import Element, ElementTree, SubElement, parse

from PIL import Image

import uuid
import datetime
import json
import os, sys
import imghdr
import settings
import glob




# Fabric 정보 작성기능
@csrf_exempt
def insertFabricInfomation(request):

    if request.method == 'POST':
        fabricName = request.POST['fabricName']
        fabricText = request.POST['fabricText']
        fabricMixRate = request.POST['fabricMixRate']
        fabricMaterial = request.POST['fabricMaterial']
        fabricTexture = request.POST['fabricTexture']
        originalFileName = ''
        storedFileName = ''
        image_file = ''

        try:
            fabricObject = Fabric.objects.filter(name=fabricName)[0]

        except IndexError as e:
            print e
            resultData = {'msg': '존재하지 않는 Fabric입니다.', 'return': 'false'}
            return HttpResponse(json.dumps(resultData, indent=4, ensure_ascii=False, encoding='utf-8'))

        try:
            fabricInformationObject = FabricInformation.objects.filter(name=fabricName)[0]
            resultData = {'msg': '이미 존재하는 Fabric 정보입니다.', 'return': 'false'}
            return HttpResponse(json.dumps(resultData, indent=4, ensure_ascii=False, encoding='utf-8'))
        except IndexError as e:
            print e

            if 'file' in request.FILES:
                image_file = request.FILES['file']
                originalFileName = image_file._name

            # django 내장 파일업로드 기능이 아닌 부분
            # if 'file' in request.FILES:
            #     print '파일이 있다!!!!'

                # UPLOAD_DIR = settings.MEDIA_ROOT+'data/fabricInfoImage'
                #
                # if not os.path.exists(UPLOAD_DIR):
                #     os.makedirs(UPLOAD_DIR)

                # file = request.FILES['file']
                # originalFileName = file._name
                # originalFileExtension = originalFileName.split(".")[-1]
                # storedFileName = str(uuid.uuid4()).replace("-", "") + originalFileExtension
                #
                # fp = open('%s/%s' % (UPLOAD_DIR, storedFileName), 'wb')
                # for chunk in file.chunks():
                #     fp.write(chunk)
                # fp.close()

            # fabric 정보에 맞는 fabric의 url에서 fabric code 추출
            fabricPath = fabricObject.thumb.url
            fabricCode = os.path.basename(fabricPath).split(".")[0][-2] + os.path.basename(fabricPath).split(".")[0][-1]

            fabricInformationInsertObject = FabricInformation(name=fabricName,
                                                              code=fabricCode,
                                                              text=fabricText,
                                                              mix_rate=fabricMixRate,
                                                              material=fabricMaterial,
                                                              texture=fabricTexture,
                                                              original_filename=originalFileName,
                                                              stored_filename=storedFileName,
                                                              image_file=image_file)
            fabricInformationInsertObject.save()

            resultData = {'msg': '업로드 되었습니다.', 'return': ''}
            return HttpResponse(json.dumps(resultData, indent=4, ensure_ascii=False, encoding='utf-8'))

    return HttpResponse('잘못된 경로로 접근하였습니다.')


# Fabric 정보 상세 단일 데이터 탐색
@csrf_exempt
def getFabricInformation(request):

    fabricName = request.POST['fabricName']

    fabricInfoObj = FabricInformation.objects.get(code=fabricName)
    # fabricInfoObj = FabricInformation.objects.get(name=fabricName)
    # fabricObject = Fabric.objects.filter(name=fabricName)

    if str(fabricInfoObj.image_file).__len__() > 0:
        fabricInfoImagePath = fabricInfoObj.image_file.url
    else:
        fabricInfoImagePath = ''

    fabricInfo = {
                    'name': fabricInfoObj.name,
                    'code': fabricInfoObj.code,
                    'text': fabricInfoObj.text,
                    'mix_rate': fabricInfoObj.mix_rate,
                    'material': fabricInfoObj.material,
                    'texture': fabricInfoObj.texture,
                    # 'fabricImagePath': fabricObject[0].thumb.url,
                    'fabricInfoImageName': fabricInfoObj.original_filename,
                    'fabricInfoImagePath': fabricInfoImagePath,
                  }

    return HttpResponse(json.dumps(fabricInfo, indent=4, ensure_ascii=False, encoding='utf-8'))

# Fabric 정보 데이터 리스트 탐색
@csrf_exempt
def fabricInformationList(request, page=1):
    if request.method != 'POST':
        return HttpResponse('잘못된 경로로 접근하였습니다.')

    try:
        fabricName = request.POST['fabricName']
        fabricName = fabricName.upper()
    except:
        fabricName = ''

    page = int(page)
    per_page = 8

    # totalCount = FabricInformation.objects.filter(name__contains=fabricName).__len__()
    totalCount = FabricInformation.objects.filter(code__contains=fabricName).__len__()
    totalPage = totalCount / per_page
    if(totalCount % per_page > 0):
        totalPage = totalPage + 1
    if(totalPage < page):
        page = totalPage

    start_pos = (page - 1) * per_page
    end_pos = start_pos + per_page

    fabricInformationList = []
    fabricInfomationObject = FabricInformation.objects.filter(code__contains=fabricName.upper()).order_by('-id')[start_pos:end_pos]

    for fabricInfomation in fabricInfomationObject:
        fabricObject = Fabric.objects.filter(name=fabricInfomation.name)

        if str(fabricInfomation.image_file).__len__() > 0:
            fabricInfoImagePath = fabricInfomation.image_file.url
        else:
            fabricInfoImagePath = ''

        fabricInformationList.append({
            "text": fabricInfomation.text,
            "name": fabricInfomation.name,
            "code": fabricInfomation.code,
            "fabricInfoImagePath": fabricInfoImagePath,
            # "fabricImagePath": fabricObject[0].thumb.url,
        })

    print page
    print totalPage
    fabricInfo = {
        "fabricInformationList": fabricInformationList, "current": page, "max": totalPage, "fabricName": fabricName
    }

    return HttpResponse(json.dumps(fabricInfo, indent=4, ensure_ascii=False, encoding='utf-8'))

# Fabric 정보 수정
@csrf_exempt
def updateFabricInformation(request):

    fabricName = request.POST['fabricName']
    fabricText = request.POST['fabricText']
    fabricMixRate = request.POST['fabricMixRate']
    fabricMaterial = request.POST['fabricMaterial']
    fabricTexture = request.POST['fabricTexture']
    fabricInfoImagePath = request.POST['fabricInfoImagePath']

    # FabricInformation.objects.filter(name=fabricName).update(text=fabricText, mix_rate=fabricMixRate, material=fabricMaterial, texture=fabricTexture)
    FabricInformation.objects.filter(code=fabricName).update(text=fabricText, mix_rate=fabricMixRate, material=fabricMaterial, texture=fabricTexture)

    if 'file' in request.FILES:
        image_file = request.FILES['file']
        originalFileName = image_file._name
        # f1 = FabricInformation.objects.get(name=fabricName)
        f1 = FabricInformation.objects.get(code=fabricName)
        f1.image_file = image_file
        f1.original_filename = originalFileName
        f1.save()
    else:
        if not (fabricInfoImagePath.__len__() > 0):
                # FabricInformation.objects.filter(name=fabricName).update(image_file='', original_filename='')
                FabricInformation.objects.filter(code=fabricName).update(image_file='', original_filename='')

    resultData = {'msg': '게시글을 수정하였습니다.'}
    return HttpResponse(json.dumps(resultData, indent=4, ensure_ascii=False, encoding='utf-8'))


# Fabric 정보 삭제
@csrf_exempt
def deleteFabricInformation(request):

    if request.method == 'POST':
        fabricName = request.POST['fabricName']
        # FabricInformation.objects.get(name=fabricName).delete()
        FabricInformation.objects.get(code=fabricName).delete()
        pass

    return HttpResponse('잘못된 경로로 접근하였습니다.')


@csrf_exempt
def fabricInformationListErrorCheck(request):
    fabricInformationList = []
    fabricInfomationObject = FabricInformation.objects.all().order_by('-id')

    for fabricInfomation in fabricInfomationObject:

        if str(fabricInfomation.image_file).__len__() > 0:
            fabricInfoImagePath = fabricInfomation.image_file.url
        else:
            fabricInfoImagePath = ''

        fabricInformationList.append({
            "text": fabricInfomation.text,
            "name": fabricInfomation.name,
            "code": fabricInfomation.code,
            "fabricInfoImagePath": fabricInfoImagePath,
            # "fabricImagePath": fabricObject[0].thumb.url,
        })

    fabricInfo = {
        "fabricInformationList": fabricInformationList,
    }

    return HttpResponse(json.dumps(fabricInfo, indent=4, ensure_ascii=False, encoding='utf-8'))