# -*- coding: utf-8 -*-
# Generated by Django 1.9.8 on 2016-11-14 05:52
from __future__ import unicode_literals

from django.db import migrations, models
import django.db.models.deletion
import product.models


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        ('users', '0001_initial'),
    ]

    operations = [
        migrations.CreateModel(
            name='Category',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('gender', models.CharField(max_length=20)),
                ('season', models.CharField(max_length=20)),
                ('school', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='users.School')),
            ],
        ),
        migrations.CreateModel(
            name='Coordi',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=20)),
                ('collar', models.CharField(max_length=10)),
                ('fabric', models.CharField(max_length=10)),
                ('color', models.CharField(max_length=10)),
                ('code', models.CharField(max_length=10)),
                ('xml', models.FileField(null=True, upload_to=product.models.uploadProductFile)),
                ('gender', models.CharField(choices=[('B', '\ub0a8\uc131'), ('G', '\uc5ec\uc131')], max_length=1)),
                ('season', models.CharField(choices=[('W', '\ub3d9\ubcf5'), ('S', '\ud558\ubcf5'), ('A', '\uc0dd\ud65c\ubcf5')], max_length=1)),
            ],
        ),
        migrations.CreateModel(
            name='Design',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=20, null=True)),
                ('thumb', models.ImageField(upload_to=product.models.uploadProductFile)),
                ('date', models.DateTimeField(auto_now_add=True)),
                ('origin', models.BooleanField(default=False)),
                ('favoriteCount', models.IntegerField(default=0)),
                ('selectedCount', models.IntegerField(default=0)),
                ('uploader', models.CharField(max_length=20, null=True)),
                ('coordi', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='product.Coordi')),
            ],
        ),
        migrations.CreateModel(
            name='Detail',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=20)),
                ('index', models.IntegerField()),
            ],
        ),
        migrations.CreateModel(
            name='Fabric',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=128)),
                ('thumb', models.ImageField(upload_to=product.models.uploadFabricImage)),
                ('code', models.CharField(max_length=10)),
            ],
        ),
        migrations.CreateModel(
            name='FabricGroup',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=128)),
                ('code', models.CharField(max_length=10)),
                ('coordi', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='product.Coordi')),
            ],
        ),
        migrations.CreateModel(
            name='FavoriteDesign',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('design', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='product.Design')),
                ('school', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='users.School')),
            ],
        ),
        migrations.CreateModel(
            name='Grid',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('groupCode', models.CharField(max_length=20)),
                ('clothCode', models.CharField(max_length=128)),
                ('gridIndex', models.IntegerField(null=True)),
                ('pngPath', models.ImageField(upload_to=product.models.uploadProductFile)),
                ('fabric', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='product.Fabric')),
                ('fabricGroup', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='product.FabricGroup')),
            ],
        ),
        migrations.CreateModel(
            name='OfferDesign',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('design', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='product.Design')),
                ('school', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='users.School')),
            ],
        ),
        migrations.CreateModel(
            name='Product',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=20)),
                ('index', models.IntegerField()),
                ('coordi', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='product.Coordi')),
            ],
        ),
        migrations.CreateModel(
            name='SelectedDesign',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('design', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='product.Design')),
                ('school', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='users.School')),
            ],
        ),
        migrations.CreateModel(
            name='SelectedGrid',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('design', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='product.Design')),
                ('grid', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='product.Grid')),
            ],
        ),
        migrations.CreateModel(
            name='Style',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=20, null=True)),
                ('thumb', models.ImageField(upload_to=product.models.uploadProductFile)),
                ('index', models.IntegerField()),
                ('detail', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='product.Detail')),
            ],
        ),
        migrations.AddField(
            model_name='grid',
            name='style',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='product.Style'),
        ),
        migrations.AddField(
            model_name='fabric',
            name='fabricGroup',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='product.FabricGroup'),
        ),
        migrations.AddField(
            model_name='detail',
            name='product',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='product.Product'),
        ),
        migrations.AddField(
            model_name='design',
            name='favorite_design',
            field=models.ManyToManyField(blank=True, related_name='favorite_design', through='product.FavoriteDesign', to='users.School'),
        ),
        migrations.AddField(
            model_name='design',
            name='offer_design',
            field=models.ManyToManyField(blank=True, related_name='offer_design', through='product.OfferDesign', to='users.School'),
        ),
        migrations.AddField(
            model_name='design',
            name='selected_design',
            field=models.ManyToManyField(blank=True, related_name='selected_design', through='product.SelectedDesign', to='users.School'),
        ),
    ]
