import sys
from django.shortcuts import render
from django.views.decorators.csrf import csrf_protect, csrf_exempt
from django.http import HttpResponseRedirect, HttpResponse, Http404
from django.template import RequestContext
from django.shortcuts import render_to_response, get_object_or_404
from django.core import serializers
from django.core.files.base import ContentFile
from django.core.files import File
from cStringIO import StringIO
from django.db.models import Q
from product.models import *
from users.models import *
from xml.etree.ElementTree import Element, ElementTree, SubElement, parse
from django.http import Http404

import os
import json
import settings
import base64
import stat
import shutil
from PIL import Image
import uuid

def remove_readonly(func, path):
    os.chmod(path, stat.S_IWIRTE)
    func(path)

def remove_dir_tree(remove_dir):
    try:
        shutil.rmtree(remove_dir, ignore_errors=False)
    except() as e:
        print("[Delete Error] %s - %s." % (e.filename, e.strerror))

@csrf_exempt
def getProductList(request):
    products = []

    try:
        designId = int(request.POST['designId'])
        design = Design.objects.get(id=designId)
        coordiId = design.coordi
    except Exception as e:
        print str(e)

    productList = Product.objects.filter(coordi = coordiId).order_by('-id')

    selectedGridList = SelectedGrid.objects.filter(design=design)
    selectedGridStyleList = selectedGridList.values('grid__style__detail__id', 'grid__style__id').distinct('grid__style__detail__id')

    i=0
    for product in productList:
        products.append({'id': product.id, 'name':product.name, 'detail': []})

        detailList = Detail.objects.filter(product = product.id).order_by('id')

        j=0
        for detail in detailList:
            products[i]['detail'].append({'id': detail.id, 'name': detail.name, 'style': []})

            styleList = Style.objects.filter(detail = detail.id).order_by('id')

            k=0
            for style in styleList:
                thumb = style.thumb.url if style.thumb else ''
                products[i]['detail'][j]['style'].append({'id': style.id, 'name': style.name, 'thumb': thumb, 'grid': []})

                styleGridList = selectedGridList.filter(grid__style=style.id)

                for styleGrid in styleGridList:
                    gridList = Grid.objects.filter(id=styleGrid.grid_id, style=style.id)

                    for grid in gridList:
                        products[i]['detail'][j]['style'][k]['grid'].append({'id': grid.id, 'fabricGroup': grid.fabricGroup_id, 'fabric': grid.fabric_id, 'groupCode': grid.groupCode, 'gridIndex': grid.gridIndex, 'png': grid.pngPath.url})

                k += 1
            j += 1
        i += 1

    currentDesign = {}
    for selectedGridStyle in selectedGridStyleList:
        detailId = selectedGridStyle['grid__style__detail__id']
        currentDesign[detailId] = {'style': selectedGridStyle['grid__style__id']}

    data = {'products': products, 'currentDesign': currentDesign}

    return HttpResponse(json.dumps(data, encoding='utf-8'))


'''@csrf_exempt
def getSelectedGridList(request):
    try:
        designId = int(request.POST['designId'])
        design = Design.objects.get(id=designId)
        coordiId = design.coordi
    except Exception as e:
        print str(e)

    productList = Product.objects.filter(coordi=coordiId).order_by('-id')
    selectedGridList = SelectedGrid.objects.filter(design=design).order_by('grid__groupCode', 'grid__gridIndex')

    product_grids = {}
    for product in productList:
        pid = product.id
        product_grids[pid] = []

    composite_img = Image.open(settings.MEDIA_ROOT + 'data/model/'+design.coordi.gender+'.png')
    jacketNo = 500
    vestNo = 500
    accNo = 500
    for grid in selectedGridList:
        pid = grid.grid.style.detail.product_id
        product_grids[pid].append({'id': grid.grid.id, 'png': grid.grid.pngPath.url, 'groupCode': grid.grid.groupCode})

        groupCode = int(grid.grid.groupCode)

        if design.coordi.season == 'W':
            vestNo = 300
        print vestNo

        if groupCode < jacketNo :
            if not(vestNo <= groupCode < vestNo+100) :
                if not(accNo <= groupCode < accNo+100) :
                    with Image.open(grid.grid.pngPath) as i:
                        with composite_img as c:
                            composite_img = Image.alpha_composite(c, i)
                            grid.grid.pngPath.close()

#        with Image.open(grid.grid.pngPath) as i:
#            with composite_img as c:
#                composite_img = Image.alpha_composite(c, i)
		
#        with Image.open(grid.grid.pngPath) as i:
#            with composite_img as c:
#                composite_img = Image.alpha_composite(c, i)

    deleteThumbDir = settings.MEDIA_ROOT+'data/testFirstGrid'
    try:
        shutil.rmtree(deleteThumbDir)
    except OSError as e:
        if e.errno == 2:
            # no File
            print 'No such file or directory to remove'
            pass
        else:
            raise

    UPLOAD_DIR = settings.MEDIA_ROOT + 'data/testFirstGrid'
    if not os.path.exists(UPLOAD_DIR):
        os.makedirs(UPLOAD_DIR)

    fname = '/' + str(uuid.uuid1())
    filePath = UPLOAD_DIR + fname + '.png'

    composite_img.save(filePath, 'PNG')
    composite_img.close()

    src = '/media/data/testFirstGrid' + fname + '.png'
    data = {'gridList': product_grids, 'selectedthumb': src}

    return HttpResponse(json.dumps(data, encoding='utf-8'))'''

@csrf_exempt
def getSelectedGridList(request):
    try:
        designId = int(request.POST['designId'])
        design = Design.objects.get(id=designId)
        coordiId = design.coordi
    except Exception as e:
        print str(e)

    productList = Product.objects.filter(coordi=coordiId).order_by('-id')
    selectedGridList = SelectedGrid.objects.filter(design=design).order_by('grid__groupCode', 'grid__fabricGroup')

    product_grids = {}
    for product in productList:
        pid = product.id
        product_grids[pid] = []

    for grid in selectedGridList:
        pid = grid.grid.style.detail.product_id
        product_grids[pid].append({'id': grid.grid.id, 'png': grid.grid.pngPath.url, 'groupCode': grid.grid.groupCode})

    return HttpResponse(json.dumps(product_grids, encoding='utf-8'))


@csrf_exempt
def getFabricList(request):
    fabrics = []
    coordiId = int(request.POST['coordiId'])
    designId = int(request.POST['designId'])

    coordi = Coordi.objects.get(id=coordiId)

    try:
        selectedGridList = SelectedGrid.objects.filter(design_id=designId)
    except Exception as e:
        print str(e)

    selectedGridFabricList = selectedGridList.values('grid__fabricGroup__id', 'grid__fabric__id').distinct('grid__fabricGroup')
    fabricGroupList = FabricGroup.objects.filter(coordi_id=coordiId).order_by('id')

    i = 0
    errorCount = 0
    for fabricGroup in fabricGroupList:
        print i
        print fabricGroup.id
        if (i - errorCount) < selectedGridFabricList.__len__():
            print selectedGridFabricList[i - errorCount]
            if fabricGroup.id == selectedGridFabricList[i - errorCount]['grid__fabricGroup__id']:
                currentFabric = selectedGridFabricList[i - errorCount]['grid__fabric__id']
            else:
                currentFabric = -1
                errorCount += 1
        else:
            currentFabric = -1
            errorCount += 1

        fabrics.append({'id': fabricGroup.id, 'name': fabricGroup.name, 'currentFabric': [], 'fabric': []})

        fabricList = Fabric.objects.filter(fabricGroup=fabricGroup.id).order_by('id')

        for fabric in fabricList:
            if currentFabric == -1:
                currentFabric = fabric.id
            if fabric.id == currentFabric:
                fabrics[i]['currentFabric'].append({'id': fabric.id, 'name': fabric.name, 'thumb': fabric.thumb.url})

            fabrics[i]['fabric'].append({'id': fabric.id, 'name': fabric.name, 'thumb': fabric.thumb.url})
        i += 1

    return HttpResponse(json.dumps(fabrics, indent=4, ensure_ascii=False, encoding='utf-8'))



def createProduct(request):
    coordi = ''
    design = ''
    coordi_path = ''

    if request.FILES.has_key('tex3dXml'):
        try:
            print os.getpid()

            tex3dXml = request.FILES['tex3dXml']
        except Exception as e:
            print 'line247'
            print str(e)
            raise Http404

        try:
            coordi = Coordi()
            coordi.save()

            coordi_path = settings.MEDIA_ROOT + 'data/coordi/' + str(coordi.id)
            filename = 'data/coordi/' + str(coordi.id) + '/xml/' + tex3dXml.name
            coordi.xml.save(filename, ContentFile(tex3dXml.read()))

            with open(coordi_path + '/xml/' + tex3dXml.name) as xml:
                doc = parse(xml)
            root = doc.getroot()

        except Exception as e:
            print 'line264'
            print str(e)
            coordi.delete()
            remove_dir_tree(coordi_path)
            raise Http404

        try:
            coordi_element = root.find("Coordi")
            coordi_name = coordi_element.get("name").split(".")[0]
            uploader = coordi_element.get("id")

            coordi.name = coordi_name
            coordi.season = coordi_name[0:1].upper()
            coordi.gender = coordi_name[3:4].upper()
            coordi.code = coordi_name[4:8]
            coordi.collar = coordi_name[9:10].upper()
            coordi.save()

            design = Design(coordi=coordi, name=coordi_name, origin=True, uploader=uploader, orderCode=coordi_name[10:])
            design.save()
        except Exception as e:
            print 'line285'
            print str(e)
            coordi.delete()
            remove_dir_tree(coordi_path)
            raise Http404

        try:
            for xmlProduct in root.iter("Product"):
                product_name = xmlProduct.attrib["name"]
                product_index = xmlProduct.attrib["product_index"]

                product = Product(name = product_name, coordi = coordi, index = product_index)
                product.save()

                for xmlDetail in xmlProduct.iter("Detail"):
                    detail_name = xmlDetail.attrib["name"]
                    detail_index = xmlDetail.attrib["detail_index"]

                    detail = Detail(name=detail_name, product=product, index = detail_index)
                    detail.save()

                    for xmlStyle in xmlDetail.iter("Style"):
                        style_name = xmlStyle.attrib["name"]
                        style_index = xmlStyle.attrib["style_index"]

                        style = Style(name=style_name, detail=detail, index = style_index)
                        style.save()

        except Exception as e:
            print 'line314'
            print str(e)
            coordi.delete()
            remove_dir_tree(coordi_path)
            raise Http404

        s = 0
        try:
            for xmlFabricGroup in root.iter("FabricGroup"):
                group_name = xmlFabricGroup.attrib["name"]
                group_code = xmlFabricGroup.attrib["group_code"]

                fabricgroup = FabricGroup(name=group_name, coordi=coordi, code=group_code)
                s += 1

                try:
                    print next(xmlFabricGroup.iter("Fabric"))
                    fabricgroup.save()
                except Exception as e:
                    print str(e)
                    continue

                for xmlFabric in xmlFabricGroup.iter("Fabric"):
                    fabric_name = xmlFabric.attrib["name"].split(".")[0]
                    fabric_code = xmlFabric.attrib["fabric_index"]

                    fabric = Fabric(fabricGroup=fabricgroup, name=fabric_name, code=fabric_code, thumb='')
                    fabric.save()
        except Exception as e:
            print 'line343'
            print str(e)
            coordi.delete()
            remove_dir_tree(coordi_path)
            raise Http404


    if request.FILES.has_key('StyleThumb'):
        print "style"

        for style in enumerate(request.FILES.getlist('StyleThumb')):
            try:
                styleFile = style[1].name

                product_index = styleFile[0:1]
                detail_index = styleFile[1:2]
                style_index = styleFile[2:3]

                thumb = 'data/coordi/'+str(coordi.id)+'/style/'+styleFile

                product_object = Product.objects.get(coordi=coordi, index=product_index)
                detail_object = Detail.objects.get(product=product_object, index=detail_index)
                style_object = Style.objects.get(detail=detail_object, index=style_index)
                style_object.thumb.save(thumb, ContentFile(style[1].read()))
                style[1].close()
            except Exception as e:
                print 'line369'
                print "styleThumb : " + str(e)
                print style[1].name
                coordi.delete()
                remove_dir_tree(coordi_path)
                raise Http404

    if request.FILES.has_key('FabricThumb'):
        print "Fabric"

        for fabric in enumerate(request.FILES.getlist('FabricThumb')):
            try:
                fabricFile = fabric[1].name

                group_code = fabricFile[0:2]
                fabric_code = fabricFile[2:4]

                thumb = 'data/coordi/' + str(coordi.id) + '/fabric/' + fabricFile

                fabricgroup_object = FabricGroup.objects.filter(coordi=coordi, code=group_code)

                if fabricgroup_object.count() == 0:
                    pass
                else:
                    fabricgroup_object = fabricgroup_object[0]
                    fabric_object = Fabric.objects.get(fabricGroup=fabricgroup_object, code=fabric_code)
                    fabric_object.thumb.save(thumb, ContentFile(fabric[1].read()))
                    fabric[1].close()
                    fabricgroup_object.save()
                    fabric_object.save()
            except Exception as e:
                print 'line400'
                print "fabricThumb" + str(e)
                coordi.delete()
                remove_dir_tree(coordi_path)
                raise Http404

        if coordi.season == 'W':
            searchFabricGroup = FabricGroup.objects.get(coordi_id=coordi.id, code='00')
            searchFabric = Fabric.objects.get(fabricGroup=searchFabricGroup, code='00')
            coordi.fabric = searchFabric.name[0:1]
            coordi.color = searchFabric.name[2:3]
            coordi.save()
        else:
            searchFabricGroup = FabricGroup.objects.get(coordi_id=coordi.id, code='12')
            searchFabric = Fabric.objects.get(fabricGroup=searchFabricGroup, code='00')
            coordi.fabric = searchFabric.name[0:1]
            coordi.color = searchFabric.name[2:3]

    print "Grid Image"

    coordi = Coordi.objects.all().latest('id')
    design = Design.objects.get(coordi=coordi)

    if request.FILES.has_key('GridImages'):

        # grid Image save
        for grid in enumerate(request.FILES.getlist('GridImages')):
            try:
                file = grid[1].name
                filename = 'data/coordi/' + str(coordi.id) + '/grid/' + file

                styleIndex = file[6:7]
                fabricCode = file[2:4]

                fabricgroup = FabricGroup.objects.get(coordi=coordi, code=file[0:2])
                fabric = Fabric.objects.get(fabricGroup=fabricgroup, code=file[2:4])
                product = Product.objects.get(coordi=coordi, index=file[4:5])
                detail = Detail.objects.get(product=product, index=file[5:6])
                style = Style.objects.get(detail=detail, index=file[6:7])

                # fix image size
                f = StringIO()
                with Image.open(ContentFile(grid[1].read())) as img:
                    gridImg = img.resize((1260, 1323), Image.ANTIALIAS)
                    gridImg.save(f, 'png')

                grid_object = Grid(fabric=fabric, fabricGroup=fabricgroup, style=style, groupCode=file[4:7])
                grid_object.pngPath.save(filename, ContentFile(f.getvalue()))
                grid_object.save()

                grid[1].close()
                gridImg.close()
                f.close()
                
                if styleIndex == "0" and fabricCode == "00":
                    selectedgrid = SelectedGrid(design=design, grid=grid_object)
                    selectedgrid.save()

            except Exception as e:
                print 'line451'
                print str(e)
                coordi.delete()
                remove_dir_tree(coordi_path)
                raise Http404

    if request.POST.has_key('createEnd'):
        createDesignThumbnail(design.id)
    else:
        pass

    variables = {'success': True}
    return HttpResponse(variables)

'''@csrf_exempt
def changeGrid(request):
    currentFabricIds = request.POST.getlist('currentFabricIds[]')
    currentStyleIds = request.POST.getlist('currentStyleIds[]')
    coordiId = int(request.POST['coordiId'])

    gridList = Grid.objects.filter(style__id__in=currentStyleIds).order_by('groupCode', 'fabricGroup')
    gridList = gridList.filter(fabric__id__in=currentFabricIds)

    productList = Product.objects.filter(coordi=coordiId).order_by('-id')

    product_grids = {}
    for product in productList:
        pid = product.id
        product_grids[pid] = []

    for grid in gridList:
        pid = grid.style.detail.product_id
        product_grids[pid].append({'id': grid.id, 'png': grid.pngPath.url, 'groupCode': grid.groupCode})

    gender = Coordi.objects.get(id=coordiId).gender
    composite_img = Image.open(settings.MEDIA_ROOT+'data/model/'+gender.upper()+'.png')
    jacketNo = int(request.POST['jacketNo'])
    vestNo = int(request.POST['vestNo'])
    accNo = int(request.POST['accNo'])
    for grid in gridList:
        groupCode = int(grid.groupCode)

        if jacketNo == 500:
            vestNo = 300

        if groupCode < jacketNo :
            if not(vestNo <= groupCode < vestNo+100) :
                if not(accNo <= groupCode < accNo+100) :
                    with Image.open(grid.pngPath) as i:
                        with composite_img as c:
                            composite_img = Image.alpha_composite(c, i)
                            grid.pngPath.close()

    print composite_img

    deleteThumbDir = settings.MEDIA_ROOT+'data/changGrid'
    try:
        shutil.rmtree(deleteThumbDir)
    except OSError as e:
        if e.errno == 2:
            # no File
            print 'No such file or directory to remove'
            pass
        else:
            raise

    UPLOAD_DIR = settings.MEDIA_ROOT+'data/changGrid'
    if not os.path.exists(UPLOAD_DIR):
        os.makedirs(UPLOAD_DIR)

    fname = '/'+str(uuid.uuid1())
    filePath = UPLOAD_DIR + fname + '.png'

    composite_img.save(filePath, 'PNG')
    composite_img.close()

    src = '/media/data/changGrid/'+fname+'.png'

    data = {'gridList':product_grids, 'selectedthumb': src }

    return HttpResponse(json.dumps(data, encoding='utf-8')'''

@csrf_exempt
def changeGrid(request):
    currentFabricIds = request.POST.getlist('currentFabricIds[]')
    currentStyleIds = request.POST.getlist('currentStyleIds[]')
    coordiId = int(request.POST['coordiId'])

    gridList = Grid.objects.filter(style__id__in=currentStyleIds).order_by('groupCode', 'fabricGroup')
    gridList = gridList.filter(fabric__id__in=currentFabricIds)

    productList = Product.objects.filter(coordi=coordiId).order_by('-id')

    product_grids = {}
    for product in productList:
        pid = product.id
        product_grids[pid] = []

    for grid in gridList:
        pid = grid.style.detail.product_id
        product_grids[pid].append({'id': grid.id, 'png': grid.pngPath.url, 'groupCode': grid.groupCode})

    return HttpResponse(json.dumps(product_grids, encoding='utf-8'))

@csrf_exempt
def saveDesign(request):
    coordiId = int(request.POST['coordiId'])
    designName = request.POST['designName']
    orderCode = request.POST['orderCode']
    schoolId = int(request.POST['schoolId'])
    currentGridIds = request.POST.getlist('currentGridIds[]')
    designType = request.POST['designType']

    userinformation = request.session['userinformation']
    coordi = Coordi.objects.get(id=coordiId)
    design = Design(coordi=coordi, name=designName, uploader=userinformation.name, orderCode=orderCode)

    design.save()

    try:
        base64img = request.POST['img'].split(',')[1]
        decodeImg = base64.b64decode(base64img)
        filename = 'data/design/' + str(design.id) + '.png'

        if os.path.isfile(settings.MEDIA_ROOT+filename):
            os.remove(settings.MEDIA_ROOT+filename)

        design.thumb.save(filename, ContentFile(decodeImg))
    except Exception as e:
        print 'khs1221'
        print str(e)
        variables = {'error2': str(e)}
        return HttpResponse(variables)

    try:
        for grid in currentGridIds:
            selectedgrid = SelectedGrid(design = design, grid_id = grid)
            selectedgrid.save()
    except Exception as e:
        print str(e)
        variables = {'error2': str(e), 'errormsg': 'griderror', 'currentGridIds': currentGridIds}
        return HttpResponse(json.dumps(variables, encoding='utf-8'))

    if designType == "favorite":
        favoriteDesign = FavoriteDesign(design = design, school_id = schoolId)
        favoriteDesign.save()
    elif designType == "offer":
        offerDesign = OfferDesign(design = design, school_id = schoolId)
        offerDesign.save()
    elif designType == "select":
        print designType
        designId = design.id
        newDesignObj = Design.objects.get(id=designId)
        newDesignObj.selectedCount = newDesignObj.selectedCount + 1
        newDesignObj.save()
        gender = newDesignObj.coordi.gender
        season = newDesignObj.coordi.season
        print gender
        print season
        try:
            schoolObj = School.objects.get(id=schoolId)

            originDesignObj = schoolObj.selected_design.get(coordi__season=season, coordi__gender=gender)

            selectedDesignObj = SelectedDesign.objects.get(school_id=schoolId, design_id=originDesignObj.id)
            selectedDesignObj.design_id = newDesignObj.id
            selectedDesignObj.save()
        except:
            selectDesign = SelectedDesign(design = design, school_id = schoolId)
            selectDesign.save()


    variables = {'designId': design.id}
    return HttpResponse(json.dumps(variables, encoding='utf-8'))


@csrf_exempt
def createDesignThumbnail(designId):
    designId = designId
    design = Design.objects.get(id=designId)
    gender = design.coordi.gender
    selectedgrids = SelectedGrid.objects.filter(design=designId).order_by('grid__groupCode', 'grid__fabricGroup')

    composite_img = ''
    if gender == 'B':
        composite_img = Image.open(settings.MEDIA_ROOT+'data/model/b.png')
    elif gender == 'G':
        composite_img = Image.open(settings.MEDIA_ROOT+'data/model/g.png')
    else:
        print 'gender not B or G'
        raise

    with Image.open(selectedgrids[0].grid.pngPath) as img:
        if not img.size == composite_img.size:
            composite_img = composite_img.resize(img.size, Image.ANTIALIAS)

    # for selectedgrid in selectedgrids:
    #     img = Image.open(selectedgrid.grid.pngPath)
    #     with composite_img as c:
    #         composite_img = Image.alpha_composite(c, img)
    #     img.close()

    jacketNo = 500
    vestNo = 500
    accNo = 500
    for selectedgrid in selectedgrids:
        groupCode = int(selectedgrid.grid.groupCode)
        if design.coordi.season == 'W':
            vestNo = 300
        if groupCode < jacketNo :
            if not(vestNo <= groupCode < vestNo+100) :
                if not(accNo <= groupCode < accNo+100) :
                    with Image.open(selectedgrid.grid.pngPath) as i:
                        with composite_img as c:
                            composite_img = Image.alpha_composite(c, i)
                            selectedgrid.grid.pngPath.close()
#        with Image.open(selectedgrid.grid.pngPath) as i:
#            with composite_img as c:
#                composite_img = Image.alpha_composite(c, i)

    composite_img = composite_img.resize((600, 630), Image.ANTIALIAS)

    temp_handle = StringIO()
    composite_img.save(temp_handle, 'PNG')
    temp_handle.seek(0)

    thumbImage = ContentFile(temp_handle.read())
    temp_handle.close()
    IMAGE_EXTENSION = '.png'

    image_filename = 'data/design/'+str(design.id) + IMAGE_EXTENSION
    design.thumb.save(image_filename, ContentFile(thumbImage.read()))

    composite_img.close()
    thumbImage.close()

    variables = {'success': True}
    return HttpResponse(variables)

@csrf_exempt
def changeGender(request):
    designId = request.POST['designId']
    gender = request.POST['gender']

    coordiCode = Design.objects.get(id=designId).coordi.code
    coordi = Coordi.objects.filter(code=coordiCode)
    switchCoordi = coordi.exclude(gender=gender).values('id')[0:1]

    if switchCoordi:
        switchDesignId = Design.objects.get(coordi_id = switchCoordi, origin=True)
    else:
        variables = {'success': False}
        return HttpResponse(json.dumps(variables, encoding='utf-8'))

    variables = {'success': True, 'switchDesignId': switchDesignId.id}
    return HttpResponse(json.dumps(variables, encoding='utf-8'))

@csrf_exempt
def getSchoolList(request):
    grade = int(request.POST['grade'])
    schoolList = []

    user = request.session['user']
    userinformation = request.session['userinformation']

    if userinformation.userAuthority == 3:
        schools = School.objects.filter(agencyId__users__id=user.id, grade=grade)

        for school in schools:
            schoolList.append({
                'id': school.id,
                'name': school.schoolName
            })
        variables = {'success': True, 'schoolList': schoolList}

        return HttpResponse(json.dumps(variables, encoding='utf-8'))
    else:
        variables = {'success': True}
        return HttpResponse(json.dumps(variables, encoding='utf-8'))

