from django.db import models
from django.contrib.auth.models import User, Permission
from django.db.models.signals import post_save, pre_delete

class UserInformation(models.Model):
	user = models.OneToOneField(User, on_delete=models.CASCADE)
	name = models.CharField(max_length=128)
	mobile = models.CharField(max_length=20)
	USERAUTHORITY_CHOICE = (
		(1, 'admin'),
		(2, 'designer'),
		(3, 'trader'),
		(4, 'defaultUser'),
	)
	userAuthority = models.IntegerField(default=4, choices=USERAUTHORITY_CHOICE)

class Agency(models.Model):
	users = models.ManyToManyField(User)
	wholesale = models.CharField(max_length=50)
	agencyName = models.CharField(max_length=128)
	sellerName = models.CharField(max_length=128)
	tel = models.CharField(max_length=20)
	fax = models.CharField(max_length=20)
	mobile = models.CharField(max_length=20)
	email = models.CharField(max_length=128)
	detailAddress = models.CharField(max_length=100)
	dong = models.CharField(max_length=100)
	zipCode = models.IntegerField()
	address = models.CharField(max_length=128)

	def __unicode__(self):
		return unicode(self.agencyName)

class School(models.Model):
	grade = models.IntegerField()
	sido = models.CharField(max_length=400)
	gu = models.CharField(max_length=400)
	schoolName = models.CharField(max_length=50)
	establish = models.CharField(max_length=400)
	gender = models.CharField(max_length=400)
	zip_code = models.CharField(max_length=400)
	address = models.CharField(max_length=400)
	tel = models.CharField(max_length=20)
	fax = models.CharField(max_length=400)
	url = models.CharField(max_length=400)
	memo = models.TextField(null=True)
	banner = models.ImageField(upload_to='data/schoolBanner', null=True, default='data/schoolBanner/thumb_school_list_defualt.png')
	agencyId = models.ForeignKey(Agency, on_delete=models.CASCADE, null=True)
	second_agencyId = models.CharField(max_length=400, null=True)
	designUpdated = models.DateTimeField(auto_now=False, auto_now_add=False, null=True)

	def __unicode__(self):
		return self.sido +' '+ self.gu +' '+ self.schoolName