# -*- coding: utf8 -*-

from django.template import RequestContext
from django.shortcuts import render_to_response, get_object_or_404
from django.http import HttpResponseRedirect, HttpResponse, Http404
from django.views.decorators.csrf import csrf_exempt, csrf_protect
from django.template.context_processors import csrf
from django.contrib.auth import authenticate, login, logout
from django.contrib.auth.decorators import login_required
from django.contrib.auth.models import User, Permission
from django.core import serializers
from datetime import timedelta, datetime
from users.models import *
from board.models import *
from product.models import *
from viewer import paging
import json
import sys

reload(sys)
sys.setdefaultencoding('utf8')

#OTHER_KEY list use input post data filter from model field
OTHER_KEY = ['id', 'school', 'users', 'user', 'user_id']
LOGIN_ERROR_MSG = 'incorrect id or password'
METHOD_MISMATCH = 'request method mismatch'
NOT_LOGIN_MSG = '로그인 해 주세요'
NOT_ADMIN = '권한이 없습니다.'

#LoginMethod
def loginPage(request):
	variables = {}
	return render_to_response('published/login.html', RequestContext(request, variables))

@csrf_exempt
def loginSite(request):
	if request.method == 'POST':
		username = request.POST['username']
		password = request.POST['password']

		# if username or password is null
		# this case have verified on front page.
		if not request.POST['username'] or not request.POST['password']:
			return HttpResponseRedirect('/login')

		try:
			user = authenticate(username=username, password=password)
			if user is not None:
				if user.is_active:
					login(request, user)
					request.session['user'] = request.user
					request.session['userinformation'] = request.user.userinformation
					request.session.set_expiry(timedelta(days=365))
					variables = {'user':request.user, 'userinfo':request.user.userinformation}
					return render_to_response('published/170522_pages/main_new.html', RequestContext(request, variables))
				else:
					variables = {'error':LOGIN_ERROR_MSG}
					return render_to_response('pages/errorPage.html', RequestContext(request, variables))
			else:
				variables = {'error':LOGIN_ERROR_MSG}
				return render_to_response('pages/errorPage.html', RequestContext(request, variables))
		except:
			variables = {'error':LOGIN_ERROR_MSG}
			return render_to_response('pages/errorPage.html', RequestContext(request, variables))

@csrf_exempt
def loginAjax(request):
	if request.method == 'POST':
		username = request.POST['username']
		password = request.POST['password']

		# if username or password is null
		# this case have verified on front page.
		if not request.POST['username'] or not request.POST['password']:
			response = {'success':False, 'reason':'InvalidIdPasswd'}
			return HttpResponse(json.dump(response))
		try:
			user = authenticate(username=username, password=password)
			if user is not None:
				if user.is_active:
					login(request, user)
					request.session['user'] = request.user
					request.session['userinformation'] = request.user.userinformation
					request.session.set_expiry(timedelta(days=365))
					variables = {'success': True, 'id': user.id, 'permission': user.userinformation.userAuthority}
					return HttpResponse(json.dumps(variables), content_type='application/json')
				else:
					response = {'error':LOGIN_ERROR_MSG}
					return render_to_response('pages/errorPage.html', RequestContext(request, response))
			else:
				variables = {'success':False, 'reason':'InvalidIdPasswd'}
				return render_to_response('pages/errorPage.html', RequestContext(request, variables))
		except:
			raise Http404

def Logout(request):
	try:
		if request.method == "POST":
			logout(request)
			return HttpResponseRedirect('/')
		else:
			logout(request)
			return HttpResponseRedirect('/')
	except Exception as e:
		print str(e)

#RegisterMethod
def signupPage(request):
	if request.user.is_authenticated():
		loginUser = request.session['user']
		loginUserinformation = request.session['userinformation']
		if (loginUserinformation.userAuthority > 1):
			return render_to_response('published/main.html', {'user': loginUser, 'userinfo': loginUserinformation, 'permissionError': '권한이없습니다 관리자에게 문의해보세요'})
		if loginUserinformation.userAuthority == 1:
			try:
				variables = {}
				return render_to_response('pages/signup.html', RequestContext(request, variables))
			except Exception as e:
				variables = {'error':str(e)}
				return render_to_response('pages/errorPage.html', RequestContext(request, variables))
		else:
			variables = {'error':NOT_ADMIN}
			return render_to_response('pages/errorPage.html', RequestContext(request, variables))
	else:
		variables = {'error':NOT_LOGIN_MSG}
		return render_to_response('pages/errorPage.html', RequestContext(request, variables))

#Register first Admin
# def signupPage(request):
#     try:
#         variables = {}
#         return render_to_response('pages/signup.html', RequestContext(request, variables))
#     except Exception as e:
#         variables = {'error': str(e)}
#         return render_to_response('pages/errorPage.html', RequestContext(request, variables))

def signupSite(request):
	if request.user.is_authenticated():
		loginUser = request.session['user']
		loginUserinformation = request.session['userinformation']
		if loginUserinformation.userAuthority == 1:
			try:
				if request.method == 'POST':
					#user value input
					username = request.POST['username']
					password = request.POST['password']
					email = request.POST['email']

					try:
						#already name filter
						if User.objects.filter(username=username).exists():
							variables = {'error':'user id already exist'}
							return render_to_response('pages/errorPage.html', RequestContext(request, variables))
						else:
							user = User.objects.create_user(username=username, email=email)
							user.set_password(password)
							user.save()
					except Exception as e:
						variables = {'error':str(e)}
						return render_to_response('pages/errorPage.html', RequestContext(request, variables))

					# userInformation value input
					newUserInfo = {}
					for userInfoData in UserInformation._meta.get_all_field_names():
						if userInfoData in OTHER_KEY:
							pass
						else:
							newUserInfo[userInfoData] = request.POST[userInfoData]

					#userInformation create & save
					try:
						userInformation = UserInformation.objects.create(user=user, **newUserInfo)
						userInformation.save()
					except Exception as e:
						variables = {'error':str(e)}
						return render_to_response('pages/errorPage.html', RequestContext(request, variables))

					return HttpResponseRedirect('/manager/user')
			except Exception as e:
				variables = {'error':str(e)}
				return render_to_response('pages/errorPage.html', RequestContext(request, variables))
		else:
			variables = {'error':NOT_ADMIN}
			return render_to_response('pages/errorPage.html', RequestContext(request, variables))
	else:
		variables = {'error':NOT_LOGIN_MSG}
		return render_to_response('pages/errorPage.html', RequestContext(request, variables))

#Register First Admin
# def signupSite(request):
# 	try:
# 		if request.method == 'POST':
# 			#user value input
# 			username = request.POST['username']
# 			password = request.POST['password']
# 			email = request.POST['email']
# 			print 'run1'
#
# 			try:
# 				#already name filter
# 				if User.objects.filter(username=username).exists():
# 					variables = {'error':'user id already exist'}
# 					return render_to_response('pages/errorPage.html', RequestContext(request, variables))
# 				else:
# 					user = User.objects.create_user(username=username, email=email)
# 					print 'run4'
# 					user.set_password(password)
# 					user.save()
# 			except Exception as e:
# 				print 1
# 				variables = {'error':str(e)}
# 				return render_to_response('pages/errorPage.html', RequestContext(request, variables))
# 			print 'run2'
#
# 			# userInformation value input
# 			newUserInfo = {}
# 			for userInfoData in UserInformation._meta.get_all_field_names():
# 				if userInfoData in OTHER_KEY:
# 					pass
# 				else:
# 					newUserInfo[userInfoData] = request.POST[userInfoData]
#
# 			#userInformation create & save
# 			try:
# 				userInformation = UserInformation.objects.create(user=user, **newUserInfo)
# 				userInformation.save()
# 			except Exception as e:
# 				print 2
# 				variables = {'error':str(e)}
# 				return render_to_response('pages/errorPage.html', RequestContext(request, variables))
#
# 			return HttpResponseRedirect('/')
# 	except Exception as e:
# 		print 3
# 		variables = {'error':str(e)}
# 		return render_to_response('pages/errorPage.html', RequestContext(request, variables))

def modifyUserPage(request):
	if request.user.is_authenticated():
		loginUser = request.session['user']
		loginUserinformation = request.session['userinformation']
		if loginUserinformation.userAuthority == 1:
			try:
				userid = request.POST['id']
				modifiedUser = User.objects.get(id=userid)
				variables = {'modifiedUser':modifiedUser}
				return render_to_response('pages/modifyUser.html', RequestContext(request, variables))
			except Exception as e:
				variables = {'error':str(e)}
				return render_to_response('pages/errorPage.html', RequestContext(request, variables))
		else:
			variables = {'error':NOT_ADMIN}
			return render_to_response('pages/errorPage.html', RequestContext(request, variables))
	else:
		variables = {'error':NOT_LOGIN_MSG}
		return render_to_response('pages/errorPage.html', RequestContext(request, variables))

def modifyUser(request):
	if request.user.is_authenticated():
		loginUser = request.session['user']
		loginUserinformation = request.session['userinformation']
		if loginUserinformation.userAuthority == 1:
			try:
				if request.method == 'POST':
					#user modify value input
					userid = request.POST['id']
					password = request.POST['password']
					email = request.POST['email']

					try:
						user = User.objects.get(id=userid)
						if password:
							user.set_password(password)
						else:
							pass
						user.email = email
						user.save()
					except:
						variables = {'error':'incorrect user information'}
						return render_to_response('pages/errorPage.html', RequestContext(request, variables))

					#userInformation modify value input & modify
					try:
						userInformation = UserInformation.objects.get(user_id=userid)
						for modifyUserInfoData in UserInformation._meta.get_all_field_names():
							if modifyUserInfoData in OTHER_KEY:
								pass
							elif not request.POST[modifyUserInfoData]:
								pass
							else:
								setattr(userInformation, modifyUserInfoData, request.POST[modifyUserInfoData])

						userInformation.save()
					except:
						variables = {'error':'incorrect user information'}
						return render_to_response('pages/errorPage.html', RequestContext(request, variables))

					return HttpResponseRedirect('user')
			except Exception as e:
				variables = {'error':str(e)}
				return render_to_response('pages/errorPage.html', RequestContext(request, variables))
		else:
			variables = {'error':NOT_ADMIN}
			return render_to_response('pages/errorPage.html', RequestContext(request, variables))
	else:
		variables = {'error':NOT_LOGIN_MSG}
		return render_to_response('pages/errorPage.html', RequestContext(request, variables))

def deleteModel(request):
	if request.user.is_authenticated():
		loginUser = request.session['user']
		loginUserinformation = request.session['userinformation']
		delId = request.POST['id']
		delSelect = request.POST['model']
		if loginUserinformation.userAuthority == 1:
			try:
				if delSelect == 'user':
					delObject = User.objects.get(id=delId)
				elif delSelect == 'agency':
					delObject = Agency.objects.get(id=delId)
				elif delSelect == 'school':
					delObject = School.objects.get(id=delId)

				delObject.delete()

				return HttpResponseRedirect('/manager/%s' % delSelect)
			except Exception as e:
				variables = {'error':str(e)}
				return render_to_response('pages/errorPage.html', RequestContext(request, variables))
		else:
			variables = {'error':NOT_ADMIN}
			return render_to_response('pages/errorPage.html', RequestContext(request, variables))
	else:
		variables = {'error':NOT_LOGIN_MSG}
		return render_to_response('pages/errorPage.html', RequestContext(request, variables))

# 대리점관리 - 대리점 등록 page 호출
def createAgencyPage(request):
	if request.user.is_authenticated():
		loginUser = request.session['user']
		loginUserinformation = request.session['userinformation']
		if (loginUserinformation.userAuthority > 1):
			return render_to_response('published/main.html', {'user': loginUser, 'userinfo': loginUserinformation, 'permissionError': '권한이없습니다 관리자에게 문의해보세요'})
		if loginUserinformation.userAuthority == 1:
			try:
				traders = UserInformation.objects.filter(userAuthority=3)
				variables = {'traders':traders, 'user': loginUser, 'userinfo': loginUserinformation}
				return render_to_response('pages/createAgency.html', RequestContext(request, variables))
			except Exception as e:
				variables = {'error':str(e)}
				return render_to_response('pages/errorPage.html', RequestContext(request, variables))
		else:
			variables = {'error':NOT_ADMIN}
			return render_to_response('pages/errorPage.html', RequestContext(request, variables))
	else:
		variables = {'error':NOT_LOGIN_MSG}
		return render_to_response('pages/errorPage.html', RequestContext(request, variables))

# 대리점 관리 - 대리점 등록
def createAgency(request):
	if request.user.is_authenticated():
		loginUser = request.session['user']
		loginUserinformation = request.session['userinformation']
		if loginUserinformation.userAuthority == 1:
			try:
				#agency informaion input
				newAgency = {}
				if request.method == 'POST':
					try:
						for agencyData in Agency._meta.get_all_field_names():
							if agencyData in OTHER_KEY:
								pass
							else:
								newAgency[agencyData] = request.POST[agencyData]
						agency = Agency.objects.create(**newAgency)

						#agency user relation
						user_id = request.POST['trader']
						user = User.objects.get(id=user_id)

						agency.save()

						#agency user relation inject
						user.agency_set.add(agency)
						return HttpResponseRedirect('/manager/agency')
					except:
						variables = {'error':'incorrect agency data'}
						return render_to_response('pages/errorPage.html', RequestContext(request, variables))
			except Exception as e:
				variables = {'error':str(e)}
				return render_to_response('pages/errorPage.html', RequestContext(request, variables))
		else:
			variables = {'error':NOT_ADMIN}
			return render_to_response('pages/errorPage.html', RequestContext(request, variables))
	else:
		variables = {'error':NOT_LOGIN_MSG}
		return render_to_response('pages/errorPage.html', RequestContext(request, variables))

# 대리점 정보수정 페이지를 호출 하는 기능
# agencyLinkedUserIdList에 대리점과 연계된 유저들의 id를 담는다
def modifyAgencyPage(request):
	if request.user.is_authenticated():
		loginUser = request.session['user']
		loginUserinformation = request.session['userinformation']
		if loginUserinformation.userAuthority == 1:
			try:
				agencyId = request.POST['id']
				agency = Agency.objects.get(id=agencyId)
				traders = UserInformation.objects.filter(userAuthority=3).order_by('id')

				agencyLinkedUserIdList = []
				for user in agency.users.all():
					agencyLinkedUserIdList.append(user.id)

				variables = {'agency':agency, 'traders':traders, 'user': loginUser, 'userinfo': loginUserinformation, 'agencyLinkedUserIdList': agencyLinkedUserIdList}
				return render_to_response('pages/modifyAgency.html', RequestContext(request, variables))
			except Exception as e:
				variables = {'error':str(e)}
				return render_to_response('pages/errorPage.html', RequestContext(request, variables))
		else:
			variables = {'error':NOT_ADMIN}
			return render_to_response('pages/errorPage.html', RequestContext(request, variables))
	else:
		variables = {'error':NOT_LOGIN_MSG}
		return render_to_response('pages/errorPage.html', RequestContext(request, variables))

def modifyAgency(request):
	if request.user.is_authenticated():
		loginUser = request.session['user']
		loginUserinformation = request.session['userinformation']
		if loginUserinformation.userAuthority == 1:
			try:
				if request.method == 'POST':
					agencyId = request.POST['id']
					agency = Agency.objects.get(id=agencyId)
					#dynamic request value update. not yet block blank update.
					for key in agency._meta.get_all_field_names():
						if request.POST.has_key(key):
							#models field name not support direct array value.
							#so use setattr.
							setattr(agency, key, request.POST[key])
						else:
							pass

					#agency user relation
					if request.POST.has_key('trader'):
						user_ids = request.POST.getlist('trader')
						inner_ids = User.objects.filter(agency__id=agency.id)

						for inner_id in inner_ids:
							inner_user = User.objects.get(id=inner_id.id)
							agency.users.remove(inner_user)

						for user_id in user_ids:
							user = User.objects.get(id=user_id)
							user.agency_set.add(agency)
					else:
						for agencyLinkedUser in agency.users.all():
							agency.users.remove(agencyLinkedUser.id)

						pass
					agency.save()
					variables = {'success': 'agency input success'}
					# return HttpResponse(json.dumps(variables), mimetype='application/json')
					return HttpResponse(json.dumps(variables, indent=4, ensure_ascii=False, encoding='utf-8'))
				return HttpResponseRedirect('/manager/agency')
			except Exception as e:
				variables = {'error':str(e)}
				return render_to_response('pages/errorPage.html', RequestContext(request, variables))
		else:
			variables = {'error':NOT_ADMIN}
			return render_to_response('pages/errorPage.html', RequestContext(request, variables))
	else:
		variables = {'error':NOT_LOGIN_MSG}
		return render_to_response('pages/errorPage.html', RequestContext(request, variables))

def createSchoolPage(request):
	if request.user.is_authenticated():
		loginUser = request.session['user']
		loginUserinformation = request.session['userinformation']
		if (loginUserinformation.userAuthority > 1):
			return render_to_response('published/main.html', {'user': loginUser, 'userinfo': loginUserinformation, 'permissionError': '권한이없습니다 관리자에게 문의해보세요'})
		if loginUserinformation.userAuthority == 1:
			agencys = Agency.objects.all()
			variables = {'agencys':agencys, 'user': loginUser, 'userinfo': loginUserinformation}
			return render_to_response('pages/createSchool.html', RequestContext(request, variables))
		else:
			variables = {'error':NOT_ADMIN}
			return render_to_response('pages/errorPage.html', RequestContext(request, variables))
	else:
		variables = {'error':NOT_LOGIN_MSG}
		return render_to_response('pages/errorPage.html', RequestContext(request, variables))

def createSchool(request):
	if request.user.is_authenticated():
		loginUser = request.session['user']
		loginUserinformation = request.session['userinformation']
		if loginUserinformation.userAuthority == 1:
			try:
				#School information input
				schoolName = request.POST['schoolName']
				grade = request.POST['schoolGrade']
				sido = request.POST['sido']
				gu = request.POST['gu']
				zipCode = request.POST['zipCode']
				address = request.POST['address']
				gender = request.POST['gender']
				establish = request.POST['establish']
				tel = request.POST['tel']
				fax = request.POST['fax']
				url = request.POST['url']
				agency = request.POST['agency']
				# memo = request.POST['memo']

				#banner
				if request.FILES.has_key('banner') :
					banner = request.FILES['banner']
					school = School.objects.create(
						schoolName=schoolName,
						grade=grade,
						sido=sido,
						gu=gu,
						zip_code=zipCode,
						address=address,
						gender=gender,
						establish=establish,
						tel=tel,
						fax=fax,
						url=url,
						# memo=memo,
						banner=banner,
						agencyId_id=agency
					)
				else :
					school = School.objects.create(
						schoolName=schoolName,
						grade=grade,
						sido=sido,
						gu=gu,
						zip_code=zipCode,
						address=address,
						gender=gender,
						establish=establish,
						tel=tel,
						fax=fax,
						url=url,
						# memo=memo,
						agencyId_id=agency
					)

				#school agency relation
				agency = int(request.POST['agency'])

				if agency != 0:
					school.agencyId_id = agency
				school.save()

				agency = []
				if school.agencyId_id > 0:
					agency = Agency.objects.get(id=school.agencyId_id)
				variables = {'schoolId': school.id, 'school': school, 'agency': agency}

				return render_to_response('pages/detailManageSchool.html', RequestContext(request, variables))
			except Exception as e:
				variables = {'error':str(e)}
				return render_to_response('pages/errorPage.html', RequestContext(request, variables))
		else:
			variables = {'error':NOT_ADMIN}
			return render_to_response('pages/errorPage.html', RequestContext(request, variables))
	else:
		variables = {'error':NOT_LOGIN_MSG}
		return render_to_response('pages/errorPage.html', RequestContext(request, variables))

def modifySchoolPage(request):
	if request.user.is_authenticated():
		loginUser = request.session['user']
		loginUserinformation = request.session['userinformation']
		if loginUserinformation.userAuthority == 1:
			try:
				schoolId = request.POST['id']
				school = School.objects.get(id = schoolId)
				includeAgency = Agency.objects.get(id = school.agencyId_id)
				agencys = Agency.objects.all()
				variables = {'school':school, 'includeAgency':includeAgency, 'agencys':agencys}
				return render_to_response('pages/modifySchool.html', RequestContext(request, variables))
			except Exception as e:
				variables = {'error':str(e)}
				return render_to_response('pages/errorPage.html', RequestContext(request, variables))
		else:
			variables = {'error':NOT_ADMIN}
			return render_to_response('pages/errorPage.html', RequestContext(request, variables))
	else:
		variables = {'error':NOT_LOGIN_MSG}
		return render_to_response('pages/errorPage.html', RequestContext(request, variables))

def modifySchool(request):
	if request.user.is_authenticated():
		loginUser = request.session['user']
		loginUserinformation = request.session['userinformation']
		if loginUserinformation.userAuthority == 1:
			try:
				#School id
				schoolId = request.POST['id']
				school = School.objects.get(id = schoolId)

				for key in school._meta.get_all_field_names():
					if request.POST.has_key(key):
						setattr(school, key, request.POST[key])
					elif key == 'agencyId':
						setattr(school, key+'_id', request.POST[key+'_id'])
					else:
						pass

				school.save()

				return HttpResponseRedirect('/manager/schoolList')
			except Exception as e:
				variables = {'error':str(e)}
				return render_to_response('pages/errorPage.html', RequestContext(request, variables))
		else:
			variables = {'error':NOT_ADMIN}
			return render_to_response('pages/errorPage.html', RequestContext(request, variables))
	else:
		variables = {'error':NOT_LOGIN_MSG}
		return render_to_response('pages/errorPage.html', RequestContext(request, variables))

def getUserList(request):
	if request.user.is_authenticated():
		try:
			userList = User.objects.filter(is_staff=False).order_by('id')
			loginUser = request.session['user']
			loginUserinformation = request.session['userinformation']
			if loginUserinformation.userAuthority == 1:
				variables = {'userList':userList, 'user':loginUser, 'userinfo':loginUserinformation}
				return render_to_response('pages/userList.html', RequestContext(request, variables))
			else:
				variables = {'error':NOT_ADMIN}
				return render_to_response('pages/errorPage.html', RequestContext(request, variables))
		except Exception as e:
			variables = {'error':str(e)}
			return render_to_response('pages/errorPage.html', RequestContext(request, variables))
	else:
		variables = {'error':NOT_LOGIN_MSG}
		return render_to_response('pages/errorPage.html', RequestContext(request, variables))

# 대리점관리 대리점리스트 보기
def getAgencyList(request):
	if request.user.is_authenticated():
		loginUser = request.session['user']
		loginUserinformation = request.session['userinformation']
		if (loginUserinformation.userAuthority > 1):
			return render_to_response('published/main.html', {'user': loginUser, 'userinfo': loginUserinformation, 'permissionError': '권한이없습니다 관리자에게 문의해보세요'})
		if loginUserinformation.userAuthority == 1:
			try:
				try:
					agencyName = request.POST['agencyName']
				except:
					agencyName = ''
				try:
					page = request.POST['page']
				except:
					page = 1
				page = int(page)
				per_page = 8

				# totalCount = Agency.objects.all().__len__()
				totalCount = Agency.objects.filter(agencyName__contains=agencyName).__len__()

				totalPage = totalCount / per_page
				if (totalCount % per_page > 0):
					totalPage = totalPage + 1
				if (totalPage < page):
					page = totalPage

				start_pos = (page - 1) * per_page
				end_pos = start_pos + per_page

				# agencyList = Agency.objects.all()[start_pos:end_pos]
				agencyList = Agency.objects.filter(agencyName__contains=agencyName)[start_pos:end_pos]
				variables = {'agencyList':agencyList, 'user':loginUser, 'userinfo':loginUserinformation, "current": page, "max": totalPage, "agencyName": agencyName}
				return render_to_response('pages/agencyList.html', RequestContext(request, variables))
			except Exception as e:
				return HttpResponseRedirect('/manager/createAgencyPage')
		elif loginUserinformation.userAuthority == 3 and loginUser.id == int(request.GET['user_id']):
			try:
				user_id = request.GET['user_id']
				agencyList = Agency.objects.filter(users__id=user_id)
				variables = {'agencyList':agencyList, 'user':loginUser, 'userinfo':loginUserinformation}
				return render_to_response('pages/agencyList.html', RequestContext(request, variables))
			except Exception as e:
				print str(e)
		else:
			variables = {'error':NOT_ADMIN}
			return render_to_response('pages/errorPage.html', RequestContext(request, variables))
	else:
		variables = {'error':NOT_LOGIN_MSG}
		return render_to_response('pages/errorPage.html', RequestContext(request, variables))

def getSchoolList(request):
	if request.user.is_authenticated():
		loginUser = request.session['user']
		loginUserinformation = request.session['userinformation']
		if loginUserinformation.userAuthority == 1:
			try:
				schoolList = School.objects.all()
				variables = {'schoolList':schoolList, 'user':loginUser, 'userinfo':loginUserinformation}
				return render_to_response('pages/schoolList.html', RequestContext(request, variables))
			except Exception as e:
				variables = {'error':str(e)}
				return render_to_response('pages/errorPage.html', RequestContext(request, variables))
		elif loginUserinformation.userAuthority == 3 and loginUser.id == int(request.GET['user_id']):
			try:
				user_id = request.GET['user_id']
				agencyList = Agency.objects.filter(users__id=user_id)

				#select user included agency id
				agency_ids = []
				for agency in agencyList:
					agency_ids.append(agency.id)

				schoolList = School.objects.filter(agencyId_id__in=agency_ids)
				variables = {'schoolList':schoolList, 'user':loginUser, 'userinfo':loginUserinformation}
				return render_to_response('pages/schoolList.html', RequestContext(request, variables))
			except Exception as e:
				variables = {'error':str(e)}
				return render_to_response('pages/errorPage.html', RequestContext(request, variables))
		else:
			variables = {'error':NOT_ADMIN}
			return render_to_response('pages/errorPage.html', RequestContext(request, variables))
	else:
		variables = {'error':NOT_LOGIN_MSG}
		return render_to_response('pages/errorPage.html', RequestContext(request, variables))

@csrf_exempt
def simulation(request, design_id):
	if request.user.is_authenticated():
		design = Design.objects.get(id=design_id)
		coordi = design.coordi

		print("name")
		print(design.name)
		if(design.name[3] == 'B'):
			name = design.name[0] + design.name[1] + design.name[2] + 'G' +  design.name[4] + design.name[5] + design.name[6] + design.name[7]
		else:
			name = design.name[0] + design.name[1] + design.name[2] + 'B' + design.name[4] + design.name[5] + design.name[6] + design.name[7]

		print(name)

		try:
			Design.objects.get(name__contains=name)
			flag = 1
		except:
			flag = 0

		try:
			category = request.POST['category']
		except:
			category = 0
		try:
			schoolId = request.POST['schoolId']
		except:
			schoolId = None
		try:
			manage = request.POST['manage']
		except:
			manage = ''

		user = request.session['user']
		userInformation = request.session['userinformation']

		if userInformation.userAuthority == 3:
			agency = Agency.objects.filter(users=request.user)
			schoolList = School.objects.filter(agencyId__in = agency)


			variables = {'coordi': coordi, 'design': design, 'schoolList': schoolList, 'user': userInformation, 'category': category, 'schoolId': schoolId, 'manage': manage, 'authority':userInformation.userAuthority, 'flag':flag}

		else :
			variables = {'coordi': coordi, 'design': design, 'user': userInformation, 'category': category, 'schoolId': schoolId, 'manage': manage, 'flag':flag}

		return render_to_response('pages/simulation.html', RequestContext(request, variables))
	else:
		variables = {'error': NOT_LOGIN_MSG}
		return render_to_response('pages/errorPage.html', RequestContext(request, variables))

#userList Paging json
# 유저관리 유저리스트 보기
def getManagerUserList(request):
	if request.user.is_authenticated():
		loginUser = request.session['user']
		loginUserinformation = request.session['userinformation']
		if loginUserinformation.userAuthority == 1:
			try:
				authNumber = int(request.POST['auth'])
				if authNumber == 0:
					totalCount = User.objects.all().__len__()
				else:
					totalCount = User.objects.filter(userinformation__userAuthority=authNumber).__len__()
				pagingNumbers = paging.paging(int(request.POST['page']), int(request.POST['perPage']), totalCount)
				page = pagingNumbers['current']
				totalPage = pagingNumbers['totalPage']
				startPos = pagingNumbers['startPos']
				endPos = pagingNumbers['endPos']
			except Exception as e:
				variables = {'error': str(e)}
				return render_to_response('pages/errorPage.html', RequestContext(request, variables))
			try:
				userList = []
				if authNumber == 0:
					userListPagingObject = User.objects.all()[startPos:endPos]
				else:
					userListPagingObject = User.objects.filter(userinformation__userAuthority=authNumber)[startPos:endPos]

				for userInfo in userListPagingObject:
					userinformation = UserInformation.objects.get(user_id=userInfo.id)
					userList.append({'pk':userInfo.id ,'id':userInfo.username, 'name':userinformation.name, 'mobile':userinformation.mobile, 'auth':userinformation.get_userAuthority_display(), 'authId':userinformation.userAuthority})
				variables = {'userList': userList, 'current':page, 'max':totalPage}
				return HttpResponse(json.dumps(variables, ensure_ascii=False), content_type='application/json')
			except Exception as e:
				variables = {'error': str(e)}
				return render_to_response('pages/errorPage.html', RequestContext(request, variables))
		else:
			variables = {'error': NOT_ADMIN}
			return render_to_response('pages/errorPage.html', RequestContext(request, variables))
	else:
		variables = {'error': NOT_LOGIN_MSG}
		return render_to_response('pages/errorPage.html', RequestContext(request, variables))

# schoolList Paging json
# 학교관리 학교리스트 보기
def getManagerSchoolList(request):
	if request.user.is_authenticated():

		try:
			grade = int(request.POST['grade'])
		except KeyError:
			grade = 0
		try:
			sido = request.POST['sido']
		except KeyError:
			sido = ''
		try:
			gu = request.POST['gu']
		except KeyError:
			gu = ''
		try:
			schoolName = request.POST['schoolName']
		except KeyError:
			schoolName = ''

		# 학교이름으로 검색하는 경우
		if schoolName.__len__() > 0:

			totalCount = School.objects.filter(schoolName__contains=schoolName).__len__()
			pagingNumbers = paging.paging(int(request.POST['page']), int(request.POST['perPage']), totalCount)
			page = pagingNumbers['current']
			totalPage = pagingNumbers['totalPage']
			startPos = pagingNumbers['startPos']
			endPos = pagingNumbers['endPos']
			schoolListPagingObject = School.objects.filter(schoolName__contains=schoolName).order_by('id')[startPos:endPos]
			schoolListPaging = serializers.serialize('json', schoolListPagingObject)
			variables = {'schoolList':schoolListPaging, 'current':page, 'max':totalPage}
			return HttpResponse(json.dumps(variables, ensure_ascii=False), content_type='application/json')

		if grade > 0:

			if sido.__len__() > 0:

				if gu.__len__() > 0:

					totalCount = School.objects.filter(grade=grade, sido=sido, gu=gu).__len__()
					pagingNumbers = paging.paging(int(request.POST['page']), int(request.POST['perPage']), totalCount)
					page = pagingNumbers['current']
					totalPage = pagingNumbers['totalPage']
					startPos = pagingNumbers['startPos']
					endPos = pagingNumbers['endPos']
					schoolListPagingObject = School.objects.filter(grade=grade, sido=sido, gu=gu)[startPos:endPos]
					schoolListPaging = serializers.serialize('json', schoolListPagingObject)
					variables = {'schoolList': schoolListPaging, 'current': page, 'max': totalPage}
					return HttpResponse(json.dumps(variables, ensure_ascii=False), content_type='application/json')

				totalCount = School.objects.filter(grade=grade, sido=sido).__len__()
				pagingNumbers = paging.paging(int(request.POST['page']), int(request.POST['perPage']), totalCount)
				page = pagingNumbers['current']
				totalPage = pagingNumbers['totalPage']
				startPos = pagingNumbers['startPos']
				endPos = pagingNumbers['endPos']
				schoolListPagingObject = School.objects.filter(grade=grade, sido=sido)[startPos:endPos]
				schoolListPaging = serializers.serialize('json', schoolListPagingObject)
				variables = {'schoolList': schoolListPaging, 'current': page, 'max': totalPage}
				return HttpResponse(json.dumps(variables, ensure_ascii=False), content_type='application/json')

			totalCount = School.objects.filter(grade=grade).__len__()
			pagingNumbers = paging.paging(int(request.POST['page']), int(request.POST['perPage']), totalCount)
			page = pagingNumbers['current']
			totalPage = pagingNumbers['totalPage']
			startPos = pagingNumbers['startPos']
			endPos = pagingNumbers['endPos']
			schoolListPagingObject = School.objects.filter(grade=grade)[startPos:endPos]
			schoolListPaging = serializers.serialize('json', schoolListPagingObject)
			variables = {'schoolList': schoolListPaging, 'current': page, 'max': totalPage}
			return HttpResponse(json.dumps(variables, ensure_ascii=False), content_type='application/json')


		else:

			if sido.__len__() > 0:

				if gu.__len__() > 0:

					totalCount = School.objects.filter(sido=sido, gu=gu).__len__()
					pagingNumbers = paging.paging(int(request.POST['page']), int(request.POST['perPage']), totalCount)
					page = pagingNumbers['current']
					totalPage = pagingNumbers['totalPage']
					startPos = pagingNumbers['startPos']
					endPos = pagingNumbers['endPos']
					schoolListPagingObject = School.objects.filter(sido=sido, gu=gu)[startPos:endPos]
					schoolListPaging = serializers.serialize('json', schoolListPagingObject)
					variables = {'schoolList': schoolListPaging, 'current': page, 'max': totalPage}
					return HttpResponse(json.dumps(variables, ensure_ascii=False), content_type='application/json')

				totalCount = School.objects.filter(sido=sido).__len__()
				pagingNumbers = paging.paging(int(request.POST['page']), int(request.POST['perPage']), totalCount)
				page = pagingNumbers['current']
				totalPage = pagingNumbers['totalPage']
				startPos = pagingNumbers['startPos']
				endPos = pagingNumbers['endPos']
				schoolListPagingObject = School.objects.filter(sido=sido)[startPos:endPos]
				schoolListPaging = serializers.serialize('json', schoolListPagingObject)
				variables = {'schoolList': schoolListPaging, 'current': page, 'max': totalPage}
				return HttpResponse(json.dumps(variables, ensure_ascii=False), content_type='application/json')

			totalCount = School.objects.all().__len__()
			pagingNumbers = paging.paging(int(request.POST['page']), int(request.POST['perPage']), totalCount)
			page = pagingNumbers['current']
			totalPage = pagingNumbers['totalPage']
			startPos = pagingNumbers['startPos']
			endPos = pagingNumbers['endPos']
			schoolListPagingObject = School.objects.all()[startPos:endPos]
			schoolListPaging = serializers.serialize('json', schoolListPagingObject)
			variables = {'schoolList': schoolListPaging, 'current': page, 'max': totalPage}
			return HttpResponse(json.dumps(variables, ensure_ascii=False), content_type='application/json')

		# made by pj
		# totalCount = School.objects.all().__len__()
		# pagingNumbers = paging.paging(int(request.POST['page']), int(request.POST['perPage']), totalCount)
		#
		# page = pagingNumbers['current']
		# totalPage = pagingNumbers['totalPage']
		# startPos = pagingNumbers['startPos']
		# endPos = pagingNumbers['endPos']
		#
		# schoolListPagingObject = School.objects.all().order_by('id')[startPos:endPos]
		# schoolListPaging = serializers.serialize('json', schoolListPagingObject)
		# variables = {'schoolList':schoolListPaging, 'current':page, 'max':totalPage}
		# return HttpResponse(json.dumps(variables, ensure_ascii=False), content_type='application/json')

	else:
		variables = {'error': NOT_LOGIN_MSG}
		return render_to_response('pages/errorPage.html', RequestContext(request, variables))

# 대리점 상세보기
def detailAgencyPage(request):
	if request.user.is_authenticated():
		loginUser = request.session['user']
		loginUserinformation = request.session['userinformation']
		agencyId = request.POST['id']
		agency = Agency.objects.get(id=agencyId)

		variables = {'agency': agency, 'user': loginUser, 'userinfo': loginUserinformation}
		return render_to_response('pages/detailAgency.html', RequestContext(request, variables))
	else:
		variables = {'error': NOT_LOGIN_MSG}
		return render_to_response('pages/errorPage.html', RequestContext(request, variables))

# 추가 할 연계학교 리스트 호출 page
def agencyAddSchoolPage(request):
	if request.user.is_authenticated():
		loginUser = request.session['user']
		loginUserinformation = request.session['userinformation']
		agencyId = request.POST['agencyId']
		agency = Agency.objects.get(id=agencyId)
		variables = {'agencyId': agencyId, 'agencyName': agency.agencyName, 'user': loginUser, 'userinfo': loginUserinformation}

		return render_to_response('pages/agencyAddSchoolPage.html', RequestContext(request, variables))
	else:
		variables = {'error': NOT_LOGIN_MSG}
		return render_to_response('pages/errorPage.html', RequestContext(request, variables))

# 대리점 추가 할 연계학교 리스트 호출 page
def agencyAddSchoolPage(request):
	loginUser = request.session['user']
	loginUserinformation = request.session['userinformation']
	agencyId = request.POST['agencyId']
	agency = Agency.objects.get(id=agencyId)
	variables = {'agencyId': agencyId, 'agencyName': agency.agencyName, 'user': loginUser,
				 'userinfo': loginUserinformation}

	return render_to_response('pages/agencyAddSchoolPage.html', RequestContext(request, variables))


# 추가 할 연계학교 리스트 보기
def agencyAddSchoolList(request):

	page = request.POST['page']
	agencyId = request.POST['agencyId']

	try:
		grade = int(request.POST['grade'])
	except KeyError:
		grade = 0
	try:
		sido = request.POST['sido']
	except KeyError:
		sido = ''
	try:
		gu = request.POST['gu']
	except KeyError:
		gu = ''

	page = int(page)
	perPage = 13
	startPos = (page - 1) * perPage
	endPos = startPos + perPage

	try:
		schoolName = request.POST['schoolName']
	except KeyError:
		schoolName = ''
	if schoolName.__len__() > 0:
		totalCount = School.objects.filter(schoolName__contains=schoolName).__len__()
		schoolListObject = School.objects.filter(schoolName__contains=schoolName).order_by('schoolName')[startPos:endPos]
		totalPage = totalCount / perPage
		if (totalCount % perPage) > 0:
			totalPage = totalPage + 1
		if totalPage < page:
			page = totalPage

		schoolList = []
		for school in schoolListObject:
			if str(school.agencyId) == 'None':
				addedAgency = ''
			else:
				addedAgency = str(school.agencyId)
			schoolList.append({
				'schoolId': school.id,
				'sido': school.sido,
				'gu': school.gu,
				'schoolName': school.schoolName,
				'agencyName': addedAgency,
			})
		variables = {'schoolList': schoolList, 'current': page, 'max': totalPage, 'agencyId': agencyId}
		return HttpResponse(json.dumps(variables, indent=4, ensure_ascii=False, encoding='utf-8'))

	if grade > 0:
		totalCount = School.objects.filter(grade=grade).__len__()
		schoolListObject = School.objects.filter(grade=grade).order_by('schoolName')[startPos:endPos]
		if sido.__len__() > 0:
			totalCount = School.objects.filter(grade=grade, sido=sido).__len__()
			schoolListObject = School.objects.filter(grade=grade, sido=sido).order_by('schoolName')[startPos:endPos]
			if gu.__len__() > 0:
				totalCount = School.objects.filter(grade=grade, sido=sido, gu=gu).__len__()
				schoolListObject = School.objects.filter(grade=grade, sido=sido, gu=gu).order_by('schoolName')[startPos:endPos]


	else:
		totalCount = School.objects.all().__len__()
		schoolListObject = School.objects.all().order_by('schoolName')[startPos:endPos]
		if sido.__len__() > 0:
			totalCount = School.objects.filter(sido=sido).__len__()
			schoolListObject = School.objects.filter(sido=sido).order_by('schoolName')[startPos:endPos]
			if gu.__len__() > 0:
				totalCount = School.objects.filter(sido=sido, gu=gu).__len__()
				schoolListObject = School.objects.filter(sido=sido, gu=gu).order_by('schoolName')[startPos:endPos]

	totalPage = totalCount / perPage
	if (totalCount % perPage) > 0:
		totalPage = totalPage + 1
	if totalPage < page:
		page = totalPage

	schoolList = []
	for school in schoolListObject:
		if str(school.agencyId) == 'None':
			addedAgency = ''
		else:
			addedAgency = str(school.agencyId)
		schoolList.append({
			'schoolId': school.id,
			'sido': school.sido,
			'gu': school.gu,
			'schoolName': school.schoolName,
			'agencyName': addedAgency,
		})
	variables = {'schoolList': schoolList, 'current': page, 'max': totalPage, 'agencyId': agencyId}
	return HttpResponse(json.dumps(variables, indent=4, ensure_ascii=False, encoding='utf-8'))

# 연계학교 등록기능
def agencyAddSchool(request):
	agencyId = request.POST['agencyId']
	checkedSchoolList = request.POST['checkedSchoolList']
	schoolIdList = checkedSchoolList.split(",")

	agencyIdObj = Agency.objects.get(id=agencyId)
	for schoolId in schoolIdList:
		schoolObj = School.objects.get(id=schoolId)
		agencyIdObj.school_set.add(schoolObj)

	variables = {'agencyId': agencyId}
	return HttpResponse(json.dumps(variables, indent=4, ensure_ascii=False, encoding='utf-8'))

# 메니저 연계학교 리스트 호출 page
def agencyLinkedSchoolPage(request):
	if request.user.is_authenticated():
		loginUser = request.session['user']
		loginUserinformation = request.session['userinformation']
		agencyId = request.POST['agencyId']
		agency = Agency.objects.get(id=agencyId)
		variables = {'agencyId': agencyId, 'agencyName': agency.agencyName, 'user': loginUser, 'userinfo': loginUserinformation}

		return render_to_response('pages/agencyLinkedSchoolPage.html', RequestContext(request, variables))
	else:
		variables = {'error': NOT_LOGIN_MSG}
		return render_to_response('pages/errorPage.html', RequestContext(request, variables))

	# 연계학교 리스트 호출 page
def linkedSchoolPage(request):
	loginUser = request.session['user']
	loginUserinformation = request.session['userinformation']
	agencyList = Agency.objects.get(agencyName=loginUserinformation.name)
	agencyId = agencyList.id
	agency = Agency.objects.get(id=agencyId)
	variables = {'agencyId': agencyId, 'agencyName': agency.agencyName, 'user': loginUser, 'userinfo': loginUserinformation}

	return render_to_response('pages/agencyLinkedSchoolPage.html', RequestContext(request, variables))

# 연계학교 리스트
def agencyLinkedSchoolList (request):
	if request.method == 'POST':
		try:
			agencyId = request.POST['agencyId']
		except KeyError:
			print 'Where is my agencyId?'

	agencyObj = Agency.objects.get(id=agencyId)
	# agencyLinkedSchoolListObj = agencyObj.school_set.all()

	page = int(request.POST['page'])
	perPage = 13

	try:
		totalCount = agencyObj.school_set.all().__len__()
		totalPage = totalCount / perPage
		if (totalCount % perPage) > 0:
			totalPage = totalPage + 1
		if totalPage < page:
			page = totalPage
		startPos = (page - 1) * perPage
		endPos = startPos + perPage

		schoolList = []
		schoolListObject = agencyObj.school_set.all().order_by('-id')[startPos:endPos]

		for school in schoolListObject:
			schoolList.append({
				'schoolId': school.id,
				'sido': school.sido,
				'gu': school.gu,
				'schoolName': school.schoolName,
			})
		variables = {'schoolList': schoolList, 'current': page, 'max': totalPage, 'agencyId': agencyId}
		return HttpResponse(json.dumps(variables, indent=4, ensure_ascii=False, encoding='utf-8'))
	except :
		raise


# 연계학교 삭제기능
def agencyDelSchool(request):
	agencyId = request.POST['agencyId']
	checkedSchoolList = request.POST['checkedSchoolList']
	schoolIdList = checkedSchoolList.split(",")

	agencyIdObj = Agency.objects.get(id=agencyId)
	for schoolId in schoolIdList:
		schoolObj = School.objects.get(id=schoolId)
		agencyIdObj.school_set.remove(schoolObj)

	variables = {'msg': '연계학교 목록에서 삭제되었습니다.', 'agencyId': agencyId}
	return HttpResponse(json.dumps(variables, indent=4, ensure_ascii=False, encoding='utf-8'))


# 시, 도 찾기
def getSidoList(request):
	sidoList = []
	allSchoolListObject = School.objects.all()
	for school in allSchoolListObject:
		sidoList.append(school.sido)
	sidoList = list(set(sidoList))
	sidoList.sort()
	variables = {'sidoList': sidoList}
	return HttpResponse(json.dumps(variables, indent=4, ensure_ascii=False, encoding='utf-8'))

# 시, 군, 구 찾기
def getGuList(request):
	sido = request.POST['sido']

	guList = []
	sidoSchoolListObject = School.objects.filter(sido=sido)
	for school in sidoSchoolListObject:
		guList.append(school.gu)
	guList = list(set(guList))
	guList.sort()
	variables = {'guList': guList}
	return HttpResponse(json.dumps(variables, indent=4, ensure_ascii=False, encoding='utf-8'))

# 학교정보 상세보기
def manageSchoolDetail(request):
	if request.user.is_authenticated():
		loginUser = request.session['user']
		loginUserinformation = request.session['userinformation']
		schoolId = request.POST['schoolId']
		school = School.objects.get(id=schoolId)
		try:
			consult = ConsultBoard.objects.get(schoolId_id=schoolId).content
		except:
			consult = '상담 내용이 없습니다.'
		agencys = Agency.objects.all()
		agency = []
		if school.agencyId_id > 0:
			agency = Agency.objects.get(id=school.agencyId_id)
		variables = {'schoolId': schoolId, 'school': school, 'agencys': agencys, 'consult': consult, 'user': loginUser, 'userinfo': loginUserinformation}

		return render_to_response('pages/detailManageSchool.html', RequestContext(request, variables))
	else:
		variables = {'error': NOT_LOGIN_MSG}
		return render_to_response('pages/errorPage.html', RequestContext(request, variables))

# 학교정보 수정
def manageSchoolUpdate(request):
	if request.method == 'POST':
		schoolId = request.POST['schoolId']
		schoolName = request.POST['schoolName']
		gender = request.POST['gender']
		establish = request.POST['establish']
		tel = request.POST['tel']
		fax = request.POST['fax']
		url = request.POST['url']
		address = request.POST['address']
		zip_code = request.POST['zip_code']
		agency = request.POST['agency']
		consultContent = request.POST['consult']

		school = School.objects.get(id=schoolId)
		school.schoolName = schoolName
		school.gender = gender
		school.establish = establish
		school.tel = tel
		school.fax = fax
		school.url = url
		school.address = address
		school.zip_code = zip_code
		if int(agency) > 0:
			school.agencyId_id = agency
		else:
			school.agencyId = None
		school.save()

		agencys = Agency.objects.all()

		try:
			consult = ConsultBoard.objects.get(schoolId_id=schoolId)
			consult.content = consultContent
			consult.save()
		except:
			nowDate = datetime.today()
			consult = ConsultBoard.objects.create(schoolId_id=schoolId, content=consultContent, date=nowDate)



		variables = {'schoolId': schoolId, 'school': school, 'agencys': agencys, 'consult': consult.content}
		return render_to_response('pages/detailManageSchool.html', RequestContext(request, variables))

@csrf_exempt
def userNameSearch(request):
	try:
		name = request.POST['searchText']
		agencyId = request.POST['agencyId']
		traderUserList = User.objects.filter(userinformation__name__contains=name, userinformation__userAuthority=3).order_by('id')
		agencyObject = Agency.objects.get(id = agencyId)
		traderUser = []
		for trader in traderUserList:
			traderUser.append({
				'userName':trader.userinformation.name,
				'userId':trader.id
			})

		userAgencyList = []
		for user in agencyObject.users.all():
			userAgencyList.append(user.id)

		variables = {'userList':traderUser, 'linkedUserIdList':userAgencyList}
		return HttpResponse(json.dumps(variables, indent=4, ensure_ascii=False, encoding='utf-8'))
	except:
		pass