# -*- coding:utf-8 -*-
from django.template import RequestContext
from django.shortcuts import render_to_response, get_object_or_404
from django.http import HttpResponseRedirect, HttpResponse, Http404
from django.views.decorators.csrf import csrf_exempt
from django.contrib.auth import authenticate, login, logout
from django.contrib.auth.models import User, Permission
from django.core import serializers
from users.models import School
from product.models import *
import json
from django.core.urlresolvers import reverse

NOT_LOGIN_MSG = '로그인 해 주세요'

def viewer(request):
	if request.user.is_authenticated():
		user = request.session['user']
		userinformation = request.session['userinformation']
		return render_to_response('published/170522_pages/main_new.html', {'user':user, 'userinfo':userinformation})
	return render_to_response('published/login.html')

# def manageDesign(request):
# 	if request.user.is_authenticated():
# 		user = request.session['user']
# 		userinformation = request.session['userinformation']
# 		if(userinformation.userAuthority > 2):
# 			return render_to_response('published/main.html', {'user': user, 'userinfo': userinformation, 'permissionError': '권한이없습니다 관리자에게 문의해보세요'})
# 		return render_to_response('pages/managedesign.html', {'user': user, 'userinfo': userinformation})
# 	else:
# 		variables = {'error': NOT_LOGIN_MSG}
# 		return render_to_response('pages/errorPage.html', RequestContext(request, variables))

def manageDesignSchool(request):
    if request.user.is_authenticated():
        user = request.session['user']
        userinformation = request.session['userinformation']
        if (userinformation.userAuthority > 2):
            return render_to_response('published/main.html', {'user': user, 'userinfo': userinformation,
                                                              'permissionError': '권한이없습니다 관리자에게 문의해보세요'})
        return render_to_response('pages/managedesign_school.html', {'user': user, 'userinfo': userinformation})
    else:
        variables = {'error': NOT_LOGIN_MSG}
        return render_to_response('pages/errorPage.html', RequestContext(request, variables))

def manageDesignSearch(request):
    if request.user.is_authenticated():
        user = request.session['user']
        userinformation = request.session['userinformation']
        if (userinformation.userAuthority > 2):
            return render_to_response('published/main.html', {'user': user, 'userinfo': userinformation,
                                                              'permissionError': '권한이없습니다 관리자에게 문의해보세요'})
        return render_to_response('pages/managedesign_search.html', {'user': user, 'userinfo': userinformation})
    else:
        variables = {'error': NOT_LOGIN_MSG}
        return render_to_response('pages/errorPage.html', RequestContext(request, variables))

def manageFabric(request):
	if request.user.is_authenticated():
		user = request.session['user']
		userinformation = request.session['userinformation']
		if(userinformation.userAuthority > 2):
			return render_to_response('published/main.html', {'user': user, 'userinfo': userinformation, 'permissionError': '권한이없습니다 관리자에게 문의해보세요'})
		return render_to_response('pages/managefabric.html', {'user': user, 'userinfo': userinformation})
	else:
		variables = {'error': NOT_LOGIN_MSG}
		return render_to_response('pages/errorPage.html', RequestContext(request, variables))

def manageSchool(request):
	if request.user.is_authenticated():
		user = request.session['user']
		userinformation = request.session['userinformation']
		if(userinformation.userAuthority > 1):
			return render_to_response('published/main.html', {'user': user, 'userinfo': userinformation, 'permissionError': '권한이없습니다 관리자에게 문의해보세요'})
		return render_to_response('pages/manageschool.html', {'user': user, 'userinfo': userinformation})
	else:
		variables = {'error': NOT_LOGIN_MSG}
		return render_to_response('pages/errorPage.html', RequestContext(request, variables))

def manageUser(request):
	if request.user.is_authenticated():
		user = request.session['user']
		userinformation = request.session['userinformation']
		if(userinformation.userAuthority > 1):
			return render_to_response('published/main.html', {'user': user, 'userinfo': userinformation, 'permissionError': '권한이없습니다 관리자에게 문의해보세요'})
		return render_to_response('pages/manageuser.html', {'user': user, 'userinfo': userinformation})
	else:
		variables = {'error': NOT_LOGIN_MSG}
		return render_to_response('pages/errorPage.html', RequestContext(request, variables))

def design_offer_list(request):
	if request.user.is_authenticated():
		user = request.session['user']
		userinformation = request.session['userinformation']
		if(userinformation.userAuthority > 3):
			return render_to_response('published/main.html', {'user': user, 'userinfo': userinformation, 'permissionError': '권한이없습니다 관리자에게 문의해보세요'})

		try:
			mainLinkCategory = int(request.POST['mainLinkCategory'])
		except:
			mainLinkCategory = 0

		try:
			season = request.POST['season']
		except:
			season = ""

		return render_to_response('published/design_offer_list.html', {'user': user, 'userinfo': userinformation, 'mainLinkCategory': mainLinkCategory, 'season': season})
	else:
		variables = {'error': NOT_LOGIN_MSG}
		return render_to_response('pages/errorPage.html', RequestContext(request, variables))


def design_offer_view(request):
	if request.user.is_authenticated():
		user = request.session['user']
		userinformation = request.session['userinformation']
		if(userinformation.userAuthority > 3):
			return render_to_response('published/main.html', {'user': user, 'userinfo': userinformation, 'permissionError': '권한이없습니다 관리자에게 문의해보세요'})
		return render_to_response('published/design_offer_view.html', {'user': user, 'userinfo': userinformation})
	else:
		variables = {'error': NOT_LOGIN_MSG}
		return render_to_response('pages/errorPage.html', RequestContext(request, variables))


def design_current_list(request):
	if request.user.is_authenticated():
		user = request.session['user']
		userinformation = request.session['userinformation']
		if (userinformation.userAuthority > 3):
			return render_to_response('published/main.html', {'user': user, 'userinfo': userinformation, 'permissionError': '권한이없습니다 관리자에게 문의해보세요'})

		return render_to_response('published/design_current_list.html', {'user': user, 'userinfo': userinformation})
	else:
		variables = {'error': NOT_LOGIN_MSG}
		return render_to_response('pages/errorPage.html', RequestContext(request, variables))


def design_current_view(request):
	if request.user.is_authenticated():
		user = request.session['user']
		userinformation = request.session['userinformation']
		if (userinformation.userAuthority > 3):
			return render_to_response('published/main.html', {'user': user, 'userinfo': userinformation, 'permissionError': '권한이없습니다 관리자에게 문의해보세요'})
		return render_to_response('published/design_current_view.html', {'user': user, 'userinfo': userinformation})
	else:
		variables = {'error': NOT_LOGIN_MSG}
		return render_to_response('pages/errorPage.html', RequestContext(request, variables))


def mypage_school(request):
	if request.user.is_authenticated():
		user = request.session['user']
		userinformation = request.session['userinformation']
		if (userinformation.userAuthority > 3):
			return render_to_response('published/main.html', {'user': user, 'userinfo': userinformation, 'permissionError': '권한이없습니다 관리자에게 문의해보세요'})
		return render_to_response('published/mypage_school.html', {'user': user, 'userinfo': userinformation})
	else:
		variables = {'error': NOT_LOGIN_MSG}
		return render_to_response('pages/errorPage.html', RequestContext(request, variables))


# def mypage_consult_list(request):
# 	if request.user.is_authenticated():
# 		user = request.session['user']
# 		userinformation = request.session['userinformation']
# 		return render_to_response('published/mypage_consult_list.html', {'user': user, 'userinfo': userinformation})
# 	else:
# 		variables = {'error': NOT_LOGIN_MSG}
# 		return render_to_response('pages/errorPage.html', RequestContext(request, variables))


# def mypage_school_eliteoffer(request):
# 	if request.user.is_authenticated():
# 		user = request.session['user']
# 		userinformation = request.session['userinformation']
# 		if (userinformation.userAuthority > 3):
# 			return render_to_response('published/main.html', {'user': user, 'userinfo': userinformation, 'permissionError': '권한이없습니다 관리자에게 문의해보세요'})
# 		return render_to_response('published/mypage_school_eliteoffer.html', {'user': user, 'userinfo': userinformation})
# 	else:
# 		variables = {'error': NOT_LOGIN_MSG}
# 		return render_to_response('pages/errorPage.html', RequestContext(request, variables))


def mypage_school_favorite(request):
	if request.user.is_authenticated():
		user = request.session['user']
		userinformation = request.session['userinformation']
		if (userinformation.userAuthority > 3):
			return render_to_response('published/main.html', {'user': user, 'userinfo': userinformation, 'permissionError': '권한이없습니다 관리자에게 문의해보세요'})
		return render_to_response('published/mypage_school_favorite.html', {'user': user, 'userinfo': userinformation})
	else:
		variables = {'error': NOT_LOGIN_MSG}
		return render_to_response('pages/errorPage.html', RequestContext(request, variables))


def mypage_school_selected(request):
	if request.user.is_authenticated():
		user = request.session['user']
		userinformation = request.session['userinformation']
		if (userinformation.userAuthority > 3):
			return render_to_response('published/main.html', {'user': user, 'userinfo': userinformation, 'permissionError': '권한이없습니다 관리자에게 문의해보세요'})
		return render_to_response('published/mypage_school_selected.html', {'user': user, 'userinfo': userinformation})
	else:
		variables = {'error': NOT_LOGIN_MSG}
		return render_to_response('pages/errorPage.html', RequestContext(request, variables))


def brand_page(request):
	if request.user.is_authenticated():
		user = request.session['user']
		userinformation = request.session['userinformation']
		return render_to_response('published/170522_pages/brand.html', {'user':user, 'userinfo':userinformation})
	return render_to_response('published/login.html')


def design_suggest(request):
	if request.user.is_authenticated():
		user = request.session['user']
		userinformation = request.session['userinformation']
		return render_to_response('published/170522_pages/design_suggest.html', {'user':user, 'userinfo':userinformation})
	return render_to_response('published/login.html')


def mypage_school_new(request):
	if request.user.is_authenticated():
		user = request.session['user']
		userinformation = request.session['userinformation']
		return render_to_response('published/170522_pages/mypage_school_new.html', {'user':user, 'userinfo':userinformation})
	return render_to_response('published/login.html')


# 인기디자인 클릭시 화면
# 상단부분은 django template 변수를활용
# 하단부분은 /media/js/board/elite.popularDesignList.js 에서 비동기 처리
def popular_design(request):
	if request.user.is_authenticated():
		user = request.session['user']
		userinformation = request.session['userinformation']

		slider_design_list=[]

		# 중학교
		try:
			middle_boy_summer_design = Design.objects.filter(selected_design__grade__contains='1', coordi__gender__contains='B', coordi__season__contains='S').distinct().order_by('-selectedCount')[0]
		except:
			middle_boy_summer_design = None
		try:
			middle_boy_casual_design = Design.objects.filter(selected_design__grade__contains='1', coordi__gender__contains='B', coordi__season__contains='A').distinct().order_by('-selectedCount')[0]
		except:
			middle_boy_casual_design = None
		try:
			middle_boy_winter_design = Design.objects.filter(selected_design__grade__contains='1', coordi__gender__contains='B', coordi__season__contains='W').distinct().order_by('-selectedCount')[0]
		except:
			middle_boy_winter_design = None
		try:
			middle_girl_summer_design = Design.objects.filter(selected_design__grade__contains='1', coordi__gender__contains='G', coordi__season__contains='S').distinct().order_by('-selectedCount')[0]
		except:
			middle_girl_summer_design = None
		try:
			middle_girl_casual_design = Design.objects.filter(selected_design__grade__contains='1', coordi__gender__contains='G', coordi__season__contains='A').distinct().order_by('-selectedCount')[0]
		except:
			middle_girl_casual_design = None
		try:
			middle_girl_winter_design = Design.objects.filter(selected_design__grade__contains='1', coordi__gender__contains='G', coordi__season__contains='W').distinct().order_by('-selectedCount')[0]
		except:
			middle_girl_winter_design = None

		# 고등학교
		try:
			high_boy_summer_design = Design.objects.filter(selected_design__grade__contains='2', coordi__gender__contains='B', coordi__season__contains='S').distinct().order_by('-selectedCount')[0]
		except:
			high_boy_summer_design = None
		try:
			high_boy_casual_design = Design.objects.filter(selected_design__grade__contains='2', coordi__gender__contains='B', coordi__season__contains='A').distinct().order_by('-selectedCount')[0]
		except:
			high_boy_casual_design = None
		try:
			high_boy_winter_design = Design.objects.filter(selected_design__grade__contains='2', coordi__gender__contains='B', coordi__season__contains='W').distinct().order_by('-selectedCount')[0]
		except:
			high_boy_winter_design = None
		try:
			high_girl_summer_design = Design.objects.filter(selected_design__grade__contains='2', coordi__gender__contains='G', coordi__season__contains='S').distinct().order_by('-selectedCount')[0]
		except:
			high_girl_summer_design = None
		try:
			high_girl_casual_design = Design.objects.filter(selected_design__grade__contains='2', coordi__gender__contains='G', coordi__season__contains='A').distinct().order_by('-selectedCount')[0]
		except:
			high_girl_casual_design = None
		try:
			high_girl_winter_design = Design.objects.filter(selected_design__grade__contains='2', coordi__gender__contains='G', coordi__season__contains='W').distinct().order_by('-selectedCount')[0]
		except:
			high_girl_winter_design = None

        try:
            slider_design_list.append(Design.objects.filter(selected_design__grade__isnull=False, coordi__gender__contains='B', coordi__season__contains='S').distinct().order_by('-selectedCount')[0])
        except:
            slider_design_list.append(None)
        try:
            slider_design_list.append(Design.objects.filter(selected_design__grade__isnull=False, coordi__gender__contains='B', coordi__season__contains='A').distinct().order_by('-selectedCount')[0])
        except:
            slider_design_list.append(None)
        try:
            slider_design_list.append(Design.objects.filter(selected_design__grade__isnull=False, coordi__gender__contains='B', coordi__season__contains='W').distinct().order_by('-selectedCount')[0])
        except:
            slider_design_list.append(None)
        try:
            slider_design_list.append(Design.objects.filter(selected_design__grade__isnull=False, coordi__gender__contains='G', coordi__season__contains='S').distinct().order_by('-selectedCount')[0])
        except:
            slider_design_list.append(None)
        try:
            slider_design_list.append(Design.objects.filter(selected_design__grade__isnull=False, coordi__gender__contains='G', coordi__season__contains='A').distinct().order_by('-selectedCount')[0])
        except:
            slider_design_list.append(None)
        try:
            slider_design_list.append(Design.objects.filter(selected_design__grade__isnull=False, coordi__gender__contains='G', coordi__season__contains='W').distinct().order_by('-selectedCount')[0])
        except:
            slider_design_list.append(None)

        variables = {
			'user': user,
			'userinfo': userinformation,
			'middle_boy_summer_design': middle_boy_summer_design,
			'middle_boy_casual_design': middle_boy_casual_design,
			'middle_boy_winter_design': middle_boy_winter_design,
			'middle_girl_summer_design': middle_girl_summer_design,
			'middle_girl_casual_design': middle_girl_casual_design,
			'middle_girl_winter_design': middle_girl_winter_design,
			'high_boy_summer_design': high_boy_summer_design,
			'high_boy_casual_design': high_boy_casual_design,
			'high_boy_winter_design': high_boy_winter_design,
			'high_girl_summer_design': high_girl_summer_design,
			'high_girl_casual_design': high_girl_casual_design,
			'high_girl_winter_design': high_girl_winter_design,
			'slider_design_list': slider_design_list,
		}
        return render_to_response('published/170522_pages/popular_design.html', variables)
	return render_to_response('published/login.html')