# -*- coding: utf-8 -*-
from __future__ import absolute_import

from django.views.generic import ListView, UpdateView
from django.contrib.auth.models import User
from django.template import RequestContext
from django.shortcuts import render_to_response
from django.shortcuts  import redirect
from django.core.urlresolvers import reverse_lazy
from django.contrib.auth import authenticate
from django.contrib.auth.decorators import login_required
from core.views import AdminRequiredMixin, page_calc
from company.models import Company


class UserLV(AdminRequiredMixin, ListView):
	template_name = 'accounts/custom_admin/user_manage.html'
	model = User
	paginate_by = 12

	# context_object_name 디폴트는 'object_list'
	# context_object_name = 'design_data_list'

	# 조건 걸어서 주고 싶을때
	def get_queryset(self):
		return User.objects.order_by('-id')

	def get_context_data(self, **kwargs):
		context = super(UserLV, self).get_context_data(**kwargs)
		paginator = context['paginator']
		page = self.request.GET.get('page')

		context['page_range'] = page_calc(paginator, page)
		context['first_page'] = 1
		context['last_page'] = paginator.num_pages
		context['selectedCategory'] = 'user'
		context['selectedSubCategory'] = 'user'
		return context
	
class UserSearchList(AdminRequiredMixin, ListView):
	template_name = 'accounts/custom_admin/user_manage.html'
	model = User
	paginate_by = 12
	
	def get_queryset(self):
		try:
			search_word = self.request.GET.get('search-word')
		except:
			search_word = ''
		if (search_word != '' and search_word != None):
			object_list = self.model.objects.filter(userprofile__user_name__icontains=search_word)
		else:
			object_list = []
		return object_list
	
	def get_context_data(self, **kwargs):
		context = super(UserSearchList, self).get_context_data(**kwargs)
		paginator = context['paginator']
		page = self.request.GET.get('page')
		context['search_paging'] = True
		context['search_word'] = self.request.GET.get('search-word')
		context['page_range'] = page_calc(paginator, page)
		context['first_page'] = 1
		context['last_page'] = paginator.num_pages
		context['selectedCategory'] = 'user'
		context['selectedSubCategory'] = 'user'
		return context
	
@login_required()
def UserModifyPage(request):
	if request.user.is_authenticated() and request.user.is_superuser:
		pk = request.GET['user-pk']
		modifiedUser = User.objects.get(id = pk)
		companyList = Company.objects.all()
		variables = {'modifiedUser': modifiedUser, 'companyList': companyList, 'selectedCategory': 'user',
		             'selectedSubCategory': 'user'}
		return render_to_response('accounts/custom_admin/user_manage_info.html', RequestContext(request, variables))
	
@login_required()
def UserModify(request):
	if request.user.is_authenticated() and request.user.is_superuser:
		pk = request.POST['user-pk']
		email = request.POST['user-email']
		password = request.POST['user-password'] if len(request.POST['user-password']) > 0 else None
		name = request.POST['user-first_name']
		mobile = request.POST['profile-mobile']
		company = request.POST['profile-company']
		
		user = User.objects.get(id=pk)
		if password != None:
			user.set_password(password)
		else:
			pass
		user.email = email
		user.first_name = name
		user.userprofile.user_name = name
		user.userprofile.mobile = mobile
		user.userprofile.company_id = company
		user.save()
		user.userprofile.save()
		modifiedUser = user
		companyList = Company.objects.all()
		variables = {'modifiedUser': modifiedUser, 'companyList': companyList, 'success': '수정완료',
		             'selectedCategory': 'user', 'selectedSubCategory': 'user'}
		return render_to_response('accounts/custom_admin/user_manage_info.html', RequestContext(request, variables))

@login_required()
def UserDelete(request):
	if request.user.is_authenticated() and request.user.is_superuser:
		pk = request.GET['user-pk']
		user = User.objects.get(id=pk)

		user.userprofile.delete()
		user.delete()

		return redirect(reverse_lazy('accounts:custom_admin_list'))