# -*- coding: utf-8 -*-
from __future__ import unicode_literals

from django.forms import ModelForm
from django.contrib.auth.models import User
from django.contrib.auth.forms import UserCreationForm

from betterforms.multiform import MultiModelForm
from collections import OrderedDict

from accounts.models import UserProfile


class SignupForm(UserCreationForm):
    class Meta:
        model = User
        fields = ("username", "email", "password1", "password2", "first_name")

    def __init__(self, *args, **kwargs):
        super(SignupForm, self).__init__(*args, **kwargs)
        self.fields['username'].label = "아이디"
        self.fields['username'].widget.attrs.update({'placeholder' : '30자 이내의 영문, 숫자, 특문만 가능합니다'})
        self.fields['password2'].widget.attrs.update({'placeholder' : '비밀번호의 안전한 등록을 위해 한 번 더 입력 해 주세요'})
        for fieldName in ['username', 'password1', 'password2']:
            self.fields[fieldName].help_text = None


class ProfileForm(ModelForm):
    class Meta:
        model = UserProfile
        exclude = ('user', 'user_identity', 'user_name')


# 기본 User의 폼과 확장한 Profile의 폼을 같이 보여준다
class AddUserMultiForm(MultiModelForm):
    # form_classes = {
    #     'user':SignupForm,
    #     'profile':ProfileForm,
    # }
    # OrderedDict는 form의 순서를 결정한다
    form_classes = OrderedDict((
        ('user', SignupForm),
        ('profile', ProfileForm),
    ))


class UserUpdateForm(ModelForm):
    class Meta:
        model = User
        fields = ("email", "first_name")

    def __init__(self, *args, **kwargs):
        super(UserUpdateForm, self).__init__(*args, **kwargs)


class ProfileUpdateForm(ModelForm):
    class Meta:
        model = UserProfile
        exclude = ('user', 'user_identity', 'user_name', 'company')

    def __init__(self, *args, **kwargs):
        super(ProfileUpdateForm, self).__init__(*args, **kwargs)
        self.fields['mobile'].label = "mobile"

