# -*- coding: utf-8 -*-
from __future__ import unicode_literals

from django.db import models
from django.contrib.auth.models import User
from django.db.models.signals import post_save

from core.models import TimeStampedModel
from company.models import Company


# User가 생성될때 자동으로 UserProfile도 같이 생성한다
def create_user_profile(sender, instance, created, **kwargs):
    if created:
        UserProfile.objects.create(user=instance, user_identity=instance.username, user_name=instance.first_name)

post_save.connect(create_user_profile, sender=User)


class UserProfile(models.Model):
    user = models.OneToOneField(User, on_delete=models.CASCADE)
    user_identity = models.CharField(max_length=100, null=True, blank=True)
    user_name = models.CharField(max_length=100, null=True, blank=True)
    mobile = models.CharField(max_length=100, null=True, blank=True)
    company = models.ForeignKey(Company, on_delete=models.CASCADE, null=True, blank=True)

    class Meta:
        db_table = 'ac_user_profile'

    def __unicode__(self):
        return unicode(self.user_identity)
