# -*- coding: utf-8 -*-
from django.conf.urls import url, include
import django.contrib.auth.views

from accounts.views import UserCreateView, UserCreateDoneTV, UserPasswordChangeDoneTV, AddUserView, loginAjax, UserUpdateView, passwdCheck
from accounts.custom_admin.views import UserLV, UserSearchList, UserModifyPage, UserModify, UserDelete

urlpatterns = [
    url(r'^login/$', django.contrib.auth.views.login, {'template_name': 'accounts/login.html'}, name='login'),
    url(r'^logout/$', django.contrib.auth.views.logout, {'next_page': 'home'}, name='logout'),
    url(r'^password_change/$', django.contrib.auth.views.password_change,
        {'template_name': 'accounts/password_change_form.html', 'post_change_redirect': 'accounts:password_change_done'},
        name='password_change'),
    url(r'^register/$', AddUserView.as_view(), name='register'),
    url(r'^register/done/$', UserCreateDoneTV.as_view(), name='register_done'),
    url(r'^password_change/done/$', UserPasswordChangeDoneTV.as_view(), name='password_change_done'),
    url(r'^loginAjax$', loginAjax),
    url(r'^update/$', UserUpdateView.as_view(), name='update'),
	url(r'^passwd_check/$', passwdCheck),


]

# 관리자 영역
urlpatterns += [
    url(r'^custom_admin/userList$', UserLV.as_view(), name='custom_admin_list'),
	url(r'^custom_admin/searchUser$', UserSearchList.as_view(), name='custom_user_search'),
	url(r'^custom_admin/getUserInfo$', UserModifyPage),
	url(r'^custom_admin/modifyUser$', UserModify, name='user_modify'),
    url(r'^custom_admin/deleteUser$', UserDelete, name='user_delete'),
]