# -*- coding: utf-8 -*-
from __future__ import unicode_literals

from django.forms import ModelForm
from company.models import Company

class AddCompanyForm(ModelForm):
	class Meta:
		model = Company
		fields = ("name", "corporate_number", "ceo", "conditions", "type", "person", "post_code", "address",
		          "detail_address", "tel", "bank", "account", "hp_address", "stamp")
		
	def __init__(self, *args, **kwargs):
		super(AddCompanyForm, self).__init__(*args, **kwargs)
		self.fields['post_code'].widget.attrs.update({'id': 'post_code', 'class': 'postcodify_postcode5'})
		self.fields['address'].widget.attrs.update({'id': 'first_address', 'class': 'postcodify_address'})
		self.fields['stamp'].widget.attrs.update({'id': 'stamp', 'class': 'stampInput'})