# -*- coding: utf-8 -*-
from __future__ import unicode_literals

from django.db import models

from core.models import TimeStampedModel

def stamp_upload_path(instance, filename):
    return '/'.join(['stamp', str(instance.id), filename])

# Create your models here.
class Company(TimeStampedModel):
    name = models.CharField('상호', max_length=100)
    corporate_number = models.CharField('사업자등록번호', max_length=40, null=True, blank=True)
    ceo = models.CharField('대표', max_length=40, null=True, blank=True)
    conditions = models.CharField('업태', max_length=40, null=True, blank=True)
    type = models.CharField('업종', max_length=40, null=True, blank=True)
    person = models.CharField('담당자', max_length=40, null=True, blank=True)
    post_code = models.CharField('우편번호', max_length=40, null=True, blank=True)
    address = models.CharField('주소', max_length=100, null=True, blank=True)
    detail_address = models.CharField('상세주소', max_length=100, null=True, blank=True)
    tel = models.CharField('대표전화', max_length=80, null=True, blank=True)
    account = models.CharField('계좌번호', max_length=40, null=True, blank=True)
    bank = models.CharField('은행명', max_length=20, null=True, blank=True)
    hp_address = models.URLField('홈페이지주소', max_length=200, null=True, blank=True)
    stamp = models.ImageField('도장이미지', upload_to=stamp_upload_path, null=True, blank=True)

    class Meta:
        db_table = 'cp_company'

    def __unicode__(self):
        return unicode(self.name)
