# -*- coding: utf-8 -*-
from __future__ import absolute_import

from django.views.generic import ListView
from django.views.generic.edit import CreateView, DeleteView
from company.models import Company
from company.forms import AddCompanyForm
from django.core.urlresolvers import reverse_lazy
from django.shortcuts import render_to_response
from django.template import RequestContext
from django.contrib.auth import authenticate
from django.contrib.auth.decorators import login_required
from core.views import AdminRequiredMixin, page_calc

class companyLV(AdminRequiredMixin, ListView):
	template_name = 'company/custom_admin/company_manager.html'
	model = Company
	paginate_by = 12
	
	# context_object_name 디폴트는 'object_list'
	# context_object_name = 'design_data_list'
	
	# 조건 걸어서 주고 싶을때
	def get_queryset(self):
		return Company.objects.order_by('-id')
	
	def get_context_data(self, **kwargs):
		context = super(companyLV, self).get_context_data(**kwargs)
		paginator = context['paginator']
		page = self.request.GET.get('page')
		
		context['page_range'] = page_calc(paginator, page)
		context['first_page'] = 1
		context['last_page'] = paginator.num_pages
		context['selectedCategory'] = 'user'
		context['selectedSubCategory'] = 'bender'
		return context

class CompanySearchList(AdminRequiredMixin, ListView):
	template_name = 'company/custom_admin/company_manager.html'
	model = Company
	paginate_by = 12
	
	def get_queryset(self):
		try:
			search_word = self.request.GET.get('search-word')
		except:
			search_word = ''
		if (search_word != '' and search_word != None):
			object_list = self.model.objects.filter(name__icontains=search_word)
		else:
			object_list = []
		return object_list
	
	def get_context_data(self, **kwargs):
		context = super(CompanySearchList, self).get_context_data(**kwargs)
		paginator = context['paginator']
		page = self.request.GET.get('page')

		context['page_range'] = page_calc(paginator, page)
		context['first_page'] = 1
		context['last_page'] = paginator.num_pages
		context['selectedCategory'] = 'user'
		context['selectedSubCategory'] = 'bender'
		return context
	
class AddCompanyView(AdminRequiredMixin, CreateView):
	form_class = AddCompanyForm
	template_name = "company/custom_admin/company_register.html"
	success_url = reverse_lazy('company:companyList')
	
	def get_context_data(self, **kwargs):
		context = super(AddCompanyView, self).get_context_data(**kwargs)
		context['selectedCategory'] = 'user'
		context['selectedSubCategory'] = 'bender'
		return context
	
class CompanyDeleteView(AdminRequiredMixin, DeleteView):
	model = Company
	template_name = "company/custom_admin/company_confirm_delete.html"
	success_url = reverse_lazy('company:companyList')
	
	def get_context_data(self, **kwargs):
		context = super(CompanyDeleteView, self).get_context_data(**kwargs)
		context['selectedCategory'] = 'user'
		context['selectedSubCategory'] = 'bender'
		return context
	
@login_required()
def CompanyModifyPage(request):
	if request.user.is_authenticated() and request.user.is_superuser:
		pk = request.GET['company-pk']
		modifiedCompany = Company.objects.get(id = pk)
		variables = {'modifiedCompany': modifiedCompany, 'selectedCategory': 'user', 'selectedSubCategory': 'bender'}
		return render_to_response('company/custom_admin/company_info.html', RequestContext(request, variables))
	
@login_required()
def CompanyModify(request):
	if request.user.is_authenticated() and request.user.is_superuser:
		pk = request.POST['company-pk']
		name = request.POST['name']
		ceo = request.POST['ceo']
		conditions = request.POST['conditions']
		type = request.POST['type']
		post_code = request.POST['post_code']
		address = request.POST['address']
		detail_address = request.POST['detail_address']
		tell = request.POST['tel']
		bank = request.POST['bank']
		account = request.POST['account']
		hp_address = request.POST['hp_address']
		#stamp = request.FILES['stamp']
		
		company = Company.objects.get(id = pk)
		
		company.name = name
		company.ceo = ceo
		company.conditions = conditions
		company.type = type
		company.post_code = post_code
		company.address = address
		company.detail_address = detail_address
		company.tell = tell
		company.bank = bank
		company.account = account
		company.hp_address = hp_address
		#company.stamp = stamp
		
		if request.FILES.has_key('stamp'):
			stamp = request.FILES['stamp']
			company.stamp = stamp
		
		company.save()
		
		variables = {'modifiedCompany': company, 'success': '수정완료', 'selectedCategory': 'user', 'selectedSubCategory': 'bender'}
		return render_to_response('company/custom_admin/company_info.html', RequestContext(request, variables))