# -*- coding: utf-8 -*-
from __future__ import absolute_import

from django.views.generic import ListView, UpdateView, DeleteView, CreateView
from django.core.urlresolvers import reverse_lazy
from django.shortcuts import redirect

from core.views import AdminRequiredMixin, page_calc
from kindergarten.models import Kindergarten, SmartKindergarten
from kindergarten.forms import SmartKindergartenCreateForm


class KindergartenChangeLV(AdminRequiredMixin, ListView):
	template_name = 'kindergarten/custom_admin/kindergarten_change_list.html'
	model = SmartKindergarten
	paginate_by = 13

	def get_context_data(self, **kwargs):
		context = super(KindergartenChangeLV, self).get_context_data(**kwargs)
		paginator = context['paginator']
		page = self.request.GET.get('page')

		context['page_range'] = page_calc(paginator, page)
		context['first_page'] = 1
		context['last_page'] = paginator.num_pages
		context['selectedCategory'] = 'user'
		context['selectedSubCategory'] = 'kindergarten'
		return context
	
class KindergartenSearchLV(AdminRequiredMixin, ListView):
	template_name = 'kindergarten/custom_admin/kindergarten_change_list.html'
	model = SmartKindergarten
	paginate_by = 13
	
	def get_queryset(self):
		try:
			search_word = self.request.GET.get('search_word')
		except:
			search_word = ''
		if (search_word != '' and search_word != None):
			object_list = self.model.objects.filter(name__icontains = search_word)
		else:
			object_list = []
		return object_list
	
	def get_context_data(self, **kwargs):
		context = super(KindergartenSearchLV, self).get_context_data(**kwargs)
		paginator = context['paginator']
		page = self.request.GET.get('page')
		context['search_paging'] = True
		context['search_word'] = self.request.GET.get('search_word')
		context['page_range'] = page_calc(paginator, page)
		context['first_page'] = 1
		context['last_page'] = paginator.num_pages
		context['selectedCategory'] = 'user'
		context['selectedSubCategory'] = 'kindergarten'
		return context


class KindergartenUpdateView(AdminRequiredMixin, UpdateView):
	template_name = 'kindergarten/custom_admin/kindergarten_update.html'
	model = SmartKindergarten
	fields = ['name', 'address', 'area', 'tel']
	success_url = reverse_lazy('kindergarten:custom_admin_change_list')
	
	def get_context_data(self, **kwargs):
		context = super(KindergartenUpdateView, self).get_context_data(**kwargs)
		context['selectedCategory'] = 'user'
		context['selectedSubCategory'] = 'kindergarten'
		return context


class KindergartenDeleteView(AdminRequiredMixin, DeleteView):
	template_name = 'kindergarten/custom_admin/kindergarten_delete.html'
	model = SmartKindergarten
	success_url = reverse_lazy('kindergarten:custom_admin_change_list')
	
	def get_context_data(self, **kwargs):
		context = super(KindergartenDeleteView, self).get_context_data(**kwargs)
		context['selectedCategory'] = 'user'
		context['selectedSubCategory'] = 'kindergarten'
		return context


class SmartKindergartenCV(AdminRequiredMixin, CreateView):
	template_name = 'kindergarten/custom_admin/smart_kindergarten_create.html'
	form_class = SmartKindergartenCreateForm
	success_url = reverse_lazy('kindergarten:custom_admin_change_list')
	
	def get_context_data(self, **kwargs):
		context = super(SmartKindergartenCV, self).get_context_data(**kwargs)
		context['selectedCategory'] = 'user'
		context['selectedSubCategory'] = 'kindergarten'
		return context