# -*- coding: utf-8 -*-
from __future__ import unicode_literals

from django.forms import ModelForm
from django import forms

from kindergarten.models import Kindergarten, SmartKindergarten


class KindergartenCreateForm(ModelForm):
	class Meta:
		model = Kindergarten
		# fields = '__all__'
		exclude = ('user_profile', 'address', 'smart_kindergarten',)
	
	def __init__(self, *args, **kwargs):
		self.user = kwargs.pop('user')
		super(KindergartenCreateForm, self).__init__(*args, **kwargs)
		
		self.fields['post_code'].widget.attrs['readonly'] = True
		self.fields['first_address'].widget.attrs['readonly'] = True
		# self.fields['detail_address'].widget.attrs['readonly'] = True
		self.fields['post_code'].widget.attrs.update({'id': 'post_code', 'class': 'postcodify_postcode5'})
		self.fields['first_address'].widget.attrs.update({'id': 'first_address', 'class': 'postcodify_address'})
		self.fields['detail_address'].widget.attrs.update({'id': 'detail_address'})
	
	# self.fields['user_profile'].queryset = UserProfile.objects.filter(user=self.user)


class SmartKindergartenSearchForm(forms.Form):
	search_word = forms.CharField(label='유치원 검색')


class SmartKindergartenCreateForm(ModelForm):
	class Meta:
		model = SmartKindergarten
		fields = '__all__'
