# -*- coding: utf-8 -*-
from __future__ import unicode_literals

from django.db import models

from core.models import TimeStampedModel
from accounts.models import UserProfile


# Create your models here.
class SmartKindergarten(models.Model):
    name = models.CharField('유치원명', max_length=100)
    address = models.CharField('주소', max_length=100, null=True, blank=True)
    area = models.CharField('상권', max_length=100, null=True, blank=True)
    tel = models.CharField('전화번호', max_length=100, null=True, blank=True)

    class Meta:
        db_table = 'kg_smart_kindergarten'

    def __unicode__(self):
        return unicode(self.name)


class Kindergarten(TimeStampedModel):
    user_profile = models.ForeignKey(UserProfile, on_delete=models.CASCADE)
    smart_kindergarten = models.ForeignKey(SmartKindergarten, on_delete=models.CASCADE, null=True, blank=True)
    name = models.CharField('유치원명', max_length=100)
    email = models.EmailField('email', max_length=100, null=True, blank=True)
    post_code = models.CharField('우편번호', max_length=40, null=True, blank=True)
    address = models.CharField('전체주소', max_length=100, null=True, blank=True)
    first_address = models.CharField('주소', max_length=100, null=True, blank=True)
    detail_address = models.CharField('상세주소', max_length=100, null=True, blank=True)
    tel = models.CharField('대표전화', max_length=80, null=True, blank=True)
    area = models.CharField('상권', max_length=100, null=True, blank=True)

    class Meta:
        db_table = 'kg_kindergarten'

    def __unicode__(self):
        return unicode(self.name)
