# -*- coding: utf-8 -*-
from __future__ import absolute_import

from django.conf.urls import url, include
from kindergarten.views import KindergartenLV, KindergartenCV, SmartKindergartenSearchFormView, \
    through_smart_create, KindergartenUV, KindergartenUserDeleteView
from kindergarten.custom_admin.views import KindergartenChangeLV, KindergartenUpdateView, KindergartenDeleteView, \
	KindergartenSearchLV, SmartKindergartenCV

urlpatterns = [
    url(r'^$', KindergartenLV.as_view(), name='list'),
    url(r'^search/$', SmartKindergartenSearchFormView.as_view(), name='search'),
    url(r'^create/$', KindergartenCV.as_view(), name='create'),
    url(r'^(?P<pk>[0-9]+)/update/$', KindergartenUV.as_view(), name='update'),
    url(r'^(?P<pk>[0-9]+)/create/$', through_smart_create, name='through_smart_create'),
    url(r'^(?P<pk>[0-9]+)/delete/$', KindergartenUserDeleteView.as_view(), name='delete'),
]

# 관리자 영역
urlpatterns += [
    url(r'^custom_admin/change_list/$', KindergartenChangeLV.as_view(), name='custom_admin_change_list'),
    url(r'^custom_admin/update/(?P<pk>[0-9]+)/$', KindergartenUpdateView.as_view(), name='custom_admin_update'),
    url(r'^custom_admin/delete/(?P<pk>[0-9]+)/$', KindergartenDeleteView.as_view(), name='custom_admin_delete'),
	url(r'^custom_admin/search_list$', KindergartenSearchLV.as_view(), name='custom_admin_search_list'),
	url(r'^custom_admin/create$', SmartKindergartenCV.as_view(), name='custom_admin_create'),
]