# -*- coding: utf-8 -*-
from __future__ import absolute_import

from django.utils.decorators import classonlymethod
from django.http import HttpResponseRedirect, HttpResponse
from django.views.generic import TemplateView, RedirectView
from django.core.urlresolvers import reverse, reverse_lazy

from measurement.models import Kindergartener
from order_contract.models import OrderContract


class AuthenticationCheckMixin(object):
    @classonlymethod
    def as_view(cls, **initkwargs):
        view = super(AuthenticationCheckMixin, cls).as_view(**initkwargs)
        return authentication_check_decorator(view)


def authentication_check_decorator(view):
    def wrap(request, *args, **kwargs):

        try:
            order_id = kwargs['order_id']
        except:
            order_id = 0

        try:
            kindergartener_id = kwargs['kindergartener_id']
        except:
            kindergartener_id = 0

        if order_id == 0 and kindergartener_id == 0:
            return HttpResponse('올바른 접근이 아닙니다.')

        if order_id == 0:
            order_id = Kindergartener.objects.get(id=kindergartener_id).order_contract_id

        if 'size_recommend' in request.path:
            request_type = 'size_recommend'
        else:
            request_type = 'stats'

        try:
            authentication_code = request.session['authentication_code']
            order = OrderContract.objects.get(id=order_id)

            # print authentication_code, order.authentication_code
            # print type(authentication_code), type(order.authentication_code)
            # print request.path
            # print 'size_recommend' in request.path

            if authentication_code == 'code_error':
                url = reverse('measurement:authentication_code',
                              kwargs={'order_id': order_id, 'kindergartener_id': kindergartener_id, 'request_type': request_type})
                return HttpResponseRedirect(url + '?auth_error=error')
            else:
                if not int(authentication_code) == order.authentication_code:
                    request.session['authentication_code'] = 'code_error'
                    url = reverse('measurement:authentication_code',
                                  kwargs={'order_id': order_id, 'kindergartener_id': kindergartener_id, 'request_type': request_type})
                    return HttpResponseRedirect(url + '?auth_error=error')
            return view(request, *args, **kwargs)
        except:
            url = reverse('measurement:authentication_code', kwargs={'order_id': order_id, 'kindergartener_id': kindergartener_id, 'request_type': request_type})
            return HttpResponseRedirect(url)
            # return HttpResponseRedirect(url + '?auth_error=error')
    return wrap


class AuthenticationCodeTV(TemplateView):
    template_name = 'measurement/authentication_code.html'

    def get_context_data(self, **kwargs):
        context = super(AuthenticationCodeTV, self).get_context_data(**kwargs)
        context['order_id'] = self.kwargs['order_id']
        context['kindergartener_id'] = self.kwargs['kindergartener_id']
        context['request_type'] = self.kwargs['request_type']

        context['auth_error'] = self.request.GET.get('auth_error')
        return context


class AuthenticationCheckTV(RedirectView):
    def get_redirect_url(self, *args, **kwargs):
        order_id = self.kwargs['order_id']
        kindergartener_id = self.kwargs['kindergartener_id']
        request_type = self.kwargs['request_type']
        code = self.request.POST.get('code')

        if order_id > 0:
            order = OrderContract.objects.get(id=order_id)
        else:
            order = Kindergartener.objects.get(id=kindergartener_id).order_contract

        if int(code) == order.authentication_code:
            self.request.session['authentication_code'] = code
        else:
            self.request.session['authentication_code'] = "code_error"

        if request_type == 'size_recommend':
            return reverse_lazy('measurement:size_recommend:intro',
                                kwargs={'order_id': order_id})
        else:
            return reverse_lazy('measurement:submission_guest',
                                kwargs={'order_id': order_id})