# -*- coding: utf-8 -*-
from __future__ import unicode_literals

from django.db import models
from core.models import TimeStampedModel
from order_contract.models import OrderContract, ProductQuantity

SEASON_CHOICES = (
    ('winter', u'동복'),
    ('summer', u'하복')
)
STYLE_CHOICES = (
    ('formal', u'정복'),
    ('training', u'체육복')
)
GENDER_CHOICES = (
    ('boy', u'남아'),
    ('girl', u'여아')
)

SIZE_CHOICES = (
    (0, u'정사이즈'),
    (10, u'한 치수 큰사이즈'),
    (20, u'두 치수 큰사이즈')
)

# Create your models here.
class Kindergartener(TimeStampedModel):
    order_contract = models.ForeignKey(OrderContract, on_delete=models.CASCADE)
    name = models.CharField(max_length=20)
    group = models.CharField(max_length=30)
    birth_date = models.CharField(max_length=20)
    gender = models.CharField(max_length=10, choices=GENDER_CHOICES)
    height = models.PositiveIntegerField(null=True, blank=True)
    weight = models.PositiveIntegerField(null=True, blank=True)
    waist = models.PositiveIntegerField(null=True, blank=True)
    shoulder = models.PositiveIntegerField(null=True, blank=True)

    class Meta:
        db_table = 'ms_kindergartener'

    def __unicode__(self):
        return unicode(self.name)

class Size(TimeStampedModel):
    kindergartener = models.ForeignKey(Kindergartener, on_delete=models.CASCADE)
    season = models.CharField(max_length=10, choices=SEASON_CHOICES)
    style = models.CharField(max_length=10, choices=STYLE_CHOICES)
    checked_size = models.PositiveIntegerField()

    class Meta:
        db_table = 'ms_size'


class DisplaySizeImage(TimeStampedModel):
    name = models.CharField(max_length=20, null=True, blank=True)
    season = models.CharField(max_length=10, choices=SEASON_CHOICES)
    style = models.CharField(max_length=10, choices=STYLE_CHOICES)
    gender = models.CharField(max_length=10, choices=GENDER_CHOICES)
    front_image = models.ImageField(upload_to='display_size_image', null=True, blank=True)
    back_image = models.ImageField(upload_to='display_size_image', null=True, blank=True)
    jacket_off_front_image = models.ImageField(upload_to='display_size_image', null=True, blank=True)
    jacket_off_back_image = models.ImageField(upload_to='display_size_image', null=True, blank=True)
    size_upgrade = models.PositiveIntegerField(choices=SIZE_CHOICES, null=True, blank=True)


class InventoryBySize(TimeStampedModel):
    contract_product = models.OneToOneField(ProductQuantity)
    size90 = models.PositiveIntegerField(default=0)
    size100 = models.PositiveIntegerField(default=0)
    size110 = models.PositiveIntegerField(default=0)
    size120 = models.PositiveIntegerField(default=0)
    size130 = models.PositiveIntegerField(default=0)
    size140 = models.PositiveIntegerField(default=0)
    size150 = models.PositiveIntegerField(default=0)