# -*- coding: utf-8 -*-
from __future__ import absolute_import

from django.conf.urls import url

from measurement.size_recommend.views import IntroTemplateView, KindergartenerCV, BodyInformationInputView, \
    IntroUpdateTemplateView, KindergartenerUV, BodyInformationSaveView, GetSizeRecommendView, display_image_reload, \
    select_size, selected_all_check, CompleteTemplateView, kindergartener_name_check, SelectedCoupleListView

urlpatterns = [
    url(r'^intro/(?P<order_id>[0-9]+)/$', IntroTemplateView.as_view(), name='intro'),
    url(r'^kindergartener_name_check/$', kindergartener_name_check),
    url(r'^intro_update/(?P<kindergartener_id>[0-9]+)/$', IntroUpdateTemplateView.as_view(), name='intro_update'),


    url(r'^kindergartener_create/(?P<order_id>[0-9]+)/$', KindergartenerCV.as_view(), name='kindergartener_create'),
    url(r'^kindergartener_update/(?P<kindergartener_id>[0-9]+)/$', KindergartenerUV.as_view(), name='kindergartener_update'),

    url(r'^body_information_input/(?P<kindergartener_id>[0-9]+)/$', BodyInformationInputView.as_view(), name='body_information_input'),
    url(r'^body_information_save/(?P<kindergartener_id>[0-9]+)/$', BodyInformationSaveView.as_view(), name='body_information_save'),

    url(r'^selected_couple_list/(?P<kindergartener_id>[0-9]+)/$', SelectedCoupleListView.as_view(), name='selected_couple_list'),

    url(r'^get_size_recommend/(?P<kindergartener_id>[0-9]+)/$', GetSizeRecommendView.as_view(), name='get_size_recommend'),
    url(r'^get_size_recommend/(?P<kindergartener_id>[0-9]+)/(?P<season>[\w\-]+)/(?P<style>[\w\-]+)/$', GetSizeRecommendView.as_view(), name='get_size_recommend'),

    url(r'^get_size_recommend/display_image_reload/$', display_image_reload),
    url(r'^get_size_recommend/select_size/$', select_size),
    url(r'^get_size_recommend/selected_all_check/$', selected_all_check),

    url(r'^complete/(?P<kindergartener_id>[0-9]+)$', CompleteTemplateView.as_view(), name='complete'),
]