/**
 * Created by KangHaeSeok on 2017-09-07.
 */
if (!sizeRecommend) var sizeRecommend = {};

// sizeRecommend.season = $("#season").val();
// sizeRecommend.style = $("#style").val();
sizeRecommend.kindergartenerIndex = $("#kindergartenerIndex").val();

sizeRecommend.jacketOnOff = "on";
sizeRecommend.frontOnOff = "on";

$(document).ready(function () {
    sizeRecommend.jacketButtonVisible();
});


sizeRecommend.jacketButtonVisible = function () {
    var season = $("#season").val();
    var style = $("#style").val();
    if ((season === "winter") && (style === "formal")){
        $(".jacketOnOff").show();
    }else{
        $(".jacketOnOff").hide();
    }
};


sizeRecommend.jacketOnOffEvent = function () {

    if(sizeRecommend.jacketOnOff === "off"){
        sizeRecommend.jacketOnOff = "on";
        $("#jacketToggleCheck").prop("checked", true);
    }else {
        sizeRecommend.jacketOnOff = "off";
        $("#jacketToggleCheck").prop("checked", false);
    }

    sizeRecommend.displayImageReload();

};


sizeRecommend.frontOnOffEvent = function () {

    if(sizeRecommend.frontOnOff === "off"){
        sizeRecommend.frontOnOff = "on";
    }else{
        sizeRecommend.frontOnOff = "off";
    }

    sizeRecommend.displayImageReload();

};

sizeRecommend.displayImageReload = function () {

    $.ajax({
        url: '/measurement/size_recommend/get_size_recommend/display_image_reload',
        data: {
          normal_id: $("#normalSizeImageIndex").val(),
          one_up_id: $("#oneUpSizeImageIndex").val(),
          two_up_id: $("#twoUpSizeImageIndex").val(),
          jacket_on_off: sizeRecommend.jacketOnOff,
          front_on_off: sizeRecommend.frontOnOff
        },
        dataType: 'json',
        success: function(data) {
            $("#normalSizeImage").attr("src", data.normalSizeImageUrl);
            $("#oneUpSizeImage").attr("src", data.oneUpSizeImageUrl);
            $("#twoUpSizeImage").attr("src", data.twoUpSizeImageUrl);
        },
        error: function() {
            alert('error');
        }
    });

};


sizeRecommend.selectSize= function (displaySizeImageIndex) {

    var season = $("#season").val();
    var style = $("#style").val();
    $.ajax({
        url: '/measurement/size_recommend/get_size_recommend/select_size',
        data: {
          kindergartener_id: sizeRecommend.kindergartenerIndex,
          season: season,
          style: style,
          display_size_image_index: displaySizeImageIndex
        },
        dataType: 'json',
        success: function(data) {
            $.alert({title: "Alert!", content: data.msg, useBootstrap: false});
        },
        error: function() {
            alert('error');
        }
    });

    $(".checked").each(function () {
        if($(this).parent().children().first().val() === displaySizeImageIndex.toString()){
            $(this).find("img").attr("src", $(this).find("img").attr('src').replace('_n.png','_c.png'))
        }else{
            $(this).find("img").attr("src", $(this).find("img").attr('src').replace('_c.png','_n.png'))
        }
    });

};


sizeRecommend.selectedAllCheck = function () {

    $.ajax({
        url: '/measurement/size_recommend/get_size_recommend/selected_all_check',
        data: {
          kindergartener_id: sizeRecommend.kindergartenerIndex
        },
        dataType: 'json',
        success: function(data) {
            // $.alert({title: "Alert!", content: data.msg, useBootstrap: false});
            location.href="/measurement/size_recommend/complete/"+sizeRecommend.kindergartenerIndex;
        },
        error: function() {
            $.alert({title: "Alert!", content: "사이즈를 전부 선택해주십시오.", useBootstrap: false});
        }
    });

};