# -*- coding: utf-8 -*-
from __future__ import absolute_import

from django.conf.urls import url, include
from measurement.stats.views import *
from measurement.authentication_code import AuthenticationCodeTV, AuthenticationCheckTV

# 사이즈 추천 size_recommend
urlpatterns = [
    url(r'^size_recommend/', include('measurement.size_recommend.urls', namespace="size_recommend")),
]

# 사이즈 현황 - 영업 사원, 유치원 원장
urlpatterns += [
    url(r'^stats/submission/(?P<order_id>[0-9]+)/$', SubmissionStatusView.as_view(), name='submission_status'),
	url(r'^stats/submission/guest/(?P<order_id>[0-9]+)/$', SubmissionStatusForGuest.as_view(), name='submission_guest'),
    url(r'^stats/size_status/(?P<order_id>[0-9]+)/$', SizeStatusView.as_view(), name='size_status'),
	url(r'^stats/inventory/submit/$', inventorySubmit, name='inventory_size'),
	url(r'^stats/size_status/sort/$', sortKindergartenerSet),
]

# 인증코드
urlpatterns += [
    url(r'^authentication_code/(?P<order_id>[0-9]+)/(?P<kindergartener_id>[0-9]+)/(?P<request_type>[\w\-]+)/$', AuthenticationCodeTV.as_view(), name='authentication_code'),
    url(r'^authentication_check/(?P<order_id>[0-9]+)/(?P<kindergartener_id>[0-9]+)/(?P<request_type>[\w\-]+)$', AuthenticationCheckTV.as_view(), name='authentication_check'),
]