# Create your views here.
# -*- coding: utf-8 -*-
from django.views.generic.base import TemplateView
from django.views.generic.list import ListView

from simulation.models import ElectronicBookCatalog


class LittleSmartIntroView(TemplateView):
    template_name = 'not_login/little_smart_intro.html'

    def get_context_data(self, **kwargs):
        context = super(LittleSmartIntroView, self).get_context_data(**kwargs)
        context['little_smart_header'] = 'active'
        return context


class BookCatalogLV(ListView):
    template_name = 'not_login/ebook_catalog.html'
    model = ElectronicBookCatalog

    def get_queryset(self):
        try:
            season = self.kwargs['season']
        except:
            season = 'winter'
        try:
            style = self.kwargs['style']
        except:
            style = 'formal'

        object_list = self.model.objects.filter(
            couple__boy_fitting__fitting_category__season__icontains=season,
            couple__girl_fitting__fitting_category__season__icontains=season,
            couple__boy_fitting__fitting_category__style__icontains=style,
            couple__girl_fitting__fitting_category__style__icontains=style,
            couple__type='catalog'
        ).order_by('couple__name')

        return object_list

    def get_context_data(self, **kwargs):
        context = super(BookCatalogLV, self).get_context_data(**kwargs)

        try:
            season = self.kwargs['season']
        except:
            season = 'winter'
        try:
            style = self.kwargs['style']
        except:
            style = 'formal'

        context['season'] = season
        context['style'] = style

        context['ebook_catalog_header'] = 'active'

        return context
