"""mysite URL Configuration

The `urlpatterns` list routes URLs to views. For more information please see:
    https://docs.djangoproject.com/en/1.9/topics/http/urls/
Examples:
Function views
    1. Add an import:  from my_app import views
    2. Add a URL to urlpatterns:  url(r'^$', views.home, name='home')
Class-based views
    1. Add an import:  from other_app.views import Home
    2. Add a URL to urlpatterns:  url(r'^$', Home.as_view(), name='home')
Including another URLconf
    1. Import the include() function: from django.conf.urls import url, include
    2. Add a URL to urlpatterns:  url(r'^blog/', include('blog.urls'))
"""
from django.conf.urls import url, include
from django.contrib import admin
from django.views.static import serve
from django.conf import settings
from mysite.views import HomeView
from django.conf.urls.static import static

urlpatterns = [
    url(r'^admin/', admin.site.urls),
    url(r'^$', HomeView.as_view(), name='home'),
    url(r'^accounts/', include('accounts.urls', namespace="accounts")),
    url(r'^simulation/', include('simulation.urls', namespace="simulation")),
    url(r'^order_contract/', include('order_contract.urls', namespace="order_contract")),
    url(r'^kindergarten/', include('kindergarten.urls', namespace="kindergarten")),
	url(r'^company/', include('company.urls', namespace="company")),
	url(r'^measurement/', include('measurement.urls', namespace="measurement")),
	url(r'^not_login/', include('mysite.not_login.urls', namespace="not_login")),
]

urlpatterns += [
    url(r'^media/(?P<path>.*)$', serve, {'document_root': settings.MEDIA_ROOT}),
]