# Create your views here.
# -*- coding: utf-8 -*-
from django.views.generic.base import RedirectView

from core.views import LoginRequiredMixin


class HomeView(LoginRequiredMixin, RedirectView):
    url = '/order_contract/little_smart/intro'

    def get_redirect_url(self, *args, **kwargs):
        if str(self.request.user) == 'admin':
            return '/simulation/custom_admin/product_list'
        else:
            return '/order_contract/little_smart/intro'
