# -*- coding: utf-8 -*-
from __future__ import absolute_import
from django.shortcuts import render_to_response

from django.http import HttpResponseRedirect
from django.views.generic import TemplateView, ListView, View
from django.utils.decorators import method_decorator
from django.views.decorators.csrf import csrf_exempt
from core.views import LoginRequiredMixin, OwnerRequiredMixin, OrderStatusMixin
from simulation.models import *
from order_contract.models import OrderContract
from django.http import HttpResponse

import json


class AddOptionView(LoginRequiredMixin, OwnerRequiredMixin, OrderStatusMixin, TemplateView):
    template_name = 'order_contract/add_option/add_option.html'

    def get_context_data(self, **kwargs):
        context = super(AddOptionView, self).get_context_data(**kwargs)

        order_id = self.kwargs['order_id']
        order_contract = OrderContract.objects.get(id=order_id)

        order_status = 3
        if order_contract.order_status < order_status:
            order_contract.order_status = order_status
            order_contract.save()

        final_couple_set = Couple.objects.filter(selectedcoupleset__final_uniform_set__order_contract=order_contract)\
            .order_by('girl_fitting__fitting_category_id')
        option_main_category = OptionMainCategory.objects.filter(visible=True).order_by('id')
        option_set = Option.objects.filter(optionquantity__order_contract=order_contract)

        context['option_main_category'] = option_main_category
        context['final_set'] = final_couple_set
        context['option_set'] = option_set
        context['kindergarten'] = order_contract.kindergarten.name
        return context


@method_decorator(csrf_exempt, name='dispatch')
class FavoriteSetLV(LoginRequiredMixin, ListView):
    template_name = 'order_contract/add_option/favorite_set_list.html'
    favorite_set = None

    def post(self, request, *args, **kwargs):
        order_id = self.request.POST.get('orderId')
        couple_id = self.request.POST.get('coupleId')

        season = Couple.objects.get(id=couple_id).girl_fitting.fitting_category.season
        style = Couple.objects.get(id=couple_id).girl_fitting.fitting_category.style

        self.favorite_set = Couple.objects.filter(
            selectedfavoritecoupleset__final_uniform_set__order_contract_id=order_id,
            girl_fitting__fitting_category__season__contains=season,
            girl_fitting__fitting_category__style__contains=style
        ).order_by('girl_fitting__fitting_category_id')

        function_list = Function.objects.all()
        function_of_final = Function.objects.filter(
            selectedcoupleset__final_uniform_set__order_contract_id=order_id,
            selectedcoupleset__couple_id=couple_id
        ).values_list('id', flat=True)

        return render_to_response(self.template_name, {
            'favorite_set':self.favorite_set,
            'function_list': function_list,
            'function_of_final': function_of_final,
            'style': style
        })

@method_decorator(csrf_exempt, name='dispatch')
class UpdateFinalView(LoginRequiredMixin, TemplateView):
    template_name = 'order_contract/add_option/final_set_list.html'
    final_set = None

    def post(self, request, *args, **kwargs):
        order_id = self.request.POST.get('order_id')
        old_id = self.request.POST.get('oldId')
        new_id = self.request.POST.get('newId')
        final_function = self.request.POST.getlist('finalFunction[]')

        final_couple = SelectedCoupleSet.objects.get(final_uniform_set__order_contract_id=order_id, couple_id=old_id)

        if old_id != new_id:
            final_couple.couple_id = new_id
            final_couple.save()

            favorite_couple = SelectedFavoriteCoupleSet.objects.get(final_uniform_set__order_contract_id=order_id, couple_id=new_id)
            favorite_couple.couple_id = old_id
            favorite_couple.save()

        self.final_set = Couple.objects.filter(selectedcoupleset__final_uniform_set__order_contract_id=order_id) \
            .order_by('girl_fitting__fitting_category_id')

        final_couple.function_set.set(Function.objects.filter(id__in=final_function))
        option_set = Option.objects.filter(optionquantity__order_contract_id=order_id)

        return render_to_response(self.template_name, {'final_set': self.final_set, 'option_set': option_set})

@method_decorator(csrf_exempt, name='dispatch')
class OptionSubCategoryLV(LoginRequiredMixin, ListView):
    template_name = 'order_contract/add_option/option_sub_category.html'

    def post(self, request, *args, **kwargs):
        main_category_id = self.request.POST.get('mainCId')
        sub_category_list = OptionSubCategory.objects.filter(main_category__id=main_category_id, visible=True)

        return render_to_response(self.template_name, {'sub_category_list': sub_category_list})

@method_decorator(csrf_exempt, name='dispatch')
class OptionItemLV(LoginRequiredMixin, ListView):
    template_name = 'order_contract/add_option/option_item_list.html'

    def post(self, request, *args, **kwargs):
        order_id = self.request.POST.get('order_id')
        sub_category_id = self.request.POST.get('subCId')

        selected_option_list = Option.objects.filter(optionquantity__order_contract_id=order_id).values_list('id', flat=True)
        option_list = Option.objects.filter(sub_category_id = sub_category_id, visible=True)

        return render_to_response(self.template_name, {'option_list': option_list, 'selected_option_list': selected_option_list})


@method_decorator(csrf_exempt, name='dispatch')
class AddOptionItemView(LoginRequiredMixin, View):

    def post(self, request, *args, **kwargs):
        order_id = self.request.POST.get('order_id')
        option_id = self.request.POST.get('optionId')

        order = OrderContract.objects.get(id=order_id)
        option = Option.objects.get(id=option_id)

        order.optionquantity_set.create(option=option)

        front_url = option.front_image.url if option.front_image else ''
        back_url = option.back_image.url if option.back_image else ''

        data = {'front': front_url, 'back': back_url}
        return HttpResponse(json.dumps(data), content_type='application/json')


@method_decorator(csrf_exempt, name='dispatch')
class DeleteOptionItemView(LoginRequiredMixin, View):
    def post(self, request, *args, **kwargs):
        order_id = self.request.POST.get('order_id')
        option_id = self.request.POST.get('optionId')

        order = OrderContract.objects.get(id=order_id)
        option = Option.objects.get(id=option_id)
        order.optionquantity_set.filter(option=option).delete()

        return HttpResponse(json.dumps({'data': True}), content_type='application/json')