# -*- coding: utf-8 -*-
from __future__ import absolute_import

import operator, json

from django.views.generic import TemplateView

from core.views import AdminRequiredMixin
from simulation.models import ElectronicBookCatalog


class CatalogRankingView(AdminRequiredMixin, TemplateView):
    template_name = 'order_contract/custom_admin/business_status/catalog_ranking.html'

    def get_context_data(self, **kwargs):
        context = super(CatalogRankingView, self).get_context_data(**kwargs)

        print self.kwargs
        # season = self.kwargs['season']
        # style = self.kwargs['style']
        try:
            season = self.kwargs['season']
        except:
            season = 'winter'
        try:
            style = self.kwargs['style']
        except:
            style = 'formal'

        context['season'] = season
        context['style'] = style
        print season, style

        catalog_list = ElectronicBookCatalog.objects.filter(
            couple__selectedcoupleset__final_uniform_set__order_contract__order_status=5,
            couple__boy_fitting__fitting_category__season__iexact=season,
            couple__girl_fitting__fitting_category__season__iexact=season,
            couple__boy_fitting__fitting_category__style__iexact=style,
            couple__girl_fitting__fitting_category__style__iexact=style,
        )

        # 이름별로 정렬
        couple_name_array = catalog_list.order_by("couple__name")[:10]

        couple_names = []
        couple_selected_counts = []

        for catalog in couple_name_array:
            couple_names.append(catalog.couple.name)
            couple_selected_counts.append(catalog.couple.selectedcoupleset_set.filter(final_uniform_set__order_contract__order_status=5).count())

        context['couple_names'] = json.dumps(couple_names)
        context['couple_selected_counts'] = json.dumps(couple_selected_counts)

        # 순위별 정렬 1순위 selected 채택 수, 2순위 이름
        for catalog in catalog_list:
            catalog.selected_count = catalog.couple.selectedcoupleset_set.filter(final_uniform_set__order_contract__order_status=5).count()

        catalog_rank_array = sorted(sorted(catalog_list, key=operator.attrgetter('couple.name')), key=operator.attrgetter('selected_count'), reverse=True)

        # 이렇게 하면 나중에 오류남
        # context['catalog_rank_top5'] = catalog_rank_array[:5]
        # context['catalog_rank_top10'] = catalog_rank_array[5:10]

        # 그래서 요롷게 해줌 template 에서 if 문 거는게 낫다
        context['catalog_rank_array'] = catalog_rank_array

        context['selectedCategory'] = 'order'
        context['catalog_ranking'] = 'select'

        # for catalog in catalog_rank_array:
        #     print catalog.couple.name, catalog.couple.selectedcoupleset_set.filter(final_uniform_set__order_contract__order_status=5).__len__()

        # for catalog in catalog_list:
        #     print catalog.couple.name, catalog.couple.selectedcoupleset_set.filter(final_uniform_set__order_contract__order_status=5).__len__()
        #     # selected_couple_list = catalog.couple.selectedcoupleset_set.filter(final_uniform_set__order_contract__order_status=5)
        #     # for selected_couple in selected_couple_list:
        #     #     print selected_couple.final_uniform_set.order_contract.order_status

        return context
