# -*- coding: utf-8 -*-
from __future__ import absolute_import

from django.views.generic import ListView
from django.db.models import Q

from core.views import AdminRequiredMixin, PaginationMixin
from order_contract.models import OrderContract


class AdminLittleSmartLV(AdminRequiredMixin, PaginationMixin, ListView):
    model = OrderContract
    template_name = 'order_contract/custom_admin/order_contract_list.html'
    paginate_by = 13

    def get_queryset(self):
        search_word = self.request.GET.get('search_word')

        if not search_word:
            search_word = ''

        return OrderContract.objects.filter(
            Q(kindergarten__name__icontains=search_word) |
            Q(name__icontains=search_word) |
            Q(kindergarten__user_profile__user_name__icontains=search_word)
        ).order_by('-create_date')

    def get_context_data(self, **kwargs):
        context = super(AdminLittleSmartLV, self).get_context_data(**kwargs)
        context['search_paging'] = True
        context['search_word'] = self.request.GET.get('search_word') if self.request.GET.get('search_word') else ''
        context['selectedCategory'] = 'order'
        context['order_status'] = 'select'
        return context
