# -*- coding: utf-8 -*-
from __future__ import absolute_import

from django.http import HttpResponse
from django.shortcuts import redirect
from django.core.urlresolvers import reverse_lazy, reverse
from django.views.decorators.csrf import csrf_exempt
from simulation.models import FinalFittingSet, SelectedCoupleSet, SelectedFavoriteCoupleSet
from order_contract.models import OrderContract

import json

@csrf_exempt
def final_create(request):
    order_id = request.POST.get('order_id')
    favorite_couple_set = request.POST.getlist('favorite[]')
    final_couple_set = request.POST.getlist('set[]')

    order_contract = OrderContract.objects.get(id=order_id)
    order_contract.order_status = 1
    final_fitting_set = FinalFittingSet.objects.create(order_contract=order_contract)

    for couple_id in favorite_couple_set:
        SelectedFavoriteCoupleSet.objects.create(final_uniform_set=final_fitting_set, couple_id= couple_id)

    for couple_id in final_couple_set:
        SelectedCoupleSet.objects.create(final_uniform_set=final_fitting_set, couple_id=couple_id)

    variables = {'success': True, 'url': reverse('order_contract:add_option', kwargs={'order_id': order_id})}
    return HttpResponse(json.dumps(variables), content_type='application/json')

