# -*- coding: utf-8 -*-
from __future__ import absolute_import

import json

from django.http import HttpResponse
from django.views.generic import TemplateView, ListView
from django.db.models import Q

from core.views import LoginRequiredMixin, OwnerRequiredMixin
from simulation.models import Couple, ElectronicBookCatalog
from order_contract.models import OrderContract


class BookCatalogLV(OwnerRequiredMixin, LoginRequiredMixin, ListView):
    template_name = 'order_contract/ebook_catalog/ebook_catalog.html'
    model = ElectronicBookCatalog

    def get_queryset(self):
        try:
            season = self.kwargs['season']
        except:
            season = 'winter'
        try:
            style = self.kwargs['style']
        except:
            style = 'formal'

        object_list = self.model.objects.filter(
            couple__boy_fitting__fitting_category__season__icontains=season,
            couple__girl_fitting__fitting_category__season__icontains=season,
            couple__boy_fitting__fitting_category__style__icontains=style,
            couple__girl_fitting__fitting_category__style__icontains=style,
            couple__type='catalog'
        ).order_by('couple__name')

        order_id = self.kwargs['order_id']
        favorite_check_catalog_list = []
        for catalog in object_list:
            if catalog.couple.selectedfavoritecoupleset_set.filter(final_uniform_set__order_contract_id=order_id).__len__() > 0:
                catalog.favorite_check = True
            favorite_check_catalog_list.append(catalog)

        return favorite_check_catalog_list

    def get_context_data(self, **kwargs):
        context = super(BookCatalogLV, self).get_context_data(**kwargs)

        order_id = self.kwargs['order_id']
        context['order_id'] = order_id
        context['kindergarten_id'] = OrderContract.objects.get(id=order_id).kindergarten_id

        try:
            season = self.kwargs['season']
        except:
            season = 'winter'
        try:
            style = self.kwargs['style']
        except:
            style = 'formal'

        context['season'] = season
        context['style'] = style

        return context


def couple_favorite(request):
    season = request.GET.get('season')
    style = request.GET.get('style')
    couple_id = request.GET.get('couple_id')
    order_id = request.GET.get('order_id')

    order_contract = OrderContract.objects.get(id=order_id)
    favorite_couple_set_list = order_contract.finalfittingset.selectedfavoritecoupleset_set.filter(
        couple__boy_fitting__fitting_category__season=season,
        couple__boy_fitting__fitting_category__style=style,
        couple__girl_fitting__fitting_category__season=season,
        couple__girl_fitting__fitting_category__style=style,
    )

    if favorite_couple_set_list.__len__() > 2:
        result_data = {'message': '관심리스트는 최대 3개를 허용합니다.', 'error': 'star_image_off'}
        return HttpResponse(json.dumps(result_data, indent=4, ensure_ascii=False, encoding='utf-8'))

    for favorite_couple_set in favorite_couple_set_list:
        if favorite_couple_set.couple.id == int(couple_id):
            result_data = {'message': '이미 관심리스트에 있는 커플입니다.'}
            return HttpResponse(json.dumps(result_data, indent=4, ensure_ascii=False, encoding='utf-8'))

    order_contract.finalfittingset.selectedfavoritecoupleset_set.create(couple_id=couple_id)

    result_data = {'message': '관심리스트에 등록되었습니다.'}
    return HttpResponse(json.dumps(result_data, indent=4, ensure_ascii=False, encoding='utf-8'))


# e북 카탈로그 관심삭제 이벤트
def favorite_relation_cut(request):
    couple_id = request.GET.get('couple_id')
    order_id = request.GET.get('order_id')

    order_contract = OrderContract.objects.get(id=order_id)

    favorite_set = order_contract.finalfittingset.selectedfavoritecoupleset_set.get(couple_id=couple_id)
    favorite_set.delete()

    result_data = {'message': '삭제되었습니다.'}
    return HttpResponse(json.dumps(result_data, indent=4, ensure_ascii=False, encoding='utf-8'))
