# -*- coding: utf-8 -*-
from __future__ import absolute_import

from django.views.generic import ListView, TemplateView, CreateView, RedirectView, DeleteView
from django.core.urlresolvers import reverse_lazy
from django.shortcuts import redirect

from core.views import LoginRequiredMixin, PaginationMixin, OwnerRequiredMixin
from order_contract.models import OrderContract
from kindergarten.models import Kindergarten
from simulation.models import FinalFittingSet


class LittleSmartLV(OwnerRequiredMixin, LoginRequiredMixin, PaginationMixin, ListView):
    model = OrderContract
    template_name = 'order_contract/little_smart/little_smart_list.html'
    paginate_by = 5

    def get_queryset(self):
        kindergarten_id = self.kwargs['kindergarten_id']
        return OrderContract.objects.filter(kindergarten_id=kindergarten_id).order_by('-create_date')

    def get_context_data(self, **kwargs):
        context = super(LittleSmartLV, self).get_context_data(**kwargs)
        context['kindergarten'] = Kindergarten.objects.get(id=self.kwargs['kindergarten_id'])
        context['kindergarten_id'] = self.kwargs['kindergarten_id']
        return context


# class LittleSmartCV(LoginRequiredMixin, CreateView):
#     template_name = 'order_contract/little_smart/little_smart_create.html'
#     model = OrderContract
#     fields = ['delivery_text', 'special_note']
#
#     def get_context_data(self, **kwargs):
#         context = super(LittleSmartCV, self).get_context_data(**kwargs)
#         context['kindergarten_id'] = self.kwargs['kindergarten_id']
#         context['kindergarten'] = Kindergarten.objects.get(id=self.kwargs['kindergarten_id'])
#         return context
#
#     def get_success_url(self):
#         return reverse_lazy('order_contract:little_smart_list', kwargs={'kindergarten_id': self.kwargs['kindergarten_id']})
#
#     def form_valid(self, form):
#         little_smart = form.save(commit=False)
#         little_smart.kindergarten_id = self.kwargs['kindergarten_id']
#         little_smart.save()
#         return redirect(self.get_success_url())


class LittleSmartCV(OwnerRequiredMixin, LoginRequiredMixin, RedirectView):
    def get_redirect_url(self, *args, **kwargs):
        return reverse_lazy('order_contract:little_smart_list', kwargs={'kindergarten_id': self.kwargs['kindergarten_id']})

    def get(self, request, *args, **kwargs):
        kindergarten_id = self.kwargs['kindergarten_id']
        order_name = self.request.POST.get('orderName')
        order_contract = OrderContract.objects.create(kindergarten_id=kindergarten_id, name=order_name)
        FinalFittingSet.objects.create(order_contract=order_contract, name=order_contract.kindergarten.name + '_' + str(order_contract.key))

        return redirect(self.get_redirect_url())


def find_order(request, order_id):
    order = OrderContract.objects.get(id=order_id)
    if order.order_status == 1:
        return redirect(reverse_lazy('order_contract:ebook_catalog_list', kwargs={'order_id': order_id}))
    elif order.order_status == 2:
        return redirect(reverse_lazy('simulation:extend_mapping:index', kwargs={'order_id': order_id}))
    elif order.order_status == 3:
        return redirect(reverse_lazy('order_contract:option_index', kwargs={'order_id': order_id}))
    elif order.order_status == 4:
        return redirect(reverse_lazy('order_contract:estimate_index', kwargs={'order_id': order_id}))
    else:
        return redirect(reverse_lazy('order_contract:contract_complete', kwargs={'order_id': order_id}))


class LittleSmartIntroView(LoginRequiredMixin, TemplateView):
    template_name = 'order_contract/little_smart/little_smart.html'

    # def get_context_data(self, **kwargs):
    #     context = super(LittleSmartIntroView, self).get_context_data(**kwargs)
    #     context['order_id'] = self.kwargs['order_id']
    #     return context


class LittleSmartDeleteView(OwnerRequiredMixin, LoginRequiredMixin, DeleteView):
    model = OrderContract

    def get_success_url(self, **kwargs):
        return reverse_lazy('order_contract:little_smart_list', kwargs={'kindergarten_id': self.kwargs['kindergarten_id']})

    def get(self, request, *args, **kwargs):
        order_contract = OrderContract.objects.get(id=self.kwargs['order_id'])
        self.kwargs['kindergarten_id'] = order_contract.kindergarten_id
        self.kwargs['pk'] = order_contract.id
        self.delete(request, *args, **kwargs)
        return redirect(self.get_success_url())
