# -*- coding: utf-8 -*-
# Generated by Django 1.9.8 on 2017-07-27 02:49
from __future__ import unicode_literals

from django.db import migrations, models
import django.db.models.deletion
import order_contract.models


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        ('simulation', '0001_initial'),
        ('kindergarten', '0001_initial'),
    ]

    operations = [
        migrations.CreateModel(
            name='OrderContract',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('create_date', models.DateTimeField(auto_now_add=True, null=True, verbose_name='Create Date')),
                ('modify_date', models.DateTimeField(auto_now=True, null=True, verbose_name='Modify Date')),
                ('order_status', models.IntegerField(choices=[(1, 'little_smart'), (2, 'custom_design_offer'), (3, 'add_option'), (4, 'supply_price'), (5, 'contract_complete')], default=1)),
                ('sign_image', models.ImageField(blank=True, null=True, upload_to=order_contract.models.sign_file_name, verbose_name='\uc11c\uba85')),
                ('delivery_text', models.TextField(blank=True, null=True, verbose_name='\ub0a9\ud488\uad00\ub828\uc694\uccad')),
                ('special_note', models.TextField(blank=True, null=True, verbose_name='\ud2b9\uc774\uc0ac\ud56d')),
                ('key', models.PositiveIntegerField(blank=True, null=True)),
                ('name', models.CharField(blank=True, max_length=40, null=True)),
                ('kindergarten', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='kindergarten.Kindergarten')),
            ],
            options={
                'db_table': 'oc_order_contract',
            },
        ),
        migrations.CreateModel(
            name='ProductQuantity',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('quantity', models.IntegerField()),
                ('order_contract', models.ForeignKey(db_column='order_contract', on_delete=django.db.models.deletion.CASCADE, to='order_contract.OrderContract')),
                ('product', models.ForeignKey(db_column='product', on_delete=django.db.models.deletion.CASCADE, to='simulation.Product')),
            ],
            options={
                'db_table': 'oc_product_quantity',
            },
        ),
        migrations.AddField(
            model_name='ordercontract',
            name='product_quantity',
            field=models.ManyToManyField(through='order_contract.ProductQuantity', to='simulation.Product'),
        ),
        migrations.AlterUniqueTogether(
            name='ordercontract',
            unique_together=set([('key', 'kindergarten')]),
        ),
    ]
