/**
 * Created by KangHaeSeok on 2017-08-07.
 */

if (!eBookCatalog) var eBookCatalog = {};

$(document).ready(function () {
    eBookCatalog.intro_TypeBtnClick();

    yepnope({
        test : Modernizr.csstransforms,
        yep: ["/static/base/js/turn.js"],
        // nope: ['js/turn.html4.min.js'],
        both: ["/static/base/css/basic.css"],
        complete: eBookCatalog.loadApp
    });

});

eBookCatalog.loadApp =  function() {

    // Create the flipbook

    $('.flipbook').turn({
            // Width

            width:1075,

            // Height

            height:700,

            // Elevation

            elevation: 50,

            // Enable gradients

            gradients: true,

            // Auto center this flipbook

            autoCenter: true

    });
    $(".flipbook-viewport").show();
};

// Load the HTML4 version if there's not CSS transform

eBookCatalog.intro_TypeBtnClick = function (){
    $(".introTab>ul>li.season>ul>li").click(function(){
        var tabindex = $(this).index();
        $(".introTab>ul>li.season>ul>li").each(function(idx){
            $(this).find('img').attr('src',$(this).find('img').attr('src').replace('_b.png','_c.png'));
            if(tabindex != idx){
                $(this).find('img').attr('src',$(this).find('img').attr('src').replace('_c.png','_b.png'));
            }
        });
    });
    $(".introTab>ul>li.type>ul>li").click(function(){
        var tabindex = $(this).index();
        $(".introTab>ul>li.type>ul>li").each(function(idx){
            $(this).find('img').attr('src',$(this).find('img').attr('src').replace('_b.png','_c.png'));
            if(tabindex != idx){
                $(this).find('img').attr('src',$(this).find('img').attr('src').replace('_c.png','_b.png'));
            }
        });
    });

    $(".eBookStar").click(function(){
        var src = $(this).attr('src');
        var coupleIndex = $(this).siblings(".coupleIndex").val();

        if (src === '/static/base/image/star_c.png'){
            // 관심해제
            src = '/static/base/image/star_n.png';
            var starImageOff = eBookCatalog.coupleFavoriteRelationCut(coupleIndex);
            if(starImageOff){
                src = '/static/base/image/star_c.png';
            }
        }else {
            // 관심등록
            src = '/static/base/image/star_c.png';
            var starImageOn = eBookCatalog.coupleFavoriteEvent(coupleIndex);
            if(starImageOn){
                src = '/static/base/image/star_n.png';
            }
        }

        $(this).attr('src',src);
    });
};


//e북에서 커플 관심등록
eBookCatalog.coupleFavoriteEvent = function (coupleIndex) {
    var starImageOff = false;
    $.ajax({
        url: '/order_contract/ebook_catalog/couple_favorite',
        dataType: 'json',
        data: {
            couple_id: coupleIndex,
            season: eBookCatalog.season,
            style: eBookCatalog.style,
            order_id: eBookCatalog.orderIndex
        },
        success: function(data) {
            $.alert({title: 'Alert!', content: data.message, useBootstrap: false});
            if ( data.error == 'star_image_off' ){
                starImageOff = true;
            }
        },
        error: function() {
            alert('error');
        }
    });

    return starImageOff;

};


//e북에서 커플 관심해제
eBookCatalog.coupleFavoriteRelationCut = function (coupleIndex) {

    var starImageOn = false;

    $.confirm({
        title: 'Confirm!',
        content: '관심 목록에서 삭제하시겠습니까?',
        useBootstrap: false,
        buttons: {
            confirm: function () {

                $.ajax({
                    url: '/order_contract/ebook_catalog/favorite_relation_cut',
                    dataType: 'json',
                    data: {
                        couple_id: coupleIndex,
                        order_id: eBookCatalog.orderIndex
                    },
                    success: function(data) {
                        $.alert({title: 'Alert!', content: data.message, useBootstrap: false});
                        $("input[value='"+coupleIndex+"']").siblings(".eBookStar").attr("src", '/static/base/image/star_n.png');

                    },
                    error: function() {
                        console.log('error');
                    }
                });

            },
            cancel: function () {
                $("input[value='"+coupleIndex+"']").siblings(".eBookStar").attr("src", '/static/base/image/star_c.png');
            }
        }
    });

    return starImageOn;

};