# -*- coding: utf-8 -*-
from django.conf.urls import url

from order_contract.little_smart.views import LittleSmartLV, LittleSmartCV, find_order, LittleSmartIntroView, \
    LittleSmartDeleteView
from order_contract.ebook_catalog.views import BookCatalogLV, couple_favorite, favorite_relation_cut
from order_contract.custom_design_offer.views import final_create
from order_contract.add_option.views import *
from order_contract.estimate.views import *
from order_contract.contract.views import *
from order_contract.custom_admin.views import AdminLittleSmartLV
from order_contract.email.views import *
from order_contract.custom_admin.business_status.sales_status import SalesStatusView
from order_contract.custom_admin.business_status.catalog_ranking import CatalogRankingView

urlpatterns = [
    # url(r'^kindergarten/', include('kindergarten.urls', namespace="kindergarten")),
    # url(r'^little_smart/', include('order_contract.little_smart.urls', namespace="little_smart")),
    # url(r'^ebook_catalog/', include('order_contract.ebook_catalog.urls', namespace="ebook_catalog")),
    # url(r'^custom_design_offer/', include('order_contract.custom_design_offer.urls', namespace="custom_design_offer")),
    # url(r'^add_option/', include('order_contract.add_option.urls', namespace="add_option")),
]

# 리틀스마트
urlpatterns += [
    url(r'^little_smart/list/kindergarten_id/(?P<kindergarten_id>[0-9]+)/$', LittleSmartLV.as_view(), name='little_smart_list'),
    url(r'^little_smart/create/kindergarten_id/(?P<kindergarten_id>[0-9]+)/$', LittleSmartCV.as_view(), name='little_smart_create'),
    url(r'^little_smart/intro/$', LittleSmartIntroView.as_view(), name='little_smart_intro'),
    # url(r'^little_smart/intro/order_id/(?P<order_id>[0-9]+)/$', LittleSmartIntroView.as_view(), name='little_smart_intro'),
    url(r'^little_smart/find_order/order_id/(?P<order_id>[0-9]+)/$', find_order, name='little_smart_find_order'),
    url(r'^little_smart/delete/(?P<order_id>[0-9]+)/$', LittleSmartDeleteView.as_view(), name='little_smart_delete'),
]

# ebook 카탈로그
urlpatterns += [
    # url(r'^$', BookCatalogLV.as_view(), name='list'),
    url(r'^ebook_catalog/order_id/(?P<order_id>[0-9]+)/$', BookCatalogLV.as_view(), name='ebook_catalog_list'),
    url(r'^ebook_catalog/order_id/(?P<order_id>[0-9]+)/(?P<season>[\w\-]+)/(?P<style>[\w\-]+)/$', BookCatalogLV.as_view(), name='ebook_catalog_list'),
    url(r'^ebook_catalog/couple_favorite/$', couple_favorite),
    url(r'^ebook_catalog/favorite_relation_cut/$', favorite_relation_cut),
]

# 매핑 후 확정세트들 가진 final fitting set 생성
urlpatterns += [
    url(r'^custom_design_offer/final_create/$', final_create, name='custom_design_offer_final_create'),
]

# 추가옵션
urlpatterns += [
    url(r'^add_option/order_id/(?P<order_id>[0-9]+)/$', AddOptionView.as_view(), name='option_index'),
    url(r'^add_option/favorite_set_list/$', FavoriteSetLV.as_view(), name='favorite_set_list'),
    url(r'^add_option/update_final/$', UpdateFinalView.as_view(), name='update_final'),
    url(r'^add_option/option_sub_category/$', OptionSubCategoryLV.as_view(), name='option_sub_category'),
    url(r'^add_option/option_list/$', OptionItemLV.as_view(), name='option_list'),
    url(r'^add_option/add_option_item/$', AddOptionItemView.as_view(), name='add_option_item'),
    url(r'^add_option/delete_option_item/$', DeleteOptionItemView.as_view(), name='delete_option_item'),
]

# 견적
urlpatterns += [
    url(r'^estimate/order_id/(?P<order_id>[0-9]+)/$', EstimateView.as_view(), name='estimate_index'),
    url(r'^estimate/update_final/$', UpdateEstimateFinalView.as_view(), name='estimate_update'),
    url(r'^estimate/set_discount_rate/$', UpdateDiscountRateView.as_view()),
    url(r'^estimate/option_discount_rate/$', UpdateOptionDiscountRateView.as_view()),
    url(r'^estimate/pdf/save/$', saveEstimatePdf),
]

# 계약
urlpatterns += [
    url(r'^contract/order_id/(?P<order_id>[0-9]+)/$', ContractView.as_view(), name='contract_index'),
    url(r'^contract/submit/$', ContractSubmit.as_view(), name='contract_submit'),
    url(r'^contract/complete/(?P<order_id>[0-9]+)/$', ContractComplete.as_view(), name='contract_complete'),
    url(r'^contract/pamphlet/(?P<order_id>[0-9]+)/$', ContractPamphlet.as_view(), name='contract_pamphlet'),
    url(r'^contract/pdf/save/$', saveContractPdf),
    url(r'^pamphlet/pdf/save/$', savePamphletPdf),
    url(r'^completion/(?P<order_id>[0-9]+)/$', CompletionIndex.as_view(), name='completion_index'),

]

# 이메일
urlpatterns += [
    url(r'^send_mail/$', passSendMail, name='custom_admin_order_list'),
]

# 관리자
urlpatterns += [
    url(r'^custom_admin/order_list$', AdminLittleSmartLV.as_view(), name='custom_admin_order_list'),

#     catalog_ranking 카탈로그 매출 순위 (강해석)
    url(r'^custom_admin/catalog_ranking/$', CatalogRankingView.as_view(), name='custom_admin_catalog_ranking'),
    url(r'^custom_admin/catalog_ranking/(?P<season>[\w\-]+)/(?P<style>[\w\-]+)/$', CatalogRankingView.as_view(),
        name='custom_admin_catalog_ranking'),
#     sales_status (매출 현황? 이하영)
    url(r'^custom_admin/sales_status/$', SalesStatusView.as_view(), name='custom_admin_sales_status'),

]