# -*- coding: utf-8 -*-
import operator

from simulation.models import Product, MainFabric


# 조건에 맞는 프로덕트 가져오는 쿼리
def get_product_filter(season, style, product_type):
    product_list = Product.objects.filter(
        season__icontains=season,
        style__icontains=style,
        product_type__name__icontains=product_type
    ).order_by('name')

    for product in product_list:
        product.first_fabric = product.mainfabric_set.all().order_by('id')[0]

    # product의 값이 하나도 없어도 프로덕트 탭에 카테고리는 보이게 문자를 반납한다
    # 자세한건 product_tab.html참조
    if product_list.__len__() > 0:
        return product_list
    else:
        return 'nothing'


# 남녀 모두의 경우의 수 따져서 카테고리 및 product object list 반환
# FabricCategoryList 가 필요한 경우는 Product Object List 까지 필요 없으니 템플릿에 보이기만 하게 True만 준다
# 만일 카테고리가 추가된다면 여기 views.py 와
# product_tab.html, fabric_tab.html, variable_collection.js product_category_exception.js의 목록들을 수정해줘야한다
# 그러니 제발 추가가 안되길
def get_product_context_data(context, season, style):
    if season == 'winter' and style == 'formal':
        context['boy_shirts'] = get_product_filter(season, style, 'shirts')
        context['boy_jacket'] = get_product_filter(season, style, 'jacket')
        context['boy_vest'] = get_product_filter(season, style, 'vest')
        context['boy_pants'] = get_product_filter(season, style, 'pants')
        context['boy_overall'] = get_product_filter(season, style, 'overall')
        context['boy_acc'] = get_product_filter(season, style, 'acc')

        context['girl_shirts'] = get_product_filter(season, style, 'shirts')
        context['girl_jacket'] = get_product_filter(season, style, 'jacket')
        context['girl_vest'] = get_product_filter(season, style, 'vest')
        context['girl_pants'] = get_product_filter(season, style, 'pants')
        context['girl_skirt'] = get_product_filter(season, style, 'skirt')
        context['girl_one_piece'] = get_product_filter(season, style, 'one-piece')
        context['girl_overall'] = get_product_filter(season, style, 'overall')
        context['girl_dress'] = get_product_filter(season, style, 'dress')
        context['girl_acc'] = get_product_filter(season, style, 'acc')

    elif season == 'winter' and style == 'training':
        context['boy_shirts'] = get_product_filter(season, style, 'shirts')
        context['boy_pants'] = get_product_filter(season, style, 'pants')

        context['girl_shirts'] = get_product_filter(season, style, 'shirts')
        context['girl_pants'] = get_product_filter(season, style, 'pants')

    elif season == 'summer' and style == 'formal':
        context['boy_shirts'] = get_product_filter(season, style, 'shirts')
        context['boy_pants'] = get_product_filter(season, style, 'pants')
        context['boy_acc'] = get_product_filter(season, style, 'acc')

        context['girl_shirts'] = get_product_filter(season, style, 'shirts')
        context['girl_pants'] = get_product_filter(season, style, 'pants')
        context['girl_skirt'] = get_product_filter(season, style, 'skirt')
        context['girl_acc'] = get_product_filter(season, style, 'acc')

    elif season == 'summer' and style == 'training':
        context['boy_shirts'] = get_product_filter(season, style, 'shirts')
        context['boy_pants'] = get_product_filter(season, style, 'pants')

        context['girl_shirts'] = get_product_filter(season, style, 'shirts')
        context['girl_pants'] = get_product_filter(season, style, 'pants')
    return context


# 아이디에 해당하는 main_fabric 오브젝트를 가져온 후 z 인덱스 정렬시키는 함수
def z_index_sort(coordi_fabric_list):
    context_fabric_list = []

    # 문자열로 들어오니깐 int 형식으로 변환해준다
    for fabric_id in coordi_fabric_list:
        if int(fabric_id) > 0:
            main_fabric = MainFabric.objects.get(id=int(fabric_id))

            # main fabric의 z-index 설정 트레이닝복에서와 하복정복때 shirts 와 pants의 순서를 바꾼다 안그럼 상의가 바지에 씹힘
            if main_fabric.product.style.lower() == 'training' and main_fabric.product.product_type.name.lower() == 'shirts':
                main_fabric.z_index = 1
            elif main_fabric.product.style.lower() == 'training' and main_fabric.product.product_type.name.lower() == 'pants':
                main_fabric.z_index = 0
            elif main_fabric.product.style.lower() == 'formal' and main_fabric.product.season.lower() == 'summer' and main_fabric.product.product_type.name.lower() == 'shirts':
                main_fabric.z_index = 1
            elif main_fabric.product.style.lower() == 'formal' and main_fabric.product.season.lower() == 'summer' and main_fabric.product.product_type.name.lower() == 'pants':
                main_fabric.z_index = 0
            elif main_fabric.product.style.lower() == 'formal' and main_fabric.product.season.lower() == 'summer' and main_fabric.product.product_type.name.lower() == 'skirt':
                main_fabric.z_index = 0
            else:
                main_fabric.z_index = main_fabric.product.product_type.index
            context_fabric_list.append(main_fabric)

    # main fabric에 설정된 z_index 값 순으로 나열한다. 결국 z_index가 높은 fabric은 나중에 덧붙여진다 그러므로 가장 위에 보인다
    return sorted(context_fabric_list, key=operator.attrgetter('z_index'))
