from django.conf.urls import url
from simulation.custom_admin.views import HomeView, CenterListChangeView, GetProductListView, GetCoordiCenterView, \
    GetFabricCategoryListView, GetFabricContentListView, new_couple_save, change_slide_back_jacket, \
    get_couples_main_fabric, LeftListChangeView, couple_delete, CoupleDetailView, origin_couple_update, \
    get_catalog_image, catalog_image_registration, catalog_image_delete
from simulation.product.views import *
from simulation.option.views import *

urlpatterns = [
    url(r'^$', HomeView.as_view(), name='index'),
    url(r'^center_list_change$', CenterListChangeView.as_view()),
    url(r'^left_list_change$', LeftListChangeView.as_view()),
    url(r'^get_product_list$', GetProductListView.as_view()),
    url(r'^get_fabric_content_list$', GetFabricContentListView.as_view()),
    url(r'^get_fabric_category_list$', GetFabricCategoryListView.as_view()),
    url(r'^get_coordi_center$', GetCoordiCenterView.as_view()),
    url(r'^new_couple_save$', new_couple_save),
    url(r'^origin_couple_update$', origin_couple_update),
    url(r'^change_slide_back_jacket$', change_slide_back_jacket),
    url(r'^get_couples_main_fabric$', get_couples_main_fabric),
    url(r'^couple_delete$', couple_delete),
    url(r'^couple_detail$', CoupleDetailView.as_view()),
    url(r'^get_catalog_image$', get_catalog_image),
    url(r'^catalog_image_registration$', catalog_image_registration),
    url(r'^catalog_image_delete$', catalog_image_delete),
]

#product admin
urlpatterns += [
    url(r'^product_list$', ProductListView.as_view(), name='productList'),
	url(r'^product_list/search$', ProductSearchList.as_view(), name='productSearch'),
	url(r'^product_list/csvUpdate$', productStockPriceUpdate, name='productCsvUpdate'),
]

# option admin
urlpatterns += [
    url(r'^option/$', OptionView.as_view(), name='manage_option'),
    url(r'^option/sub_category_list/$', OptionSubCategoryList),
    url(r'^option/option_list/$', OptionList),
    url(r'^option/add/$', AddOption),
    url(r'^option/delete/$', DeleteOption),
    url(r'^option/add_main_category/$', AddMainCategory),
    url(r'^option/add_sub_category/$', AddSubCategory),
    url(r'^option/delete_main_category/$', DeleteMainCategory),
    url(r'^option/delete_sub_category/$', DeleteSubCategory),

]