# -*- coding: utf-8 -*-
from django.views.generic import TemplateView, ListView, View
from simulation.models import *
from django.utils.decorators import method_decorator
from django.views.decorators.csrf import csrf_exempt
from django.shortcuts import render
from django.core import serializers
from django.http import HttpResponse, JsonResponse
from django.forms.models import model_to_dict

import json


class MappingIndexView(TemplateView):
    template_name = 'simulation/mapping/mapping.html'

@method_decorator(csrf_exempt, name='dispatch')
class CoupleLV(ListView):
    model = Couple
    #template_name = 'simulation/mapping/couple_list.html'

    def post(self, request, *args, **kwargs):
        season = request.POST['season']
        style = request.POST['style']
        popularity = request.POST['popularity'].upper()

        search_fitting = Fitting.objects.filter(fitting_category__season=season, fitting_category__style=style)
        couple_list = self.get_queryset().filter(girl_fitting__in=search_fitting, boy_fitting__in=search_fitting)

        if popularity == 'TRUE':
            couple_list = couple_list.filter(popularity=popularity)

        for couple in couple_list:
            couple.front_image = couple.front_image.url
            couple.back_image = couple.back_image.url

        data = serializers.serialize('json', couple_list)
        return HttpResponse(data, content_type='application/json')

@method_decorator(csrf_exempt, name='dispatch')
class ProductLV(ListView):
    model = ProductType

    def post(self, request, *args, **kwargs):
        season = request.POST['season']
        style = request.POST['style']

        boy_product_type = self.get_queryset().filter(fittingcategory=FittingCategory.objects.get(season=season, style=style, gender='boy'))
        girl_product_type = self.get_queryset().filter(fittingcategory=FittingCategory.objects.get(season=season, style=style, gender='girl'))

        coordi_set = {'girl': girl_product_type, 'boy': boy_product_type}
        for key, values in coordi_set.iteritems():
            type = []

            for value in values:
                product_list = []
                products = Product.objects.filter(product_type=value, season=season, style=style)

                for product in products:
                    fabric_list = []
                    fabrics = MainFabric.objects.filter(product = product)

                    for fabric in fabrics:
                        fabric_list.append({
                            'fabric_id': fabric.id,
                            'front_image': fabric.front_mapping_image.url,
                            'back_image': fabric.back_mapping_image.url
                        })

                    product_list.append({
                        'product_id': product.id,
                        'fabric': fabric_list
                    })

                type.append({
                    'type_id': value.id,
                    'type_name': value.name,
                    'type_kor_name': value.get_name_display(),
                    'type_index': value.index,
                    'product': product_list
                })
            coordi_set[key] = type

        print coordi_set

        # for product_type in product_type_list:
        #     product_list = Product.objects.filter(product_type=product_type, season=season, style=style)
        #
        #     for product in product_list:
        #         product.xml = MainFabric.objects.filter(product=product)[0].front_mapping_image.url
        #
        #     json_product_type = model_to_dict(product_type)
        #     json_product_list = serializers.serialize('json', product_list)
        #     product_type_set.append({'product_type':json_product_type, 'product_list':json_product_list})

        return HttpResponse(json.dumps(coordi_set), content_type='application/json')

@method_decorator(csrf_exempt, name='dispatch')
class CoordiProductLV(ListView):
    model = Couple

    def post(self, request, *args, **kwargs):
        couple = request.POST['couple']

        girl_product_set = self.get_queryset().get(id=couple).girl_fitting.product_set.all()
        boy_product_set = self.get_queryset().get(id=couple).boy_fitting.product_set.all()

        product_set = {'girl': girl_product_set, 'boy': boy_product_set}
        for key, values in product_set.iteritems():
            products = []
            for value in values:
                products.append({
                    'p_id': value.product.id,
                    'p_type': value.product.product_type_id,
                    'p_type_name': value.product.product_type.name,
                    'f_id': value.main_fabric.id,
                    'f_f_image': value.main_fabric.front_mapping_image.url,
                    'f_b_image': value.main_fabric.back_mapping_image.url
                })

            product_set[key] = {'product': products}


        return HttpResponse(json.dumps(product_set), content_type='application/json')



