# -*- coding: utf-8 -*-
# Generated by Django 1.9.8 on 2017-07-27 02:49
from __future__ import unicode_literals

from django.conf import settings
from django.db import migrations, models
import django.db.models.deletion
import simulation.models


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
    ]

    operations = [
        migrations.CreateModel(
            name='Couple',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('front_image', models.ImageField(upload_to=simulation.models.couple_upload_path)),
                ('back_image', models.ImageField(upload_to=simulation.models.couple_upload_path)),
                ('popularity', models.BooleanField(default=False)),
            ],
            options={
                'ordering': ['-id'],
                'db_table': 'sim_couple',
            },
        ),
        migrations.CreateModel(
            name='FinalFittingSet',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=30)),
            ],
            options={
                'db_table': 'sim_final_fitting_set',
            },
        ),
        migrations.CreateModel(
            name='Fitting',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('code', models.CharField(blank=True, max_length=30, null=True)),
                ('front_image', models.ImageField(upload_to=simulation.models.fitting_upload_path)),
                ('back_image', models.ImageField(upload_to=simulation.models.fitting_upload_path)),
            ],
            options={
                'ordering': ['-id'],
                'db_table': 'sim_fitting',
            },
        ),
        migrations.CreateModel(
            name='FittingCategory',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('season', models.CharField(choices=[('winter', '\ub3d9\ubcf5'), ('summer', '\ud558\ubcf5')], max_length=10)),
                ('style', models.CharField(choices=[('formal', '\uc815\ubcf5'), ('training', '\uccb4\uc721\ubcf5')], max_length=10)),
                ('gender', models.CharField(choices=[('boy', '\ub0a8\uc544'), ('girl', '\uc5ec\uc544')], max_length=10)),
            ],
            options={
                'db_table': 'sim_fitting_category',
            },
        ),
        migrations.CreateModel(
            name='Function',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=30)),
                ('image', models.ImageField(upload_to=b'')),
            ],
            options={
                'ordering': ['id'],
                'db_table': 'sim_function',
            },
        ),
        migrations.CreateModel(
            name='Grid',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('image', models.ImageField(upload_to=simulation.models.grid_upload_path)),
                ('side', models.CharField(choices=[('front', 'front'), ('back', 'back')], max_length=10)),
            ],
            options={
                'db_table': 'sim_grid',
            },
        ),
        migrations.CreateModel(
            name='MainFabric',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=20)),
                ('index', models.CharField(max_length=2)),
                ('stock', models.IntegerField(blank=True, null=True)),
                ('price', models.IntegerField(default=0, null=True)),
                ('image', models.ImageField(blank=True, null=True, upload_to=simulation.models.fabric_upload_path)),
                ('front_mapping_image', models.ImageField(blank=True, null=True, upload_to=simulation.models.fabric_upload_path)),
                ('back_mapping_image', models.ImageField(blank=True, null=True, upload_to=simulation.models.fabric_upload_path)),
                ('mapping_thumb', models.ImageField(blank=True, null=True, upload_to=simulation.models.fabric_upload_path)),
            ],
            options={
                'ordering': ['index'],
                'db_table': 'sim_main_fabric',
            },
        ),
        migrations.CreateModel(
            name='Mannequin',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('season', models.CharField(choices=[('winter', '\ub3d9\ubcf5'), ('summer', '\ud558\ubcf5')], max_length=10)),
                ('style', models.CharField(choices=[('formal', '\uc815\ubcf5'), ('training', '\uccb4\uc721\ubcf5')], max_length=10)),
                ('gender', models.CharField(choices=[('boy', '\ub0a8\uc544'), ('girl', '\uc5ec\uc544')], max_length=10)),
                ('front', models.ImageField(upload_to=b'')),
                ('back', models.ImageField(upload_to=b'')),
            ],
            options={
                'db_table': 'sim_mannequin',
            },
        ),
        migrations.CreateModel(
            name='Option',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=30)),
                ('image', models.ImageField(upload_to=b'')),
            ],
            options={
                'db_table': 'sim_option',
            },
        ),
        migrations.CreateModel(
            name='OptionMainCategory',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=30)),
            ],
            options={
                'db_table': 'sim_option_main_category',
            },
        ),
        migrations.CreateModel(
            name='OptionSubCategory',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=30)),
                ('main_category', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='simulation.OptionMainCategory')),
            ],
            options={
                'db_table': 'sim_option_sub_category',
            },
        ),
        migrations.CreateModel(
            name='Product',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=30)),
                ('season', models.CharField(choices=[('winter', '\ub3d9\ubcf5'), ('summer', '\ud558\ubcf5')], max_length=10, null=True)),
                ('style', models.CharField(choices=[('formal', '\uc815\ubcf5'), ('training', '\uccb4\uc721\ubcf5')], max_length=10, null=True)),
                ('code', models.CharField(max_length=30, null=True)),
                ('txm', models.FileField(blank=True, null=True, upload_to=simulation.models.product_upload_path)),
                ('xml', models.FileField(blank=True, null=True, upload_to=simulation.models.product_upload_path)),
            ],
            options={
                'ordering': ['-id'],
                'db_table': 'sim_product',
            },
        ),
        migrations.CreateModel(
            name='ProductType',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(choices=[('jacket', '\uc790\ucf13'), ('vest', '\uc870\ub07c'), ('shirts', '\uc154\uce20'), ('pants', '\ubc14\uc9c0'), ('skirt', '\uce58\ub9c8'), ('one-piece', '\uc6d0\ud53c\uc2a4'), ('jump-suit', '\uc810\ud504\uc288\ud2b8'), ('dress', '\ub4dc\ub808\uc2a4'), ('acc', '\uae30\ud0c0')], max_length=30)),
                ('index', models.IntegerField()),
            ],
            options={
                'db_table': 'sim_product_type',
            },
        ),
        migrations.CreateModel(
            name='SelectedCoupleSet',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('couple', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='simulation.Couple')),
                ('final_uniform_set', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='simulation.FinalFittingSet')),
                ('function_set', models.ManyToManyField(to='simulation.Function')),
            ],
            options={
                'db_table': 'sim_selected_couple_set',
            },
        ),
        migrations.CreateModel(
            name='SelectedFavoriteCoupleSet',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('couple', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='simulation.Couple')),
                ('final_uniform_set', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='simulation.FinalFittingSet')),
            ],
            options={
                'db_table': 'sim_selected_favorite_couple_set',
            },
        ),
        migrations.AddField(
            model_name='product',
            name='product_type',
            field=models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, to='simulation.ProductType'),
        ),
        migrations.AddField(
            model_name='product',
            name='user',
            field=models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, to=settings.AUTH_USER_MODEL),
        ),
        migrations.AddField(
            model_name='option',
            name='sub_category',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='simulation.OptionSubCategory'),
        ),
        migrations.AddField(
            model_name='mainfabric',
            name='product',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='simulation.Product'),
        ),
        migrations.AddField(
            model_name='grid',
            name='fabric',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='simulation.MainFabric'),
        ),
        migrations.AddField(
            model_name='fittingcategory',
            name='product_type_set',
            field=models.ManyToManyField(to='simulation.ProductType'),
        ),
        migrations.AddField(
            model_name='fitting',
            name='fitting_category',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='simulation.FittingCategory'),
        ),
        migrations.AddField(
            model_name='fitting',
            name='product_set',
            field=models.ManyToManyField(to='simulation.MainFabric'),
        ),
        migrations.AddField(
            model_name='couple',
            name='boy_fitting',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='boy', to='simulation.Fitting'),
        ),
        migrations.AddField(
            model_name='couple',
            name='girl_fitting',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='girl', to='simulation.Fitting'),
        ),
    ]
