# -*- coding: utf-8 -*-
import json
import shutil
import csv
from django.views.generic import TemplateView, ListView
from django.shortcuts import render_to_response
from django.http.response import HttpResponse
from django.template import RequestContext
from django.shortcuts  import redirect
from django.core.urlresolvers import reverse_lazy
from core.views import AdminRequiredMixin, page_calc
from simulation.models import Product, MainFabric


class ProductListView(AdminRequiredMixin, ListView):
	model = Product
	template_name = 'simulation/product/product_manage_list.html'
	paginate_by = 3
	
	def get_queryset(self):
		return Product.objects.order_by('-id')
	
	def get_context_data(self, **kwargs):
		context = super(ProductListView, self).get_context_data(**kwargs)
		paginator = context['paginator']
		page = self.request.GET.get('page')

		context['page_range'] = page_calc(paginator, page)
		context['first_page'] = 1
		context['last_page'] = paginator.num_pages
		context['selectedCategory'] = 'design'
		context['selectedSubCategory'] = 'product'
		return context


class ProductSearchList(AdminRequiredMixin, ListView):
	template_name = 'simulation/product/product_manage_list.html'
	model = Product
	paginate_by = 3
	
	def get_queryset(self):
		try:
			season = self.request.GET.get('season')
			style = self.request.GET.get('style')
			type = self.request.GET.get('product_type')
			name = self.request.GET.get('name')
		except:
			return redirect(reverse_lazy('simulation:productList'))
		
		object_list = self.model.objects.filter(season__icontains=season, style__icontains=style,
		                                        product_type__name__icontains=type, name__icontains=name).order_by('name')
		return object_list
	
	def get_context_data(self, **kwargs):
		context = super(ProductSearchList, self).get_context_data(**kwargs)
		paginator = context['paginator']
		page = self.request.GET.get('page')
		
		context['search_paging'] = True
		
		search_texts = ('season', 'style', 'product_type', 'name')
		
		for search_text in search_texts:
			if len(self.request.GET.get(search_text)) > 0:
				context[search_text] = self.request.GET.get(search_text)
			else:
				context[search_text] = ''
		
		context['page_range'] = page_calc(paginator, page)
		context['first_page'] = 1
		context['last_page'] = paginator.num_pages
		context['selectedCategory'] = 'design'
		context['selectedSubCategory'] = 'product'
		return context

def productStockPriceUpdate(request):
	try:
		productCsv = request.FILES['files']
	except:
		return False
	
	i = 1
	try:
		reader = csv.reader(productCsv)
		for productInfo in reader:
			if i >= 4:
				if len(productInfo[2]) > 0:
					try:
						codeSplit = str(productInfo[2]).split('-')
					except:
						print 'code split error'
						pass
					try:
						mainFabric = MainFabric.objects.filter(product__name=codeSplit[0]).get(index=codeSplit[1])
						print mainFabric
					except:
						print 'not search product!' + str(productInfo[2])
						pass
						
					#가격 지정
					if len(str(productInfo[5])) > 3:
						intPriceArray = productInfo[5].split(',')
						intPrice = str(intPriceArray[0]) + str(intPriceArray[1])
						mainFabric.price = int(intPrice)
						print 'price in'
					else:
						mainFabric.price = 0
						print 'price blank or -' + str(productInfo[5])
						pass
					
					print (productInfo[6] != '')
					#90 사이즈 재고 지정 나중에 dic 형태로 for 돌리면 되지 않을까
					if productInfo[6] == '' or str(productInfo[6]) == ' - ':
						mainFabric.stock90 = 0
						print '90 = 0'
					else:
						mainFabric.stock90 = int(productInfo[6])
						print '90in'
						
					# 100 사이즈 재고 지정
					if productInfo[7] == '' or productInfo[7] == ' - ':
						mainFabric.stock100 = 0
						print '100 = 0'
					else:
						mainFabric.stock100 = int(productInfo[7])
						print '100in'
						
					# 110 사이즈 재고 지정
					if productInfo[8] == '' or productInfo[8] == ' - ':
						mainFabric.stock110 = 0
						print '110 = 0'
					else:
						mainFabric.stock110 = int(productInfo[8])
						print '110in'
					
					# 120 사이즈 재고 지정
					if productInfo[9] == '' or productInfo[9] == ' - ':
						mainFabric.stock120 = 0
						print '120 = 0'
					else:
						mainFabric.stock120 = int(productInfo[9])
						print '120in'
						
					# 130 사이즈 재고 지정
					if productInfo[10] == '' or productInfo[10] == ' - ':
						mainFabric.stock130 = 0
						print '130 = 0'
					else:
						mainFabric.stock130 = int(productInfo[10])
						print '130in'
						
					# 140 사이즈 재고 지정
					if productInfo[11] == '' or productInfo[11] == ' - ':
						mainFabric.stock140 = 0
						print '140 = 0'
					else:
						mainFabric.stock140 = int(productInfo[11])
						print '140in'
						
					# 150 사이즈 재고 지정
					if productInfo[12] == '' or productInfo[12] == ' - ':
						mainFabric.stock150 = 0
						print '150 = 0'
					else:
						mainFabric.stock150 = int(productInfo[12])
						print '150in'
					
					#전체 합계
					try:
						mainFabric.stock = mainFabric.stock90 + mainFabric.stock100 + mainFabric.stock110 + \
						                   mainFabric.stock120 + mainFabric.stock130 + mainFabric.stock140 + mainFabric.stock150
					except Exception as e:
						print str(e)
						
					try:
						mainFabric.save()
						print str(i) + '번째 줄 완료'
					except Exception as e:
						print str(e)
				else:
					pass
			else:
				pass
			i += 1
	except Exception as e:
		print str(e)
		return redirect(reverse_lazy('simulation:productList'))
		
	return redirect(reverse_lazy('simulation:productList'))