/**
 * Created by KangHaeSeok on 2017-08-18.
 */


sc.catalogDetailClickEvent = function () {

    //최초 진입할때 파일의 값 (빈값)을 담는다
    var domEleArray = [$('#catalog-image').clone()];

    $(".ebookModal").fadeIn();
    $(".ebookclosebtn").unbind("click").bind("click",function(){
        $(".ebookModal").fadeOut();

        // 닫기 버튼 클릭시 빈값을 현재담겨진파일태그와 바꿔치기 한다. 그럼 이후에도 빈값이 들어온다
        domEleArray[1] = domEleArray[0].clone(true);
        $('#catalog-image').replaceWith(domEleArray[1]);
        $("#file_route").val("");

    });

    var currentCoupleIndex = sc.getSelectedCoupleIndex();
    $.ajax({
        url: '/simulation/custom_admin/get_catalog_image',
        data: {
          couple_id: currentCoupleIndex
        },
        dataType: 'json',
        success: function(data) {
            $(".ebookModalImgWrap img").attr("src", data.catalog_image_url);

            $("#catalogImageRegistration").unbind("click").bind("click",function(){
                sc.catalogImageRegistration(currentCoupleIndex);
            });

            $("#catalogImageDelete").unbind("click").bind("click",function(){
                sc.catalogImageDelete(currentCoupleIndex);
            });

        },
        error: function() {
            alert('error');
        }
    });

};

sc.catalogImageRegistration = function (coupleIndex) {

    if ($("#file_route").val() === ""){
        $.alert({title: 'Alert!', content: "파일이 선택되지 않았습니다.", useBootstrap: false});
        return false;
    }

    $.confirm({
        title: 'Confirm!',
        content: '파일을 업로드 하시겠습니까? 이후 카탈로그 리스트에 보여지게 되며 기존이미지는 삭제됩니다.',
        useBootstrap: false,
        buttons: {
            confirm: function () {

                var catalogImageFile = new FormData($("#catalogImageFileForm")[0]);
                catalogImageFile.append("couple_id", coupleIndex);

                $.ajax({
                    url: '/simulation/custom_admin/catalog_image_registration',
                    type: 'post',
                    data: catalogImageFile,
                    dataType: 'json',
                    processData: false,
                    contentType: false,
                    success: function(data) {
                        $(".ebookModalImgWrap img").attr("src", data.catalog_image_url);
                    },
                    error: function() {
                        alert('error');
                    }
                });

            },
            cancel: function () {
            }
        }
    });

};

sc.catalogImageDelete = function (coupleIndex) {

    $.confirm({
        title: 'Confirm!',
        content: '파일을 삭제 하시겠습니까?.',
        useBootstrap: false,
        buttons: {
            confirm: function () {

                $.ajax({
                    url: '/simulation/custom_admin/catalog_image_delete',
                    data: {
                      couple_id: coupleIndex
                    },
                    dataType: 'json',
                    success: function(data) {
                        $(".ebookModalImgWrap img").attr("src", data.catalog_image_url);
                    },
                    error: function() {
                        alert('error');
                    }
                });

            },
            cancel: function () {
            }
        }
    });

};