/* 코디 모달부분 전용 기능의 함수들 모음 js  */

$(document).ready(function () {
    sc.tabOfGenderToggle();
});


//코디 모달창 띄우기 기능
// 현재 성별, 프로덕트 리스트를 가져온다.
//프로덕트카테고리에 맞는 페브릭의 카테고리도 같이가져온다.
// 페브릭리스트는 프로덕트를 클릭할때만 발생한다
sc.loadCoordiModal =function (){

    sc.getProductList();
    sc.getFabricCategoryList();

    if((sc.season == "winter")&&(sc.style == "formal") ){
        $(".jacketOnOff").show();
    }else{
        $(".jacketOnOff").hide();
    }

    if (sc.getSelectedCoupleIndex() == undefined){
        $("#originCoupleSaveBtn").hide();
    }else{
        $("#originCoupleSaveBtn").show();
    }

};


//남녀전환시 프로덕트와 페브릭탭 hide, show 관리
sc.tabOfGenderToggle = function () {
    if(sc.gender == 'girl'){
        $('#girlProduct').show();
        $('#boyProduct').hide();
        $('#girlFabric').show();
        $('#boyFabric').hide();
    }else{
        $('#girlProduct').hide();
        $('#boyProduct').show();
        $('#girlFabric').hide();
        $('#boyFabric').show();
    }
}

//남여버튼 클릭이벤트 현재 성별이 아니면 바뀌는 메서트 실행
sc.genderChange = function(gender) {

    if (sc.gender != gender) {
        sc.gender = gender;
        sc.tabOfGenderToggle();

        var boyButton = $(".ModelCoodi .typebutton .gender .type-boy");
        var girlButton = $(".ModelCoodi .typebutton .gender .type-girl");
        if(gender === "boy"){
            boyButton.find('img').attr('src',boyButton.find('img').attr('src').replace('_b.png','_c.png'));
            girlButton.find('img').attr('src',girlButton.find('img').attr('src').replace('_c.png','_b.png'));
        }else{
            boyButton.find('img').attr('src',boyButton.find('img').attr('src').replace('_c.png','_b.png'));
            girlButton.find('img').attr('src',girlButton.find('img').attr('src').replace('_b.png','_c.png'));
        }

    }

};


//프로덕트 가져오는 함수 첫진입시에만 발생한다
//템플릿에 if문을 걸어서 context데이터에 없는 카테고리는 보이지 않는다
sc.getProductList =function (){
    $.ajax({
        url: '/simulation/custom_admin/get_product_list',
        data: {
          season: sc.season,
          style: sc.style
        },
        success: function(data) {
            $('#productReload').html(data);
            //리로드된 놈들은 기존의 이벤트를 인식하지 못한다 그래서 다시한번 호출해줌
            coodiTabMenu(); //이거 안하면 카테고리 클릭이 안된다
            sc.tabOfGenderToggle(); //이거 안하면 남녀 탭이 같이 보인다
        },
        error: function() {
            console.log('error');
        }
    });
};

//페브릭카테고리 가져오는 함수 첫진입시에만 발생한다
//템플릿에 if문을 걸어서 context데이터에 없는 카테고리는 보이지 않는다
sc.getFabricCategoryList =function (){
    $.ajax({
        url: '/simulation/custom_admin/get_fabric_category_list',
        data: {
          season: sc.season,
          style: sc.style
        },
        success: function(data) {
            $('#fabricReload').html(data);
            //리로드된 놈들은 기존의 이벤트를 인식하지 못한다 그래서 다시한번 호출해줌
            fabricTabMenu(); //이거 안하면 카테고리 클릭이 안된다
            sc.tabOfGenderToggle(); //이거 안하면 남녀 탭이 같이 보인다

            sc.selectedCoupleCoordiDetail();
        },
        error: function() {
            console.log('error');
        }
    });
};


//프로덕트 클릭이벤트 함수
//프로덕트카테고리+'Fabric'에 해당하는 id의 div html를 리로드할수 있게 reLoadFabricDivIndex값을 잡아준다
//프로덕트의 카테고리 값을 보내서 전역변수 세터를 호출해서 저장한다
//FabricDiv의 아이디값으로 페브릭 콘텐트 리로드 함수 호출
//메인이미지 출력용 sc.getCoordiCenter(); 호출
sc.productClickEvent =function (productPk, firstFabricPk, event){
    var currentProductCategory = $(event).closest("div.coodiTabContent").attr("id");//선택된 프로덕트의 카테고리 값 ex: boyShirtsCategory
    var reLoadFabricDivIndex = currentProductCategory + "Fabric";

    sc.selectedFabricSetter(firstFabricPk, currentProductCategory);
    sc.productCategoryException(currentProductCategory);
    sc.getFabricContentList(productPk, reLoadFabricDivIndex);
    sc.getCoordiCenter();

    //rel값이 reLoadFabricDivIndex인 li를 선택해서 클릭이벤트 발생시킨다.
    //상의 프로덕트를 클릭하면 자동으로 페브릭의 상의카테고리를 보여준닷
    $("li[rel='"+reLoadFabricDivIndex+"']").click();

    // 프로덕트 selected 표시
    $.each($(event).siblings(), function () {
        $(this).removeClass("selected");
    });
    $(event).addClass("selected");

    // 메인페브릭탭 첫번째 오브젝트에 selected
    $("#" + reLoadFabricDivIndex).find("li").first().find(".fabricImg").addClass("selected");
};

//프로덕트 카테고리에 따라서 페브릭 내용물이 출력되는 기능
//productPk를 가지고 해당하는 프로덕트의 모든 main fabric을 가져온다.
// fabric_tab_detail.html 을 리로드해서 $("#boyShirtsCategoryFabric")의 html 을 구성해준다
// 페브릭카테고리가 바지에 active 되어있으면 눈에 보이진 않는다. 페브릭상의를 클릭했을때 리로드한 내용이 보여진다. 이미 리로드는 되어있다. 아니다 수정했다 클릭한 카테고리로 자동 이동한다.
// 첫진입시 선택페브릭 보여줘야해서 동기식으로 변경
sc.getFabricContentList = function (productPk, reLoadFabricDivIndex) {
    $.ajax({
        url: '/simulation/custom_admin/get_fabric_content_list',
        async: false,
        data: {
          product_id: productPk
        },
        success: function(data) {
            $('#'+reLoadFabricDivIndex).html(data);
        },
        error: function() {
            console.log('error');
        }
    });
};


//페브릭 클릭 이벤트
//클릭된 태그의 부모를 찾아서 id를 받아온다 이걸 스플릿해서 해당 프로덕트의 카테고리를 알아온다
//선택된 페브릭의 아이디와 프로덕트카테고리로 페브릭전역변수 세터로 보낸다
//이후 메인모델을 리로드한다. sc.getCoordiCenter(); 에서 모든 전역변수를 담는다
sc.fabricClickEvent = function (mainFabricPk, event) {
    var currentFabricDivIndex = $(event).closest("div.fabricTabContent").attr("id");
    var currentProductCategory = currentFabricDivIndex.split('Fabric')[0]// ex: boyShirtsCategoryFabric에서 boyShirtsCategory으로 바꾼다

    sc.selectedFabricSetter(mainFabricPk, currentProductCategory);
    sc.getCoordiCenter();

    // 프로덕트 selected 표시
    $.each($(event).siblings(), function () {
        $(this).find(".fabricImg").removeClass("selected");
    });
    $(event).find(".fabricImg").addClass("selected");
};


//모델코디 메인이미지 출력함수
//  sc.girlFabricList sc.boyFabricList 통해 전역변수에 저장된 각각의 선택된 프로덕트의 메인페브릭이미지들을 가져온다
//가운데에 조합된 모델모습 리로드 함수
sc.getCoordiCenter =function (){

    //선택된 페브릭조각들을 이제 하나로 모은다
    sc.getCoordiFabricList();
    var currentFabricList = [];
    var modelDivIndex = "";

    //남자인지 여자인지에 따라서 리스트값 넣어주고 리로드할 div아이디값을 설정해준다.
    if(sc.gender == "girl"){
        currentFabricList = sc.girlFabricList;
        modelDivIndex = "mainGirlModel";
    }else {
        currentFabricList = sc.boyFabricList;
        modelDivIndex = "mainBoyModel";
    }

    $.ajax({
        url: '/simulation/custom_admin/get_coordi_center',
        data: {
          coordi_fabric_list: currentFabricList,
          season: sc.season,
          gender: sc.gender,
          style: sc.style
        },
        success: function(data) {
            $("#"+modelDivIndex).html(data);

            // 리로드 완료 후 자켓숨기기와 뒷모습 보이기 판별 실행
            sc.jacketAndBackVisibleEvent();
        },
        error: function() {
            console.log('error');
        }
    });
};


//닫기 버튼 클릭 이벤트
//alert으로 한번 물어보고 model 이미지 영역을 지운다음 전역변수를 초기화 해준다
//custom_admin_mapping.js의 CoodiStartBtn()와 중복된다 거기 주석하고 fadeOut 기능 가져옴
// 수정 : 그냥 닫고 새로고침한다
sc.coordiCloseBtnEvent = function () {

    $.confirm({
        title: 'Confirm!',
        content: '종료하시겠습니까?',
        useBootstrap: false,
        buttons: {
            confirm: function () {
                // $("#mainGirlModel").html('');
                // $("#mainBoyModel").html('');
                // sc.variableInitialization();
                // $(".ModelCoodi").fadeOut();
                // $(".type-girl").click();
                location.reload();
            },
            cancel: function () {
            }
        }
    });

};


//현재 지정된 프로덕트 삭제 이벤트
sc.productDelete= function (event) {
    var productCategory = $(event).closest("div.coodiTabContent").attr("id");//선택된 프로덕트의 카테고리 값 ex: boyShirtsCategory
    var fabricDivIndex = productCategory + "Fabric";

    if(productCategory == "boyShirtsCategory"){
        sc.shirtsBoyFabric = 0;
    }else if(productCategory == "boyJacketCategory"){
        sc.jacketBoyFabric = 0;
    }else if(productCategory == "boyVestCategory"){
        sc.vestBoyFabric = 0;
    }else if(productCategory == "boyPantsCategory"){
        sc.pantsBoyFabric = 0;
    }else if(productCategory == "boyJumpSuitCategory"){
        sc.jumpSuitBoyFabric = 0;
    }else if(productCategory == "boyAccCategory"){
        sc.accessoryBoyFabric = 0;
    }else if(productCategory == "girlShirtsCategory"){
        sc.shirtsGirlFabric = 0;
    }else if(productCategory == "girlJacketCategory"){
        sc.jacketGirlFabric = 0;
    }else if(productCategory == "girlVestCategory"){
        sc.vestGirlFabric = 0;
    }else if(productCategory == "girlPantsCategory"){
        sc.pantsGirlFabric = 0;
    }else if(productCategory == "girlSkirtCategory"){
        sc.skirtGirlFabric = 0;
    }else if(productCategory == "girlOnePieceCategory"){
        sc.onePieceGirlFabric = 0;
    }else if(productCategory == "girlJumpSuitCategory"){
        sc.jumpSuitGirlFabric = 0;
    }else if(productCategory == "girlDressCategory"){
        sc.dressGirlFabric = 0;
    }else if(productCategory == "girlAccCategory"){
        sc.accessoryGirlFabric = 0;
    }else {
        alert('productCategory의 값이 이상하다.')
    }

    $("#" + fabricDivIndex).html("");
    sc.getCoordiCenter();
};


//자켓 보이기 클릭이벤트
sc.jacketHideClickEvent = function () {
    if(sc.jacketHide){
        sc.jacketHide = false;
        $("#jacketToggleCheck").prop("checked", true);
    }else {
        sc.jacketHide = true;
        $("#jacketToggleCheck").prop("checked", false);
    }
    sc.jacketAndBackVisibleEvent();
};


// 코디 부분 뒷모습보기 버튼 클릭 이벤트
sc.coordiBackClick = function () {
    if(sc.isCoordiBack){
        sc.isCoordiBack = false;
    }else {
        sc.isCoordiBack = true;
    }
    sc.jacketAndBackVisibleEvent();
};


// 코디 부분 뒷모습보기 판별후 show hide 이벤트
sc.jacketAndBackVisibleEvent = function () {

    if(sc.isCoordiBack){ //뒷모습
        $(".isCoordiFront").hide();
        $(".isCoordiBack").show();
        if(sc.jacketHide){ //뒷모습 & 자켓숨김
            $(".jacketMainFabric").hide();
        }else{  //뒷모습 & 자켓보임
            if( !(sc.jacketHide) && (sc.jacketBoyFabric > 0) ){              //뒷모습 & 자켓보임 & 남자 자켓 선택한상태
                $("#mainBoyModel .vestMainFabric").hide();
            }if( !(sc.jacketHide) && (sc.jacketGirlFabric > 0) ){            //뒷모습 & 자켓보임 & 여자 자켓 선택한상태
                $("#mainGirlModel .vestMainFabric").hide();
            }
        }
    }else {  //앞모습
        $(".isCoordiFront").show();
        $(".isCoordiBack").hide();
        if(sc.jacketHide){   //앞모습 & 자켓숨김
            $(".jacketMainFabric").hide();
        }else{
            if( !(sc.jacketHide) && (sc.jacketBoyFabric > 0) ){              //앞모습 & 자켓보임 & 남자 자켓 선택한상태
                $("#mainBoyModel .vestMainFabric").hide();
            }if( !(sc.jacketHide) && (sc.jacketGirlFabric > 0) ){            //앞모습 & 자켓보임 & 여자 자켓 선택한상태
                $("#mainGirlModel .vestMainFabric").hide();
            }
        }
    }

};


// 현재 셀렉트된 커플의 정보를 가져와서 뿌려준다
// 커플의 메인페브릭 리스트들을 전역변수에 한땀한땀 담아준다
// 그리고 해당하는 메인페브릭의 프로덕트에 있는 페브릭들을 뿌려준다
// 그리고 전역변수에 담긴 리스트들을 sc.getCoordiCenter 통해서 가운데 코디이미지 뿌려준다
sc.selectedCoupleCoordiDetail = function () {

    var currentCoupleIndex = sc.getSelectedCoupleIndex();

    $.ajax({
        url: '/simulation/custom_admin/get_couples_main_fabric',
        data: {
          couple_id: currentCoupleIndex
        },
        dataType: 'json',
        success: function(data) {
            $.each(data.boy_context_list, function(key, value) {
                sc.selectedFabricSetter(value.fabric_index, value.product_category);
                sc.getFabricContentList(value.product_index, value.product_category + "Fabric");

                sc.coupleSelectedProductMark(value.product_index, value.product_category);
                sc.coupleSelectedFabricMark(value.fabric_index, value.product_category + "Fabric");
            });
            $.each(data.girl_context_list, function(key, value) {
                sc.selectedFabricSetter(value.fabric_index, value.product_category);
                sc.getFabricContentList(value.product_index, value.product_category + "Fabric");

                sc.coupleSelectedProductMark(value.product_index, value.product_category);
                sc.coupleSelectedFabricMark(value.fabric_index, value.product_category + "Fabric");
            });

            $("#originCoupleName").val(data.couple_name);

            //남녀는 다른 div를 쓰기때문에 여자 마네킹 부르게 한번 호출하고 다시 남자 마네킹 호출하고 전역변수를 girl로 맞춰줌
            sc.getCoordiCenter();
            sc.gender = "girl";
            sc.getCoordiCenter();
            sc.gender = "boy";
        },
        error: function() {
            // 코디 선택해서 들어온게 아니어도 마네킹은 띄워준다
            sc.getCoordiCenter();
            sc.gender = "girl";
            sc.getCoordiCenter();
            sc.gender = "boy";
        }
    });

};


sc.coupleSelectedProductMark = function (productIndex, productCategory) {
    $.each($("#" + productCategory).find("li"), function () {
        if($(this).data("product-index") === productIndex){
            $(this).addClass("selected");
        }
    });
};


sc.coupleSelectedFabricMark = function (fabricIndex, fabricCategory) {
    console.log(fabricCategory);
    $.each($("#" + fabricCategory).find("li"), function () {
        if($(this).data("fabric-index") === fabricIndex){
            $(this).find(".fabricImg").addClass("selected");
        }
    });
};