/**
 * Created by KangHaeSeok on 2017-08-02.
 */

sc.orderIndex = 0;
sc.finalFittingIndex = 0;

$(document).ready(function () {
    sc.selectedCoupleList();
    sc.favoriteCoupleList();
});


////////////////////////////////// 커플 세트 기능 관련 ///////////////////////////////////////


//세트보기 부분 리로드
sc.selectedCoupleList =function () {

    $.ajax({
        url: '/simulation/extend_mapping/selected_couple_list',
        data: {
            final_fitting_id: sc.finalFittingIndex,
            order_id: sc.orderIndex
        },
        success: function(data) {
            $("#tab6").html(data);
        },
        error: function() {
            console.log('error');
        }
    });

};


//커플 세트 등록하기
sc.coupleSelect = function () {

    $.confirm({
        title: 'Confirm!',
        content: '현재 코디를 확정세트에 저장하시겠습니까?',
        useBootstrap: false,
        buttons: {
            confirm: function () {

                var currentCoupleIndex = sc.getSelectedCoupleIndex();
               $.ajax({
                    url: '/simulation/extend_mapping/couple_select',
                    dataType: 'json',
                    data: {
                        couple_id: currentCoupleIndex,
                        season: sc.season,
                        style: sc.style,
                        final_fitting_id: sc.finalFittingIndex
                    },
                    success: function(data) {

                        $.alert({title: '알림!', content: data.message, useBootstrap: false});
                        //등록 완료 후 내용 리로드
                        sc.selectedCoupleList();

                    },
                    error: function() {
                        console.log('error');
                    }
                });

            },
            cancel: function () {

            }
        }
    });

};


//커플의 selected set 관계끊기 (세트보기에서 삭제)
sc.coupleSelectedRelationCut = function (currentCoupleIndex) {

    $.confirm({
        title: 'Confirm!',
        content: '세트 목록에서 삭제하시겠습니까?',
        useBootstrap: false,
        buttons: {
            confirm: function () {

                $.ajax({
                    url: '/simulation/extend_mapping/selected_relation_cut',
                    dataType: 'json',
                    data: {
                        couple_id: currentCoupleIndex,
                        final_fitting_id: sc.finalFittingIndex
                    },
                    success: function(data) {
                        $.alert({title: 'Alert!', content: data.message, useBootstrap: false});
                        //삭제 완료 후 내용 리로드
                        sc.selectedCoupleList();
                    },
                    error: function() {
                        console.log('error');
                    }
                });

            },
            cancel: function () {

            }
        }
    });

};




////////////////////////////////// 커플 관심 기능 관련 ///////////////////////////////////////


//저장목록보기 부분 리로드
//저장목록은 season과 style에도 영향을 받으니 가운데 슬라이드가 리로드될때 같이 리로드된다
sc.favoriteCoupleList =function () {

    $.ajax({
        url: '/simulation/extend_mapping/favorite_couple_list',
        data: {
            season: sc.season,
            style: sc.style,
            final_fitting_id: sc.finalFittingIndex
        },
        success: function(data) {
            $("#tab5").html(data);
        },
        error: function() {
            console.log('error');
        }
    });

};


// 위에 별 클릭했을때
sc.starClickEvent = function (event) {
    var image_name = $(event).find("img").attr("src");

    //관심에서 제외시켰을때
    if (image_name == "/static/simulation/images/star_c.png"){
        $(event).find("img").attr("src",$(event).find("img").attr("src").replace("_c.png","_n.png"));

        var currentCoupleIndex = sc.getSelectedCoupleIndex();
        sc.coupleFavoriteRelationCut(currentCoupleIndex);
    }
    //관심리스트에 추가했을때
    else if (image_name == "/static/simulation/images/star_n.png"){
        $(event).find("img").attr("src",$(event).find("img").attr("src").replace("_n.png","_c.png"));

        sc.coupleFavoriteEvent();
    }
};


//커플 관심리스트에 저장하기
sc.coupleFavoriteEvent = function () {
    var currentCoupleIndex = sc.getSelectedCoupleIndex();

    $.ajax({
        url: '/simulation/extend_mapping/couple_favorite',
        dataType: 'json',
        data: {
            couple_id: currentCoupleIndex,
            season: sc.season,
            style: sc.style,
            final_fitting_id: sc.finalFittingIndex
        },
        success: function(data) {
            $.alert({title: 'Alert!', content: data.message, useBootstrap: false});
            if ( data.error == 'star_image_off' ){
                $(".swiper-slide-active").find(".model_star").find("img").attr("src", $(".swiper-slide-active").find(".model_star").find("img").attr("src").replace("_c.png","_n.png"));
            }
            sc.favoriteCoupleList();
        },
        error: function() {
            console.log('error');
        }
    });

};


// 커플 관심리스트에서 제외하기 기능 (삭제기능)
sc.coupleFavoriteRelationCut =function (currentCoupleIndex) {

    $.confirm({
        title: 'Confirm!',
        content: '관심 목록에서 삭제하시겠습니까?',
        useBootstrap: false,
        buttons: {
            confirm: function () {

                $.ajax({
                    url: '/simulation/extend_mapping/favorite_relation_cut',
                    dataType: 'json',
                    data: {
                        couple_id: currentCoupleIndex,
                        final_fitting_id: sc.finalFittingIndex
                    },
                    success: function(data) {
                        $.alert({title: 'Alert!', content: data.message, useBootstrap: false});

                        //삭제 완료 후 내용 리로드
                        sc.favoriteCoupleList();

                        //완료 후 star 이미지 회색으로 바꿔줌
                        $(".swiper-slide").each(function () {
                            if( $(this).children().first().val() == currentCoupleIndex ){
                                $(this).find(".model_star").find("img").attr("src", $(this).find(".model_star").find("img").attr("src").replace("_c.png","_n.png"));
                            }
                        });

                    },
                    error: function() {
                        console.log('error');
                    }
                });

            },
            cancel: function () {

                $(".swiper-slide").each(function () {
                    if( $(this).children().first().val() == currentCoupleIndex ){
                        $(this).find(".model_star").find("img").attr("src", $(this).find(".model_star").find("img").attr("src").replace("_n.png","_c.png"));
                    }
                });

            }
        }
    });

};